<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="Strings.xsl"/>
  <xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="UTF-8" indent="yes"/>	
  
  <!-- Indexing for cross referencing -->
  <xsl:key name="BaseTable-TableAliasIndex" match="/FMPReport/File/RelationshipGraph/TableList/Table" use="@name"/>	
  <xsl:key name="TableAlias-BaseTableIndex" match="/FMPReport/File/RelationshipGraph/TableList/Table" use="@baseTable"/>			
  <xsl:key name="Relationship-LeftTableAliasIndex" match="/FMPReport/File/RelationshipGraph/RelationshipList/Relationship" use="LeftTable/@name"/>
  <xsl:key name="Relationship-RightTableAliasIndex" match="/FMPReport/File/RelationshipGraph/RelationshipList/Relationship" use="RightTable/@name"/>	
  <xsl:key name="FileReferenceIndex" match="/FMPReport/File/FileReferenceCatalog/*" use="@name"/>	
  <xsl:key name="BaseTableIndex" match="/FMPReport/File/BaseTableCatalog/BaseTable" use="@name"/>
  <xsl:key name="LayoutIndex" match="/FMPReport/File/LayoutCatalog//Layout" use="concat(@name,@id)"/>
  <xsl:key name="VLIndex" match="/FMPReport/File/ValueListCatalog/ValueList" use="@name"/>
  <xsl:key name="ScriptIndex" match="/FMPReport/File/ScriptCatalog/Script | /FMPReport/File/ScriptCatalog//Group/Script" use="concat(@name, @id)"/>
  <xsl:key name="CustomMenuIndex" match="/FMPReport/File/CustomMenuCatalog/CustomMenu" use="@id"/>
  <xsl:key name="CustomMenuSetIndex" match="/FMPReport/File/CustomMenuSetCatalog/CustomMenuSet" use="@id"/>
  <xsl:key name="CustomMenuSetNameIndex" match="/FMPReport/File/CustomMenuSetCatalog/CustomMenuSet" use="@name"/>
  <xsl:key name="AccountIndex" match="/FMPReport/File/AccountCatalog/Account" use="@name"/>
  <xsl:key name="PrivilegeSetIndex" match="/FMPReport/File/PrivilegesCatalog/PrivilegeSet" use="@name"/>
  <xsl:key name="ExtendedPrivilegeIndex" match="/FMPReport/File/ExtendedPrivilegeCatalog/ExtendedPrivilege" use="@name"/>
  <xsl:key name="CustomFunctionIndex" match="/FMPReport/File/CustomFunctionCatalog/CustomFunction" use="@name"/>
  <xsl:key name="LayoutByFieldIndex" match="/FMPReport/File/LayoutCatalog//Layout" use="*/*//Field/@name"/>
  <xsl:key name="LayoutByTableIndex" match="/FMPReport/File/LayoutCatalog//Layout" use="*/*//Field/@table"/>
  <xsl:key name="ScriptByFieldIndex" match="/FMPReport/File/ScriptCatalog/Script | /FMPReport/File/ScriptCatalog//Group/Script" use="*/*//Field/@name"/>
  <xsl:key name="VLByFieldIndex" match="/FMPReport/File/ValueListCatalog/ValueList" use="*/Field/@name"/>
  <xsl:key name="ScriptByLayoutIndex" match="/FMPReport/File/ScriptCatalog/Script | /FMPReport/File/ScriptCatalog//Group/Script" use=".//Layout/@id"/>
  <xsl:key name="FieldByTableOccurrenceIndex" match="/FMPReport/File/BaseTableCatalog/BaseTable/FieldCatalog/Field" use="*//Field/@table"/>
  <xsl:key name="LayoutByVLIndex" match="/FMPReport/File/LayoutCatalog//Layout" use=".//Object/FieldObj/DDRInfo/ValueList/@name"/>
  <xsl:key name="LayoutByScriptIndex" match="/FMPReport/File/LayoutCatalog//Layout" use="Object/GroupButtonObj/Step/Script/@id"/>
  
  <!-- Template for generating the main report. The main entry point for the transformation. -->
  <xsl:template name="MainReport" match="/">
    <html>
      <head>				
				<title>
					<xsl:value-of select="File/@name"/>
				</title>
				<link href="{$valReportCSS}" type="text/css" rel="stylesheet"/>
      </head>	
      <body>		
				<xsl:call-template name="Table-Overview">
					<xsl:with-param name="inFile" select="FMPReport/File"/>
				</xsl:call-template>
				<!-- Construct the overview table -->					
				<xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="ReplaceString">
    <xsl:param name="inputString"/>
    <xsl:param name="findString"/>
    <xsl:param name="replaceString"/>
    
    <xsl:choose>
      <xsl:when test="contains($inputString, $findString)">
				<xsl:value-of select="concat(substring-before($inputString, $findString), $replaceString)"/>
				<xsl:call-template name="ReplaceString">
					<xsl:with-param name="inputString" select="substring-after($inputString, $findString)"/>
					<xsl:with-param name="findString" select="$findString"/>
					<xsl:with-param name="replaceString" select="$replaceString"/>
				</xsl:call-template>				
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$inputString"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- Below are templates for generating different sections of the report -->		

  <!-- anchoring and links -->
  <xsl:template name="Link-WithAnchor">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;a href=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
    <xsl:value-of select="$inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="AnchorPoint">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;a name=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
    <xsl:value-of select="$inDisplayText"/>		
  </xsl:template>
  
  <!--Inserts an anchor point with no text description-->
  <xsl:template name="AnchorPoint-NoText">
    <xsl:param name="inAnchor"/>
    <xsl:text disable-output-escaping="yes">&lt;a name=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>	
  </xsl:template>  
  
  <xsl:template name="ItalicAnchorPoint">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;a name=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:text disable-output-escaping="yes">&quot;/&gt;&lt;em&gt;</xsl:text>
    <xsl:value-of select="$inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;/em&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="TableAnchorPoint">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;a name=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
    <xsl:text disable-output-escaping="yes">&lt;em&gt;</xsl:text>
    <xsl:value-of select="$inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;/em&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="ItalicLink-WithAnchor">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;a href=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:text disable-output-escaping="yes">&quot;&gt;&lt;em&gt;</xsl:text>
    <xsl:value-of select="$inDisplayText"/>
    <xsl:text disable-output-escaping="yes">&lt;/em&gt;&lt;/a&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="FullFieldLink-WithAnchor">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inTableName"/>
    <xsl:param name="inFieldName"/>
    <xsl:text disable-output-escaping="yes">&lt;a href=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:text disable-output-escaping="yes">&quot;&gt;&lt;em&gt;</xsl:text>
    <xsl:value-of select="$inTableName"/>
    <xsl:text disable-output-escaping="yes">&lt;/em&gt;</xsl:text>
    <xsl:value-of select="concat('::',$inFieldName)"/>
    <xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>			
  </xsl:template>
  
  <xsl:template name="FullFieldLink-WithAnchor-WithTarget">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inTableName"/>
    <xsl:param name="inFieldName"/>
    <xsl:param name="inTarget"/>
    <xsl:text disable-output-escaping="yes">&lt;a href=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:value-of select="concat('&quot; target=&quot;',$inTarget, '&quot;&gt;')" disable-output-escaping="yes"/>
    <xsl:text disable-output-escaping="yes">&lt;em&gt;</xsl:text>
    <xsl:value-of select="$inTableName"/>
    <xsl:text disable-output-escaping="yes">&lt;/em&gt;</xsl:text>
    <xsl:value-of select="concat('::',$inFieldName)"/>
    <xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>			
  </xsl:template>

  <xsl:template name="FullLayoutLink-WithAnchor-WithTarget">
    <xsl:param name="inAnchor"/>
    <xsl:param name="inLayoutName"/>
    <xsl:param name="inTarget"/>
    <xsl:text disable-output-escaping="yes">&lt;a href=&quot;</xsl:text>
    <xsl:value-of select="$inAnchor"/>
    <xsl:value-of select="concat('&quot; target=&quot;',$inTarget, '&quot;&gt;')" disable-output-escaping="yes"/>
    <xsl:value-of select="$inLayoutName"/>
    <xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text>
  </xsl:template>
  
  
  <!-- Section reference. -->
  <xsl:template name="SectionReference">
    <xsl:param name="inSection"/>
    <xsl:param name="inCount"/>
    <xsl:choose>
      <xsl:when test="$inCount &gt; 0">
				<xsl:call-template name="Link-WithAnchor">
					<xsl:with-param name="inAnchor" select="concat('#',$inSection, $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$inCount"/>
				</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$inCount"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--FieldDefinition reference: must pass a Field node under the BaseTable node! -->
  <xsl:template name="FieldDefinitionReference">
    <xsl:param name="inFieldDefinition"/>	
    <xsl:variable name="baseTable" select="$inFieldDefinition/ancestor::BaseTable"/>
    <xsl:choose>
      <xsl:when test="string-length($inFieldDefinition/@name)='0'">
				<xsl:value-of select="$valMissingField"/>
      </xsl:when>				
      <xsl:when test="string-length($baseTable/@name)='0'">
				<xsl:value-of select="$valMissingBaseTable"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="FullFieldLink-WithAnchor">
					<xsl:with-param name="inAnchor" select="concat('#',$baseTable/@id, $inFieldDefinition/@id, $kAnchorField)"/>
					<xsl:with-param name="inTableName" select="$baseTable/@name"/>
					<xsl:with-param name="inFieldName" select="$inFieldDefinition/@name"/>
				</xsl:call-template>	
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Field reference: must pass a Field node! -->
  <xsl:template name="FieldReference-ShowTableAlias">
    <xsl:param name="inField"/>		
    <xsl:choose>
      <xsl:when test="string-length($inField/@name)='0'">
				<xsl:value-of select="$valMissingField"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="tableAlias" select="key('BaseTable-TableAliasIndex',$inField/@table)"/>				
				<xsl:variable name="fileReference" select="key('FileReferenceIndex', $tableAlias/FileReference/@name)"/>		
				<xsl:choose>
					<xsl:when test="$tableAlias">				
						<xsl:choose>
							<xsl:when test="$tableAlias/FileReference">
								<xsl:choose>
									<xsl:when test="$fileReference/@link">								
										<xsl:call-template name="FullFieldLink-WithAnchor-WithTarget">
											<xsl:with-param name="inAnchor" select="concat('../',$fileReference/@link,'/index.html','?',$tableAlias/@baseTableId, $inField/@id, $kAnchorField)"/>
											<xsl:with-param name="inTableName" select="$inField/@table"/>
											<xsl:with-param name="inFieldName" select="$inField/@name"/>
											<xsl:with-param name="inTarget" select="'_top'"/>
										</xsl:call-template>															
									</xsl:when>
									<xsl:otherwise>
										<em><xsl:value-of select="$inField/@table"/></em><xsl:value-of select="concat('::', $inField/@name)"/>
									</xsl:otherwise>
								</xsl:choose>						
							</xsl:when>
							<xsl:otherwise>														
								<xsl:call-template name="FullFieldLink-WithAnchor">
									<xsl:with-param name="inAnchor" select="concat('#',$tableAlias/@baseTableId, $inField/@id, $kAnchorField)"/>
									<xsl:with-param name="inTableName" select="$inField/@table"/>
									<xsl:with-param name="inFieldName" select="$inField/@name"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<em><xsl:value-of select="$inField/@table"/></em><xsl:value-of select="concat('::', $inField/@name)"/>					
					</xsl:otherwise>
				</xsl:choose>					
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <xsl:template name="FieldReference-ShowBaseTable">
    <xsl:param name="inField"/>	
    <xsl:choose>
      <xsl:when test="string-length($inField/@name)='0'">
				<xsl:value-of select="$valMissingField"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="tableAlias" select="key('BaseTable-TableAliasIndex',$inField/@table)"/>
				<xsl:variable name="fileReference" select="key('FileReferenceIndex', $tableAlias/FileReference/@name)"/>
				<xsl:choose>
					<xsl:when test="$tableAlias">
						<xsl:choose>
							<xsl:when test="$tableAlias/FileReference">
								<xsl:choose>
									<xsl:when test="$fileReference/@link">
										<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
											<xsl:with-param name="inFileLink" select="concat('../',$fileReference/@link,'/index.html', '?',$tableAlias/@baseTableId, $inField/@id,$kAnchorField)"/>
											<xsl:with-param name="inTarget"	select="'_top'"/>
											<xsl:with-param name="inDisplayText" select="concat($tableAlias/@baseTable, '::', $inField/@name)"/>
										</xsl:call-template>								
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$inField/@name"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="Link-WithAnchor">
									<xsl:with-param name="inAnchor" select="concat('#',$tableAlias/@baseTableId, $inField/@id, $kAnchorField)"/>
									<xsl:with-param name="inDisplayText" select="concat($tableAlias/@baseTable, '::', $inField/@name)"/>
								</xsl:call-template>												
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inField/@name"/>
					</xsl:otherwise>
				</xsl:choose>			
      </xsl:otherwise>
    </xsl:choose>	
  </xsl:template>
  
  <xsl:template name="FieldReference-ShowFieldNameOnly">
    <xsl:param name="inField"/>	
    <xsl:choose>
      <xsl:when test="string-length($inField/@name)='0'">
				<xsl:value-of select="$valMissingField"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="tableAlias" select="key('BaseTable-TableAliasIndex',$inField/@table)"/>
				<xsl:variable name="fileReference" select="key('FileReferenceIndex', $tableAlias/FileReference/@name)"/>
				<xsl:choose>
					<xsl:when test="$tableAlias">
						<xsl:choose>
							<xsl:when test="$tableAlias/FileReference">
								<xsl:choose>
									<xsl:when test="$fileReference/@link">
										<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
											<xsl:with-param name="inFileLink" select="concat('../',$fileReference/@link,'/index.html','?', $tableAlias/@baseTableId, $inField/@id,$kAnchorField)"/>
											<xsl:with-param name="inTarget" select="'_top'"/>
											<xsl:with-param name="inDisplayText" select="$inField/@name"/>
										</xsl:call-template>								
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$inField/@name"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="Link-WithAnchor">
									<xsl:with-param name="inAnchor" select="concat('#',$tableAlias/@baseTableId, $inField/@id, $kAnchorField)"/>
									<xsl:with-param name="inDisplayText" select="$inField/@name"/>
								</xsl:call-template>						
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inField/@name"/>
					</xsl:otherwise>
				</xsl:choose>		
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>	
  
  <!-- BaseTable reference: must pass a BaseTable name!-->	
  <xsl:template name="BaseTableReference">
    <xsl:param name="inBaseTable"/>	
    <xsl:choose>
      <xsl:when test="string-length($inBaseTable)='0'">
				<xsl:value-of select="$valMissingBaseTable"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="baseTable" select="key('BaseTableIndex',$inBaseTable)"/>
				<!-- Check to see if there is a BaseTable node under BaseTableCatalog! -->
				<xsl:choose>
					<xsl:when test="$baseTable">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#',$baseTable/@id, $kAnchorBaseTable)"/>
							<xsl:with-param name="inDisplayText" select="$inBaseTable"/>
						</xsl:call-template>					
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inBaseTable"/>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--TableAlias reference: must pass a Table node! -->
  <xsl:template name="TableAliasReference">
    <xsl:param name="inTableAlias"/>	
    <xsl:choose>
      <xsl:when test="string-length($inTableAlias/@name)='0'">
				<xsl:value-of select="$valMissingTableOccurrence"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>		
					<xsl:when test="$inTableAlias/FileReference">
						<xsl:variable name="fileRef" select="key('FileReferenceIndex',$inTableAlias/FileReference/@name)"/>
						<xsl:choose>
							<xsl:when test="$fileRef/@link">
								<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
									<xsl:with-param name="inFileLink" select="concat('../',$fileRef/@link,'/index.html', '?',$inTableAlias/@baseTableId, $kAnchorBaseTable)"/>
									<xsl:with-param name="inTarget" select="'_top'"/>
									<xsl:with-param name="inDisplayText" select="$inTableAlias/@name"/>
								</xsl:call-template>					
							</xsl:when>
							<xsl:otherwise>
								<em><xsl:value-of select="$inTableAlias/@name"/></em>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>	
						<xsl:call-template name="ItalicLink-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $inTableAlias/@id, $kAnchorTable)"/>
							<xsl:with-param name="inDisplayText" select="$inTableAlias/@name"/>
						</xsl:call-template>				
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>	
  </xsl:template>
  
  <!--Base table reference given a table alias/occurrence -->
  <xsl:template name="BaseTableRefGivenTableAlias">
    <xsl:param name="inTableAlias"/>
    <xsl:choose>
      <xsl:when test="string-length($inTableAlias/@baseTable)='0'">
				<xsl:value-of select="$valMissingBaseTable"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>
					<!-- External base table references -->
					<xsl:when test="$inTableAlias/FileReference">
						<xsl:variable name="fileRef" select="key('FileReferenceIndex',$inTableAlias/FileReference/@name)"/>
						<xsl:choose>
							<xsl:when test="$fileRef/@link">
								<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
									<xsl:with-param name="inFileLink" select="concat('../',$fileRef/@link,'/index.html','?', $inTableAlias/@baseTableId,$kAnchorBaseTable)"/>
									<xsl:with-param name="inTarget" select="'_top'"/>
									<xsl:with-param name="inDisplayText" select="$inTableAlias/@baseTable"/>
								</xsl:call-template>						
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$inTableAlias/@baseTable"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<!-- Internal references -->
						<xsl:call-template name="BaseTableReference">
							<xsl:with-param name="inBaseTable" select="$inTableAlias/@baseTable"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

	<!-- File Reference references -->
  <xsl:template name="FileRefReference">
    <xsl:param name="inFileReference"/>
    <xsl:choose>
      <xsl:when test="string-length($inFileReference/@name)='0'">
				<xsl:value-of select="$valMissingFileReference"/>
      </xsl:when>
      <xsl:otherwise>
				
				<xsl:variable name="fileRef" select="key('FileReferenceIndex',$inFileReference/@name)"/>
				<xsl:choose>
					<xsl:when test="$fileRef">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $fileRef/@id, $kAnchorFileReference)"/>
							<xsl:with-param name="inDisplayText" select="$fileRef/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inFileReference/@name"/>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  
  <xsl:template name="FileRefAnchor">
    <xsl:param name="inFileReference"/>
    <xsl:choose>
      <xsl:when test="string-length($inFileReference/@name)='0'">
				<xsl:value-of select="$valMissingFileReference"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inFileReference/@id, $kAnchorFileReference)"/>
					<xsl:with-param name="inDisplayText" select="$inFileReference/@name"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  
  <!--Layout reference: must pass a Layout node! -->
  <xsl:template name="LayoutReference">
    <xsl:param name="inLayout"/>
    <xsl:choose>
      <xsl:when test="string-length($inLayout/@name)='0'">
				<xsl:value-of select="$valMissingLayout"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="key('LayoutIndex', concat($inLayout/@name, $inLayout/@id))">	
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#',$inLayout/@id, $kAnchorLayout)"/>
							<xsl:with-param name="inDisplayText" select="$inLayout/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
            <!--There may yet be a remote reference!-->
            <xsl:variable name="tableNode" select="$inLayout/../Table"/>
            <xsl:choose>
              <xsl:when test="$tableNode">
                <xsl:variable name="tableAlias" select="key('BaseTable-TableAliasIndex',$tableNode/@name)"/>
                <xsl:variable name="fileReference" select="key('FileReferenceIndex', $tableAlias/FileReference/@name)"/>
                <xsl:choose>
                  <xsl:when test="$tableAlias">
                    <xsl:choose>
                      <xsl:when test="$tableAlias/FileReference">
                        <xsl:choose>
                          <xsl:when test="$fileReference/@link">
                            <xsl:call-template name="FullLayoutLink-WithAnchor-WithTarget">
                              <xsl:with-param name="inAnchor" select="concat('../',$fileReference/@link,'/index.html','?', $inLayout/@id, $kAnchorLayout)"/>
                              <xsl:with-param name="inLayoutName" select="$inLayout/@name"/>
                              <xsl:with-param name="inTarget" select="'_top'"/>
                            </xsl:call-template>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="$inLayout/@name"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="$inLayout/@name"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$inLayout/@name"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$inLayout/@name"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
				</xsl:choose>	
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>

  
  <!--Layout object section reference: must pass a Layout node and section! -->
  <xsl:template name="LayoutObjectSectionReference">
    <xsl:param name="inLayout"/>
    <xsl:param name="inSection"/>	
    <xsl:param name="inDisplayText"/>
    <xsl:call-template name="Link-WithAnchor">
      <xsl:with-param name="inAnchor" select="concat('#',$inLayout/@id, $kAnchorLayoutObjects, $inSection)"/>
      <xsl:with-param name="inDisplayText" select="$inDisplayText"/>
    </xsl:call-template>				
  </xsl:template>
  
  <!--Layout reference: must pass a Layout node! -->
  <xsl:template name="LayoutObjectsReference">
    <xsl:param name="inLayout"/>
    <xsl:param name="inDisplayText"/>
    <xsl:choose>
      <xsl:when test="key('LayoutIndex', concat($inLayout/@name, @id = $inLayout/@id))">	
				<xsl:call-template name="Link-WithAnchor">
					<xsl:with-param name="inAnchor" select="concat('#',$inLayout/@id, $kAnchorLayoutObjects)"/>
					<xsl:with-param name="inDisplayText" select="$inDisplayText"/>
				</xsl:call-template>				
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="inDisplayText"/>
      </xsl:otherwise>
    </xsl:choose>	
  </xsl:template>
  
  
  <!--Value list reference: must pass a ValueList node! -->
  <xsl:template name="VLReference">
    <xsl:param name="inVL"/>
    <xsl:choose>
      <xsl:when test="string-length($inVL/@name)='0'">
				<xsl:value-of select="$valMissingValueList"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="key('VLIndex',$inVL/@name)">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#',$inVL/@id, $kAnchorVL)"/>
							<xsl:with-param name="inDisplayText" select="$inVL/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inVL/@name"/>
					</xsl:otherwise>
				</xsl:choose>		
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="VLAnchor">
    <xsl:param name="inVL"/>
    <xsl:choose>
      <xsl:when test="string-length($inVL/@name)='0'">
				<xsl:value-of select="$valMissingValueList"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inVL/@id, $kAnchorVL)"/>
					<xsl:with-param name="inDisplayText" select="$inVL/@name"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--External value list reference: must pass a ValueList and FileReference node! -->
  <xsl:template name="ExternalVLReference">
    <xsl:param name="inExternalVL"/>
    <xsl:param name="inFileRef"/>
    <xsl:choose>
      <xsl:when test="string-length($inExternalVL/@name)='0'">
				<xsl:value-of select="$valMissingValueList"/>
      </xsl:when>
      <xsl:when test="string-length($inFileRef/@name)='0'">
				<xsl:value-of select="$valMissingFileReference"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="fileRef" select="key('FileReferenceIndex',$inFileRef/@name)"/>
				<xsl:choose>
					<xsl:when test="$fileRef/@link">
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat('../',$fileRef/@link,'/index.html','?', $inExternalVL/@id,$kAnchorVL)"/>
							<xsl:with-param name="inTarget" select="'_top'"/>
							<xsl:with-param name="inDisplayText" select="$inExternalVL/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$inExternalVL/@name"/></xsl:otherwise>
				</xsl:choose>		
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--Script reference: must pass a Script node! -->
  <xsl:template name="ScriptReference">
    <xsl:param name="inScript"/>
    <xsl:choose>
      <xsl:when test="string-length($inScript/@name)='0'">
				<xsl:value-of select="$valMissingScript"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="key('ScriptIndex', concat($inScript/@name, $inScript/@id))">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $inScript/@id, $kAnchorScript)"/>
							<xsl:with-param name="inDisplayText" select="$inScript/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inScript/@name"/>
					</xsl:otherwise>	
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--Custom menu reference: must pass a Script node! -->
  <xsl:template name="CustomMenuReference">
    <xsl:param name="inCustomMenu"/>
    <xsl:choose>
      <xsl:when test="string-length($inCustomMenu/@name)='0'">
				<xsl:value-of select="$valMissingCustomMenu"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="key('CustomMenuIndex', $inCustomMenu/@id)">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $inCustomMenu/@id, $kAnchorCustomMenu)"/>
							<xsl:with-param name="inDisplayText" select="$inCustomMenu/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inCustomMenu/@name"/>
					</xsl:otherwise>	
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <!--Custom menu set reference: must pass a Script node! -->
  <xsl:template name="CustomMenuSetReference">
    <xsl:param name="inCustomMenuSet"/>
    <xsl:choose>
      <xsl:when test="$inCustomMenuSet/@id ='0'">
				<xsl:value-of select="$valFileDefault"/>
      </xsl:when>
      <xsl:when test="string-length($inCustomMenuSet/@name)='0'">
				<xsl:value-of select="$valMissingCustomMenuSet"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="key('CustomMenuSetIndex',$inCustomMenuSet/@id)">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $inCustomMenuSet/@id, $kAnchorCustomMenuSet)"/>
							<xsl:with-param name="inDisplayText" select="$inCustomMenuSet/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inCustomMenuSet/@name"/>
					</xsl:otherwise>	
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <!--Custom menu set reference: must pass a Script node! -->
  <xsl:template name="CustomMenuSetReferenceByName">
    <xsl:param name="inCustomMenuSetName"/>
    <xsl:choose>			
      <xsl:when test="string-length($inCustomMenuSetName)='0'">
				<xsl:value-of select="$valMissingCustomMenuSet"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="menuSet" select="key('CustomMenuSetNameIndex', $inCustomMenuSetName)"></xsl:variable>
				<xsl:choose>					
					<xsl:when test="$menuSet">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $menuSet/@id, $kAnchorCustomMenuSet)"/>
							<xsl:with-param name="inDisplayText" select="$inCustomMenuSetName"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inCustomMenuSetName"/>
					</xsl:otherwise>	
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  
  <xsl:template name="ExternalScriptReference">
    <xsl:param name="inFileRef"/>
    <xsl:param name="inScript"/>
    
    <xsl:choose>
      <xsl:when test="string-length($inScript/@name)='0'">
				<xsl:value-of select="$valMissingScript"/>
      </xsl:when>
      <xsl:when test="string-length($inFileRef/@name)='0'">
				<xsl:value-of select="$valMissingFileReference"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="fileRef" select="key('FileReferenceIndex',$inFileRef/@name)"/>
				<xsl:choose>
					<xsl:when test="$fileRef/@link">
						<xsl:call-template name="ExternalLink-NoAnchor-WithTarget">
							<xsl:with-param name="inFileLink" select="concat('../',$fileRef/@link,'/index.html','?', $inScript/@id,$kAnchorScript)"/>
							<xsl:with-param name="inTarget" select="'_top'"/>
							<xsl:with-param name="inDisplayText" select="$inScript/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inScript/@name"/>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <xsl:template name="ScriptAnchor">
    <xsl:param name="inScript"/>	
    <xsl:choose>
      <xsl:when test="string-length($inScript/@name)='0'">
				<xsl:value-of select="$valMissingScript"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inScript/@id, $kAnchorScript)"/>
					<xsl:with-param name="inDisplayText" select="$inScript/@name"/>
				</xsl:call-template>	
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  
  <xsl:template name="CustomMenuAnchor">
    <xsl:param name="inCustomMenu"/>	
    <xsl:choose>
      <xsl:when test="string-length($inCustomMenu/@name)='0'">
				<xsl:value-of select="$valMissingCustomMenu"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inCustomMenu/@id, $kAnchorCustomMenu)"/>
					<xsl:with-param name="inDisplayText" select="$inCustomMenu/@name"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>					
  </xsl:template>
  
  <xsl:template name="CustomMenuSetAnchor">
    <xsl:param name="inCustomMenuSet"/>	
    <xsl:choose>
      <xsl:when test="string-length($inCustomMenuSet/@name)='0'">
				<xsl:value-of select="$valMissingCustomMenuSet"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inCustomMenuSet/@id, $kAnchorCustomMenuSet)"/>
					<xsl:with-param name="inDisplayText" select="$inCustomMenuSet/@name"/>
				</xsl:call-template>			
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <!-- Account reference -->
  <xsl:template name="AccountReference">
    <xsl:param name="inAccount"/>
    <xsl:choose>
      <xsl:when test="string-length($inAccount/@name)='0'">
				<xsl:value-of select="$valMissingAccount"/>
      </xsl:when>
      <xsl:otherwise>			
				<xsl:variable name="accountRef" select="key('AccountIndex',$inAccount/@name)"/>
				<xsl:choose>
					<xsl:when test="$accountRef">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $accountRef/@id,$kAnchorAccount)"/>
							<xsl:with-param name="inDisplayText" select="$inAccount/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inAccount/@name"/>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <xsl:template name="AccountAnchor">
    <xsl:param name="inAccount"/>
    <xsl:choose>
      <xsl:when test="string-length($inAccount/@name)='0'">
				<xsl:value-of select="$valMissingAccount"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inAccount/@id, $kAnchorAccount)"/>
					<xsl:with-param name="inDisplayText" select="$inAccount/@name"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>		
  </xsl:template>
  
  <xsl:template name="PrivilegeSetAnchor">
    <xsl:param name="inPrivilegeSet"/>
    <xsl:choose>
      <xsl:when test="string-length($inPrivilegeSet/@name)='0'">
				<xsl:value-of select="$valMissingPrivilegeSet"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inPrivilegeSet/@id, $kAnchorPrivilegeSet)"/>
					<xsl:with-param name="inDisplayText" select="$inPrivilegeSet/@name"/>
				</xsl:call-template>		
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="PrivilegeSetReference">
    <xsl:param name="inPrivilegeSetName"/>
    <xsl:choose>
      <xsl:when test="string-length($inPrivilegeSetName)='0'">
				<xsl:value-of select="$valMissingPrivilegeSet"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="privilegeSet" select="key('PrivilegeSetIndex', $inPrivilegeSetName)"/>
				<xsl:choose>					
					<xsl:when test="$privilegeSet">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $privilegeSet/@id,$kAnchorPrivilegeSet)"/>
							<xsl:with-param name="inDisplayText" select="$inPrivilegeSetName"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inPrivilegeSetName"/>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="ExtendedPrivilegeAnchor">
    <xsl:param name="inExtendedPrivilege"/>
    <xsl:choose>
      <xsl:when test="string-length($inExtendedPrivilege/@name)='0'">
				<xsl:value-of select="$valMissingExtendedPrivilege"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inExtendedPrivilege/@id, $kAnchorExtendedPrivilege)"/>
					<xsl:with-param name="inDisplayText" select="$inExtendedPrivilege/@name"/>
				</xsl:call-template>	
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="ExtendedPrivilegeReference">
    <xsl:param name="inExtendedPrivilege"/>
    <xsl:choose>
      <xsl:when test="string-length($inExtendedPrivilege/@name)='0'">
				<xsl:value-of select="$valMissingExtendedPrivilege"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:choose>
					<xsl:when test="key('ExtendedPrivilegeIndex',$inExtendedPrivilege/@name)">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#', $inExtendedPrivilege/@id,$kAnchorExtendedPrivilege)"/>
							<xsl:with-param name="inDisplayText" select="$inExtendedPrivilege/@name"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inExtendedPrivilege/@name"/>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- BaseTable anchor: location to anchor to. Must be a BaseTable name! -->
  <xsl:template name="BaseTableAnchor">
    <xsl:param name="inBaseTable"/>
    <xsl:choose>
      <xsl:when test="string-length($inBaseTable)='0'">
				<xsl:value-of select="$valMissingBaseTable"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="baseTable" select="key('BaseTableIndex',$inBaseTable)"/>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($baseTable/@id, $kAnchorBaseTable)"/>
					<xsl:with-param name="inDisplayText" select="$inBaseTable"/>
				</xsl:call-template>	
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>		
  
  <!-- Field anchor: location to anchor to. Pass in a field name and base table! -->
  <xsl:template name="FieldAnchor">
    <xsl:param name="inField"/>
    <xsl:param name="inBaseTable"/>
    <xsl:choose>
      <xsl:when test="string-length($inField/@name)='0'">
				<xsl:value-of select="$valMissingField"/>
      </xsl:when>
      <xsl:when test="string-length($inBaseTable/@name)='0'">
				<xsl:value-of select="$valMissingBaseTable"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inBaseTable/@id, $inField/@id, $kAnchorField)"/>
					<xsl:with-param name="inDisplayText" select="$inField/@name"/>
				</xsl:call-template>	
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>	
  
  <!-- Layout anchor: location to anchor to. Pass in a Layout node! -->
  <xsl:template name="LayoutAnchor">
    <xsl:param name="inLayout"/>
    <xsl:choose>
      <xsl:when test="string-length($inLayout/@name)='0'">
				<xsl:value-of select="$valMissingLayout"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inLayout/@id, $kAnchorLayout)"/>
					<xsl:with-param name="inDisplayText" select="$inLayout/@name"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Layout anchor: location to anchor to. Pass in a Layout node and section name! -->
  <xsl:template name="LayoutObjectSectionAnchor">
    <xsl:param name="inLayout"/>
    <xsl:param name="inSection"/>
    <xsl:param name="inDisplayText"/>
    <xsl:call-template name="AnchorPoint">
      <xsl:with-param name="inAnchor" select="concat($inLayout/@id, $kAnchorLayoutObjects, $inSection)"/>
      <xsl:with-param name="inDisplayText" select="$inDisplayText"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="LayoutObjectAnchorRaw">
    <xsl:param name="inLayoutObject"/>
    <xsl:value-of select="concat($inLayoutObject/../@id,
													$inLayoutObject/@type,
													$inLayoutObject/Bounds/@top, 
													$inLayoutObject/Bounds/@left,
													$inLayoutObject/Bounds/@bottom,
													$inLayoutObject/Bounds/@right,
													$kAnchorLayoutObject)"/>
  </xsl:template>

  <xsl:template name="LayoutObjectAnchor">
    <xsl:param name="inLayoutObject"/>
    <xsl:param name="inDisplayText"/>
    <xsl:param name="inAppendToAnchor"/>

    <xsl:variable name="RawAnchor">
      <xsl:call-template name="LayoutObjectAnchorRaw">
				<xsl:with-param name="inLayoutObject" select="$inLayoutObject"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:call-template name="AnchorPoint">
      <xsl:with-param name="inAnchor" select="concat($RawAnchor, $inAppendToAnchor)"/>
      <xsl:with-param name="inDisplayText" select="$inDisplayText"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="LayoutObjectReference">
    <xsl:param name="inLayoutObject"/>
    <xsl:param name="inDisplayText"/>
    <xsl:param name="inAnchorAppend"/>

    <xsl:variable name="RawAnchor">
      <xsl:call-template name="LayoutObjectAnchorRaw">
				<xsl:with-param name="inLayoutObject" select="$inLayoutObject"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:call-template name="Link-WithAnchor">
      <xsl:with-param name="inAnchor" select="concat('#', $RawAnchor, $inAnchorAppend)"/>
      <xsl:with-param name="inDisplayText" select="$inDisplayText"/>
    </xsl:call-template>				
  </xsl:template>
  
  <!--Table section anchor. -->
  <xsl:template name="TableSectionAnchor">
    <xsl:call-template name="AnchorPoint">
      <xsl:with-param name="inAnchor" select="concat('valTables', $kAnchorSection)"/>
      <xsl:with-param name="inDisplayText" select="$valTables"/>
    </xsl:call-template>			
  </xsl:template>
  
  <!--Shadow table section anchor. -->
  <xsl:template name="ShadowTableSectionAnchor">
	<!--Here we have a blank anchor that corresponds to the table section, to ensure that 
		the navigation bar works even if we have no local tables to report-->
    <xsl:call-template name="AnchorPoint-NoText">
      <xsl:with-param name="inAnchor" select="concat('valTables', $kAnchorSection)"/>
    </xsl:call-template>	
    <!--This provides a proper anchor in case anybody wants to link to the shadow table section proper-->
    <xsl:call-template name="AnchorPoint">
      <xsl:with-param name="inAnchor" select="concat('valShadowTables', $kAnchorSection)"/>
      <xsl:with-param name="inDisplayText" select="$valShadowTables"/>
    </xsl:call-template>			
  </xsl:template>
  
  <!--ODBC data sources section anchor. -->
  <xsl:template name="OdbcDataSourceSectionAnchor">
	<!--Here we have a blank anchor that corresponds to the data sources section, to ensure that 
		the navigation bar works even if we have no FM data sources to report-->
    <xsl:call-template name="AnchorPoint-NoText">
      <xsl:with-param name="inAnchor" select="concat('valFileReferences', $kAnchorSection)"/>
    </xsl:call-template>	
    <!--This provides a proper anchor in case anybody wants to link to the ODBC section proper-->
    <xsl:call-template name="AnchorPoint">
      <xsl:with-param name="inAnchor" select="concat('valOdbcDataSources', $kAnchorSection)"/>
      <xsl:with-param name="inDisplayText" select="$valOdbcDataSources"/>
    </xsl:call-template>			
  </xsl:template>
  
  <!--Field section anchor. -->
  <xsl:template name="FieldSectionAnchor">
    <xsl:call-template name="AnchorPoint">
      <xsl:with-param name="inAnchor" select="concat('valFields', $kAnchorSection)"/>
      <xsl:with-param name="inDisplayText" select="$valFields"/>
    </xsl:call-template>					
  </xsl:template>
  
  <!-- Table occurrence/alias anchor -->
  <xsl:template name="TableAliasAnchor">
    <xsl:param name="inTableAlias"/>
    <xsl:choose>
      <xsl:when test="string-length($inTableAlias/@name)='0'">
				<xsl:value-of select="$valMissingTableOccurrence"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="TableAnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inTableAlias/@id, $kAnchorTable)"/>
					<xsl:with-param name="inDisplayText" select="$inTableAlias/@name"/>
				</xsl:call-template>		
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <xsl:template name="CustomFunctionReference">
    <xsl:param name="inCustomFunctionName"/>
    <xsl:choose>
      <xsl:when test="string-length($inCustomFunctionName)='0'">
				<xsl:value-of select="$valMissingCustomFunction"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:variable name="customFunction" select="key('CustomFunctionIndex',$inCustomFunctionName)"/>
				<xsl:choose>					
					<xsl:when test="$customFunction">
						<xsl:call-template name="Link-WithAnchor">
							<xsl:with-param name="inAnchor" select="concat('#',$customFunction/@id, $kAnchorCustomFunction)"/>
							<xsl:with-param name="inDisplayText" select="$inCustomFunctionName"/>
						</xsl:call-template>				
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$inCustomFunctionName"/>
					</xsl:otherwise>
				</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template>
  
  <xsl:template name="CustomFunctionAnchor">
    <xsl:param name="inCustomFunction"/>
    <xsl:choose>
      <xsl:when test="string-length($inCustomFunction/@name)='0'">
				<xsl:value-of select="$valMissingCustomFunction"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat($inCustomFunction/@id, $kAnchorCustomFunction)"/>
					<xsl:with-param name="inDisplayText" select="$inCustomFunction/@name"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
    
    
  </xsl:template> 
  
  <!-- Template for generating calculations -->
  <!-- Must pass in a DisplayCalc node -->
  <xsl:template name="GenerateCalc">
    <xsl:param name="inDisplayCalc"/>
    <xsl:choose>
      <xsl:when test="$inDisplayCalc/DisplayCalculation/Chunk[1]">
				<!-- Process the Chunks -->
				<xsl:call-template name="GenerateDisplayCalcChunks">
					<xsl:with-param name="inDisplayCalcChunk" select="$inDisplayCalc/DisplayCalculation"/>
				</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$inDisplayCalc/Calculation"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="GenerateDisplayCalcChunks">
    <xsl:param name="inDisplayCalcChunk"/>
    <xsl:if test="$inDisplayCalcChunk/Chunk[1]">
      <!-- Process the Chunks -->
      <xsl:for-each select="$inDisplayCalcChunk/Chunk">
				<xsl:choose>
					<xsl:when test="@type='CustomFunctionRef'">
						<xsl:call-template name="CustomFunctionReference">
							<xsl:with-param name="inCustomFunctionName" select="."/>
						</xsl:call-template>										
					</xsl:when>			
					<xsl:when test="@type='FunctionRef'">
						<strong><xsl:value-of select="."/></strong>
					</xsl:when>
					<xsl:when test="@type='NoRef'">
						<xsl:value-of select="."/>
					</xsl:when>
					<xsl:when test="@type='FieldRef'">
						<xsl:call-template name="FieldReference-ShowTableAlias">
							<xsl:with-param name="inField" select="Field"/>
						</xsl:call-template>					
					</xsl:when>				
				</xsl:choose>			
      </xsl:for-each>
    </xsl:if>
  </xsl:template>
  
  <!-- Template to generate a list of table aliases of a base table -->
  <xsl:template name="TableAliasList">
    <xsl:param name="inBaseTable"/>
    <xsl:variable name="tableAliases" select="key('TableAlias-BaseTableIndex', $inBaseTable)[not(FileReference)]"/>
    <xsl:for-each select="$tableAliases">				
      <!-- We can do this test because table alias names are guaranteed to be unique -->
      <xsl:if test="@name!= $tableAliases[1]/@name">
				<xsl:text>, </xsl:text>
      </xsl:if>								
      <xsl:call-template name="TableAliasReference">
				<xsl:with-param name="inTableAlias" select="."/>
      </xsl:call-template>
    </xsl:for-each>			
  </xsl:template>
  
  <!-- Template for fetching the field type information. -->
  <xsl:template name="FieldType">
    <xsl:param name="inFieldType"/>
    <xsl:choose>
      <xsl:when test="$inFieldType = 'Normal'"><xsl:value-of select="$valNormal"/></xsl:when>
      <xsl:when test="$inFieldType = 'Calculated'"><xsl:value-of select="$valCalculated"/></xsl:when>
      <xsl:when test="$inFieldType = 'Summary'"><xsl:value-of select="$valSummary"/></xsl:when>
      <xsl:when test="$inFieldType = 'Invalid'"><xsl:value-of select="$valInvalid"/></xsl:when>
    </xsl:choose>	
  </xsl:template>
  
  <!-- Template for fetching the field type information. -->
  <xsl:template name="DataType">
    <xsl:param name="inDataType"/>
    <xsl:choose>	
      <xsl:when test="$inDataType='Text'"><xsl:value-of select="$valDataTypeText"/></xsl:when>
      <xsl:when test="$inDataType='Number'"><xsl:value-of select="$valDataTypeNumber"/></xsl:when>
      <xsl:when test="$inDataType='Date'"><xsl:value-of select="$valDataTypeDate"/></xsl:when>
      <xsl:when test="$inDataType='Time'"><xsl:value-of select="$valDataTypeTime"/></xsl:when>
      <xsl:when test="$inDataType='TimeStamp'"><xsl:value-of select="$valDataTypeTimeStamp"/></xsl:when>
      <xsl:when test="$inDataType='Binary'"><xsl:value-of select="$valDataTypeBinary"/></xsl:when>
    </xsl:choose>	
  </xsl:template>

  <!-- Template for fetching shadow type information -->
  <xsl:template name="ShadowType">
    <xsl:param name="type"/>

    <xsl:choose>
      <xsl:when test="$type = 'Shadow'">
				<xsl:value-of select="$valShadow"/>
      </xsl:when>
      <xsl:when test="$type = 'Supplemental'">
				<xsl:value-of select="$valSupplemental"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <!-- AutoEnter values -->
  <xsl:template name="AutoEnterValue">
    <xsl:param name="inAutoEnterValue"/>
    <xsl:choose>
      <xsl:when test="$inAutoEnterValue = 'CreationTime'"><xsl:value-of select="$valCreationTime"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'CreationDate'"><xsl:value-of select="$valCreationDate"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'CreationTimeStamp'"><xsl:value-of select="$valCreationTimeStamp"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'CreationName'"><xsl:value-of select="$valCreationName"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'CreationAccountName'"><xsl:value-of select="$valCreationAccountName"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'ModificationDate'"><xsl:value-of select="$valModificationDate"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'ModificationTime'"><xsl:value-of select="$valModificationTime"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'ModificationTimeStamp'"><xsl:value-of select="$valModificationTimeStamp"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'ModificationName'"><xsl:value-of select="$valModificationName"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'ModificationAccountName'"><xsl:value-of select="$valModificationAccountName"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'PreviousRecord'"><xsl:value-of select="$valPreviousRecord"/></xsl:when>
      <xsl:when test="$inAutoEnterValue = 'ConstantData'"><xsl:value-of select="$valConstantData"/></xsl:when>
    </xsl:choose>		
  </xsl:template>
  
  <xsl:template name="LookupCopyMatchValue">
    <xsl:param name="inLookupValue"/>
    <xsl:choose>
      <xsl:when test="$inLookupValue = 'DoNotCopy'"><xsl:value-of select="$valDoNotCopy"/></xsl:when>
      <xsl:when test="$inLookupValue = 'CopyNextHigher'"><xsl:value-of select="$valCopyNextHigher"/></xsl:when>
      <xsl:when test="$inLookupValue = 'CopyNextLower'"><xsl:value-of select="$valCopyNextLower"/></xsl:when>
      <xsl:when test="$inLookupValue = 'CopyConstant'"><xsl:value-of select="$valCopyConstant"/></xsl:when>
    </xsl:choose>		
  </xsl:template>
  
  <!-- AutoEnter Serial value -->
  <xsl:template name="AutoEnterSerialValue">
    <xsl:param name="inSerialValue"/>
    <xsl:choose>
      <xsl:when test="$inSerialValue = 'OnCommit'"><xsl:value-of select="$valOnCommit"/></xsl:when>
      <xsl:when test="$inSerialValue = 'OnCreation'"><xsl:value-of select="$valOnCreate"/></xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <!-- Generate the report overview table -->
  <xsl:template name="Table-Overview">
    <xsl:param name="inFile"/>
    <p>			
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valFileOptionOverview', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$inFile/@name"/>
				</xsl:call-template>						
      </span>
    </p>
    <table width="100%" border="1">
      <tbody>
				<tr vAlign="top">
					<td class="chartsubheads" colSpan="2">
						<xsl:value-of select="$valOverview"/>
					</td>
					<td class="chartsubheads" width="1%">&#xa0;</td>
					<td class="chartsubheads" colSpan="2">
						<xsl:value-of select="$valFileOptions"/>
					</td>
				</tr>			
				<tr vAlign="top">
					<td class="chartheadersnobg" width="32%">
						<xsl:value-of select="$valTables"/>
					</td>					
					<td class="regularcharttext" width="8%">											
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valTables'"/>
							<xsl:with-param name="inCount" select="count($inFile/BaseTableCatalog/BaseTable)"/>
						</xsl:call-template>							
					</td>
					<td class="regularcharttext">&#xa0;</td>
					<td class="chartheadersnobg" width="%26">
						<xsl:value-of select="$valDefaultCustomMenuSet"/>
					</td>
					<td class="regularcharttext" width="33%">
						<xsl:call-template name="CustomMenuSetReference">
							<xsl:with-param name="inCustomMenuSet" select="/FMPReport/File/Options/DefaultCustomMenuSet/CustomMenuSet"/>
						</xsl:call-template>
					</td>			
					
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valRelationships"/>
					</td>
					<td class="regularcharttext">						
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valRelationships'"/>
							<xsl:with-param name="inCount" select="count($inFile/RelationshipGraph/RelationshipList/Relationship)"/>
						</xsl:call-template>																			
					</td>
					
					<td class="regularcharttext">&#xa0;</td>
					<td class="chartsubheads" colSpan="2">
						<xsl:value-of select="$valWhenOpeningFile"/>
					</td>	
					
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valLayouts"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valLayouts'"/>
							<xsl:with-param name="inCount" select="count($inFile/LayoutCatalog//Layout)"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext">&#xa0;</td>
					<td class="chartheadersnobg" width="%26">
						<xsl:value-of select="$valLoginUsing"/>
					</td>
					<td class="regularcharttext" width="33%">
						<xsl:choose>
							<xsl:when test="/FMPReport/File/Options/OnOpen/Account">
								<xsl:value-of select="concat($valAccountName,'; ',$valAccount,'= ')"/>
								<xsl:call-template name="AccountReference">
									<xsl:with-param name="inAccount" select="/FMPReport/File/Options/OnOpen/Account"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$valOff"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valScripts"/>
					</td>
					<td class="regularcharttext">						
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valScripts'"/>
							<xsl:with-param name="inCount" select="count($inFile/ScriptCatalog/Script) + count($inFile/ScriptCatalog//Group/Script)"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext">&#xa0;</td>
					<td class="chartheadersnobg">
						<xsl:value-of select="$valSwitchToLayout"/>
					</td>
					<td class="regularcharttext">
						<xsl:choose>
							<xsl:when test="/FMPReport/File/Options/OnOpen/Layout">
								<xsl:call-template name="LayoutReference">
									<xsl:with-param name="inLayout" select="/FMPReport/File/Options/OnOpen/Layout"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$valOff"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					
				</tr>	
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valValueLists"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valValueLists'"/>
							<xsl:with-param name="inCount" select="count($inFile/ValueListCatalog/ValueList)"/>
						</xsl:call-template>													
					</td>
					<td class="regularcharttext">&#xa0;</td>
					<td class="chartheadersnobg">
						<xsl:value-of select="$valPerformScript"/>
					</td>	
					<td class="regularcharttext">
						<xsl:choose>
							<xsl:when test="/FMPReport/File/Options/OnOpen/Script">
								<xsl:call-template name="ScriptReference">
									<xsl:with-param name="inScript" select="/FMPReport/File/Options/OnOpen/Script"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$valOff"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>				
					
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valCustomFunctions"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valCustomFunctions'"/>
							<xsl:with-param name="inCount" select="count($inFile/CustomFunctionCatalog/CustomFunction)"/>
						</xsl:call-template>						
					</td>					
					
					<td class="regularcharttext">&#xa0;</td>
					<td class="chartsubheads" colSpan="2">
						<xsl:value-of select="$valWhenClosingFile"/>
					</td>
					
				</tr>								
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valAccounts"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valAccounts'"/>
							<xsl:with-param name="inCount" select="count($inFile/AccountCatalog/Account)"/>
						</xsl:call-template>														
					</td>
					<td class="regularcharttext">&#xa0;</td>
					<td class="chartheadersnobg">
						<xsl:value-of select="$valPerformScript"/>
					</td>
					<td class="regularcharttext">
						<xsl:choose>
							<xsl:when test="/FMPReport/File/Options/OnClose/Script">
								<xsl:call-template name="ScriptReference">
									<xsl:with-param name="inScript" select="/FMPReport/File/Options/OnClose/Script"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$valOff"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>				
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valPrivilegeSets"/>
					</td>
					<td class="regularcharttext">						
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valPrivilegeSets'"/>
							<xsl:with-param name="inCount" select="count($inFile/PrivilegesCatalog/PrivilegeSet)"/>
						</xsl:call-template>														
					</td>				
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valExtendedPrivileges"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valExtendedPrivileges'"/>
							<xsl:with-param name="inCount" select="count($inFile/ExtendedPrivilegeCatalog/ExtendedPrivilege)"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valFileAccessInboundOutbound"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valFileAccessInbound'"/>
							<xsl:with-param name="inCount" select="count($inFile/AuthFileCatalog/Inbound/InboundAuthorization)"/>
						</xsl:call-template>
						/
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valFileAccessOutbound'"/>
							<xsl:with-param name="inCount" select="count($inFile/AuthFileCatalog/Outbound/OutboundAuthorization)"/>
						</xsl:call-template>
					</td>
				</tr>
				
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valFileReferences"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valFileReferences'"/>
							<xsl:with-param name="inCount" select="count($inFile/FileReferenceCatalog/FileReference)"/>
						</xsl:call-template>														
					</td>					
				</tr>		
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valOdbcDataSources"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valOdbcDataSources'"/>
							<xsl:with-param name="inCount" select="count($inFile/FileReferenceCatalog/OdbcDataSource)"/>
						</xsl:call-template>														
					</td>					
				</tr>		
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valCustomMenuSets"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valCustomMenuSets'"/>
							<xsl:with-param name="inCount" select="count($inFile/CustomMenuSetCatalog/CustomMenuSet)"/>
						</xsl:call-template>														
					</td>					
				</tr>		
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valCustomMenus"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="SectionReference">
							<xsl:with-param name="inSection" select="'valCustomMenus'"/>
							<xsl:with-param name="inCount" select="count($inFile/CustomMenuCatalog/CustomMenu)"/>
						</xsl:call-template>														
					</td>					
				</tr>		
      </tbody>
    </table>
  </xsl:template>
  
  <!-- Template for generating Auto-Enter information for field -->
  <!-- Must pass in an AutoEnter node -->
  <xsl:template name="Table-AutoEnter">
    <xsl:param name="inAutoEnter"/>
    <xsl:if test="$inAutoEnter and (($inAutoEnter/ancestor::Field/@fieldType != 'Calculated') or ($inAutoEnter/@alwaysEvaluate = 'True'))">
      <strong><xsl:value-of select="concat($valAutoEnter,':')"/></strong>			
      <ul>
				<xsl:if test="$inAutoEnter/@value">
					<li>
						<xsl:call-template name="AutoEnterValue">
							<xsl:with-param name="inAutoEnterValue" select="$inAutoEnter/@value"/>
						</xsl:call-template>
						<xsl:if test="$inAutoEnter/@constant = 'True' and $inAutoEnter/ConstantData">
							<xsl:value-of select="concat(': ', $inAutoEnter/ConstantData)"/>				
						</xsl:if>
					</li>
				</xsl:if>	
				<xsl:if test="$inAutoEnter/@alwaysEvaluate = 'True'">
					<li>
						<xsl:value-of select="$valAlwaysEvaluate"/>		
					</li>
				</xsl:if>					
				<xsl:if test="$inAutoEnter/@allowEditing = 'True'">
					<li>
						<xsl:value-of select="$valAllowEditing"/>
					</li>
				</xsl:if>	
				<xsl:if test="$inAutoEnter/@overwriteExistingValue = 'False'">
					<li>
						<xsl:value-of select="$valDoNotReplaceExisting"/>
					</li>
				</xsl:if>															
				<xsl:if test="$inAutoEnter/Serial">
					<li>
						<xsl:value-of select="concat($valSerial, ': ', $valGenerate, ': ')"/>
						<xsl:call-template name="AutoEnterSerialValue">
							<xsl:with-param name="inSerialValue" select="$inAutoEnter/Serial/@generate"/>							
						</xsl:call-template>
						<xsl:value-of select="concat(', ', $valNextValue, ': ', $inAutoEnter/Serial/@nextValue, ', ', $valIncrement, ': ', $inAutoEnter/Serial/@increment)"/>
					</li>
				</xsl:if>				
				<xsl:if test="$inAutoEnter/@calculation = 'True' and $inAutoEnter/Calculation">
					<li>
						<xsl:value-of select="concat($valContextTable,': ')"/>
						<xsl:call-template name="TableAliasReferenceGivenName">
							<xsl:with-param name="inTableAliasName" select="$inAutoEnter/Calculation/@table"/>
						</xsl:call-template>
						<br/>
						<xsl:value-of select="concat($valCalculation, ': ')"/>
						<xsl:call-template name="GenerateCalc">
							<xsl:with-param name="inDisplayCalc" select="$inAutoEnter"/>
						</xsl:call-template>					
					</li>
				</xsl:if>
				<xsl:if test="$inAutoEnter/@lookup='True' and $inAutoEnter/Lookup">
					<li>
						<xsl:value-of select="concat($valLookup, ': ')"/>
						<xsl:if test="$inAutoEnter/Lookup/Field">
							<xsl:call-template name="FieldReference-ShowTableAlias">
								<xsl:with-param name="inField" select="$inAutoEnter/Lookup/Field"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="$inAutoEnter/Lookup/NoMatchCopyOption">
							<xsl:text>, </xsl:text>
							<xsl:call-template name="LookupCopyMatchValue">
								<xsl:with-param name="inLookupValue" select="$inAutoEnter/Lookup/NoMatchCopyOption/@value"/>
							</xsl:call-template>
							<xsl:if test="$inAutoEnter/Lookup/NoMatchCopyOption/@value = 'CopyConstant'">
								<xsl:value-of select="concat(': ',$inAutoEnter/Lookup/CopyConstantValue)"/>
							</xsl:if>
						</xsl:if>						
						<xsl:if test="$inAutoEnter/Lookup/CopyEmptyContent/@value = 'False'">
							<xsl:text>, </xsl:text>
							<xsl:value-of select="$valDoNotCopyContent"/>
						</xsl:if>
					</li>
				</xsl:if>							
      </ul>
    </xsl:if>
  </xsl:template>
  
  <!-- Template for generating Validation information for field -->
  <!-- Must pass in an Validation node -->
  <xsl:template name="Table-Validation">
    <xsl:param name="inValidation"/>
    <xsl:if test="$inValidation">
      <strong><xsl:value-of select="concat($valValidation,':')"/></strong>			
      <ul>
				<li>
					<xsl:choose>
						<xsl:when test="$inValidation/@type = 'Always'">
							<xsl:value-of select="$valAlwaysValidate"/>
						</xsl:when>
						<xsl:when test="$inValidation/@type = 'OnlyDuringDataEntry'">
							<xsl:value-of select="$valOnlyDuringDataEntry"/>
						</xsl:when>
					</xsl:choose>
				</li>
				<xsl:if test="$inValidation/StrictDataType">
					<li>
						<xsl:value-of select="concat($valStrictDataType,': ')"/>
						<xsl:choose>
							<xsl:when test="$inValidation/StrictDataType/@value = 'FourDigitYear'">
								<xsl:value-of select="$valFourDigitYear"/>
							</xsl:when>
							<xsl:when test="$inValidation/StrictDataType/@value = 'Numeric'">
								<xsl:value-of select="$valNumeric"/>
							</xsl:when>
							<xsl:when test="$inValidation/StrictDataType/@value = 'TimeOfDay'">
								<xsl:value-of select="$valTimeOfDay"/>
							</xsl:when>
						</xsl:choose>						
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/NotEmpty/@value = 'True'">
					<li>
						<xsl:value-of select="$valNotEmpty"/>
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/Unique/@value = 'True'">
					<li>
						<xsl:value-of select="$valUnique"/>
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/Existing/@value = 'True'">
					<li>
						<xsl:value-of select="$valExisting"/>
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/StrictValidation/@value = 'True'">
					<li>
						<xsl:value-of select="$valStrictValidation"/>
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/@valuelist='True' and $inValidation/ValueList">
					<li>
						<xsl:value-of select="concat($valValueList,': ')"/>
						<xsl:call-template name="VLReference">
							<xsl:with-param name="inVL" select="$inValidation/ValueList"/>
						</xsl:call-template>
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/Range">
					<li>
						<xsl:value-of select="concat($valRange,': ', $inValidation/Range/@from, ' - ', $inValidation/Range/@to)"/>
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/@maxLength = 'True' and $inValidation/MaxDataLength">
					<li>
						<xsl:value-of select="concat($valMaxDataLength,': ', $inValidation/MaxDataLength/@value)"/>
					</li>
				</xsl:if>		
				<xsl:if test="$inValidation/@message='True' and $inValidation/ErrorMessage">
					<li>
						<xsl:value-of select="concat($valErrorMessage, ': ', $inValidation/ErrorMessage)"/>
					</li>
				</xsl:if>
				<xsl:if test="$inValidation/@calculation='True' and $inValidation/Calculation">
					<li>
						<xsl:value-of select="concat($valContextTable,': ')"/>
						<xsl:call-template name="TableAliasReferenceGivenName">
							<xsl:with-param name="inTableAliasName" select="$inValidation/Calculation/@table"/>
						</xsl:call-template>
						<br/>
						<xsl:value-of select="concat($valCalculation, ': ')"/>
						<xsl:call-template name="GenerateCalc">
							<xsl:with-param name="inDisplayCalc" select="$inValidation"/>
						</xsl:call-template>
					</li>
				</xsl:if>
      </ul>
    </xsl:if>
  </xsl:template>
  
  <!-- Template for generating Storage information for field -->
  <!-- Must pass in an Storage node -->
  <xsl:template name="Table-Storage">
    <xsl:param name="inStorage"/>
    <xsl:if test="$inStorage">			
      <strong><xsl:value-of select="concat($valStorage,':')"/></strong>			
      <ul>
				<xsl:if test="$inStorage/@global = 'True'">
					<li>
						<xsl:value-of select="$valGlobal"/>
					</li>
				</xsl:if>
				<li>					
					<xsl:value-of select="concat($valRepetitions,': ', $inStorage/@maxRepetition)"/>											
				</li>
				<xsl:if test="$inStorage/@index">
					<li>
						<xsl:value-of select="concat($valIndexing,': ')"/>
						<xsl:call-template name="IndexValue">
							<xsl:with-param name="indexValue" select="$inStorage/@index"/>
						</xsl:call-template>	
					</li>
				</xsl:if>
				<xsl:if test="$inStorage/@autoIndex = 'True'">
					<li>
						<xsl:value-of select="$valAutoTurnIndexOn"/>
					</li>
				</xsl:if>		
				<xsl:if test="$inStorage/@storeCalculationResults = 'False'">
					<li>
						<xsl:value-of select="$valDoNotStoreCalcResults"/>
					</li>
				</xsl:if>							
				<xsl:if test="$inStorage/@indexLanguage">
					<li>					
						<xsl:value-of select="concat($valIndexLanguage,': ')"/>
						<xsl:call-template name="Language">
							<xsl:with-param name="inLang" select="$inStorage/@indexLanguage"/>
						</xsl:call-template>
					</li>
				</xsl:if>
      </ul>
    </xsl:if>
  </xsl:template>
  
  <!-- Must pass in an Furigana node -->
  <xsl:template name="Table-Furigana">
    <xsl:param name="inFurigana"/>
    <xsl:if test="$inFurigana">			
      <strong><xsl:value-of select="concat($valFurigana,':')"/></strong>			
      <ul>
				<xsl:if test="$inFurigana/Field">
					<li>
						<xsl:value-of select="concat($valUseFuriganaField,': ')"/>
						<xsl:call-template name="FieldDefinitionReference">
							<xsl:with-param name="inFieldDefinition" select="$inFurigana/Field"/>
						</xsl:call-template>
					</li>					
				</xsl:if>
				<li>
					<xsl:value-of select="concat($valTranslateInto,': ')"/>
					<xsl:choose>
						<xsl:when test="$inFurigana/@inputMode = 'AsEntered'">
							<xsl:value-of select="$valAsIs"/>
						</xsl:when>
						<xsl:when test="$inFurigana/@inputMode = 'Hiragana'">
							<xsl:value-of select="$valHiragana"/>
						</xsl:when>
						<xsl:when test="$inFurigana/@inputMode = '2ByteKatakana'">
							<xsl:value-of select="$valFullWidthKatakana"/>
						</xsl:when>
						<xsl:when test="$inFurigana/@inputMode = '2ByteRoman'">
							<xsl:value-of select="$valFullWidthRoman"/>
						</xsl:when>
						<xsl:when test="$inFurigana/@inputMode = '1ByteKatakana'">
							<xsl:value-of select="$valHalfWidthKatakana"/>
						</xsl:when>
						<xsl:when test="$inFurigana/@inputMode = '1ByteRoman'">
							<xsl:value-of select="$valHalfWidthRoman"/>
						</xsl:when>										
					</xsl:choose>
				</li>
      </ul>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="IndexValue">
    <xsl:param name="indexValue"/>
    <xsl:choose>
      <xsl:when test="$indexValue = 'None'">
				<xsl:value-of select="$valNone"/>
      </xsl:when>
      <xsl:when test="$indexValue = 'Minimal'">
				<xsl:value-of select="$valMinimal"/>
      </xsl:when>
      <xsl:when test="$indexValue ='All'">
				<xsl:value-of select="$valAll"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <!-- template to generate the table headings for the Table section -->	
  <xsl:template name="TableHeadings-BaseTableCatalog">
    <tr class="chartheaders" vAlign="top">
      <td width="15%">
				<xsl:value-of select="$valTableName"/>				
      </td>
      <td width="29%">
				<div align="left">
					<xsl:value-of select="$valStatistics"/>				
				</div>
      </td>		
      <td width="29%">
				<xsl:value-of select="$valGraphOccurrences"/>				
      </td>			
    </tr>
  </xsl:template>

  <xsl:template name="TableHeadings-ShadowTableCatalog">
    <tr class="chartheaders" vAlign="top">
      <td width="15%">
				<xsl:value-of select="$valTableName"/>				
      </td>
      <td width="29%">
				<div align="left">
					<xsl:value-of select="$valStatistics"/>				
				</div>
      </td>		
      <td width="29%">
				<xsl:value-of select="$valGraphOccurrences"/>				
      </td>			
      <td>
				<xsl:value-of select="$valDataSource"/>
      </td>
    </tr>
  </xsl:template>
  
  <!-- template to generate the table headings for the Field section -->	
  <xsl:template name="TableHeadings-FieldCatalog">
    <xsl:param name="inBaseTable"/>
		<xsl:if test="count($inBaseTable/FieldCatalog/Field) &gt; 0">
			<tr class="privsetfirst" vAlign="top">
				<td colSpan="9">
					<xsl:value-of select="concat($valTableName, ': ')"/>
					<xsl:call-template name="BaseTableAnchor">
						<xsl:with-param name="inBaseTable" select="$inBaseTable/@name"/>
					</xsl:call-template>
					<xsl:value-of select="concat(' - ',count($inBaseTable/FieldCatalog/Field), ' ', $valFields)"/>
				</td>
			</tr>
			<tr class="chartheaders" vAlign="top">
				<td width="8%">
					<xsl:value-of select="$valFieldName"/>
				</td>
				<td width="7%">
					<xsl:value-of select="$valType"/>
				</td>
				<td width="14%">
					<xsl:value-of select="$valOptions"/>
				</td>
				<td width="10%">
					<xsl:value-of select="$valComments"/>
				</td>
				<td width="13%">
					<xsl:value-of select="$valOnLayouts"/>
				</td>
				<td width="15%">
					<xsl:value-of select="$valInRelationships"/>
				</td>
				<td width="22%">
					<xsl:value-of select="$valInScripts"/>
				</td>
				<td width="11%">
					<xsl:value-of select="$valInValueLists"/>
				</td>
			</tr>
		</xsl:if>
  </xsl:template>
  
  <!-- Generate table information -->
  <xsl:template name="Table-BaseTable" match="BaseTableCatalog">
    <xsl:if test="count(BaseTable[string-length(@shadow) = 0 or @shadow='False']) &gt; 0">
		<p>
		<span class="partheading">
					<xsl:call-template name="TableSectionAnchor"/>
		</span>
		</p>		
		<table width="95%" border="1">
		<tbody>
					<!-- Generate the table headings -->				
					<xsl:call-template name="TableHeadings-BaseTableCatalog"/>
					
					<!-- Loop through and document all the table information -->
					<xsl:for-each select="BaseTable[string-length(@shadow) = 0 or @shadow = 'False']">	
						<!--SORTBYNAME removed for quicker parsing -->
						<!--<xsl:sort select="@name"/>	-->
						<tr class="regularcharttext" vAlign="top">					
							<td>							
								<xsl:call-template name="BaseTableReference">
									<xsl:with-param name="inBaseTable" select="@name"/>
								</xsl:call-template>							
							</td>						
							<td>							
								<div align="left">														
									<xsl:choose>
										<xsl:when test="count(FieldCatalog/Field) &gt; 1">
											<xsl:call-template name="Link-WithAnchor">
												<xsl:with-param name="inAnchor" select="concat('#',@id, $kAnchorBaseTable)"/>
												<xsl:with-param name="inDisplayText" select="concat(count(FieldCatalog/Field), ' ', $valfields)"/>
											</xsl:call-template>										
										</xsl:when>
										<xsl:when test="count(FieldCatalog/Field) = 0">
											<xsl:value-of select="concat(count(FieldCatalog/Field), ' ', $valfields)"/>										
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="Link-WithAnchor">
												<xsl:with-param name="inAnchor" select="concat('#',@id, $kAnchorBaseTable)"/>
												<xsl:with-param name="inDisplayText" select="concat(count(FieldCatalog/Field), ' ', $valfield)"/>
											</xsl:call-template>										
										</xsl:otherwise>
									</xsl:choose>					
									<xsl:value-of select="concat(' ', $valDefined, ', ', @records, ' ')"/>
									<xsl:choose>
										<xsl:when test="@records &gt; 1">
											<xsl:value-of select="$valrecords"/>										
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$valrecord"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</td>																	
							<!--Table aliases -->
							<td>									
								<xsl:call-template name="TableAliasList">
									<xsl:with-param name="inBaseTable" select="@name"/>
								</xsl:call-template>							
							</td>						
						</tr>					
					</xsl:for-each>				
		</tbody>
		</table>
	</xsl:if>		

	<xsl:if test="count(BaseTable[@shadow = 'True']) &gt; 0">
		<p>
		<span class="partheading">
			<xsl:call-template name="ShadowTableSectionAnchor"/>
		</span>
		</p>	
		<table width="95%" border="1">
		<tbody>
					<!-- Generate the table headings -->				
					<xsl:call-template name="TableHeadings-ShadowTableCatalog"/>
					
					<!-- Loop through and document all the table information -->
					<xsl:for-each select="BaseTable[@shadow = 'True']">	
						<!--SORTBYNAME removed for quicker parsing -->
						<!--<xsl:sort select="@name"/>	-->
						<tr class="regularcharttext" vAlign="top">					
							<td>							
								<xsl:call-template name="BaseTableReference">
									<xsl:with-param name="inBaseTable" select="@name"/>
								</xsl:call-template>							
							</td>						
							<td align="left">							
								<xsl:variable name="shadow_count" select="count(FieldCatalog/Field[@shadowType = 'Shadow'])"/>

								<xsl:choose>
									<xsl:when test="$shadow_count &gt; 0">
										<xsl:variable name="firstShadow" select="FieldCatalog/Field[@shadowType = 'Shadow'][1]"/>
										<xsl:call-template name="Link-WithAnchor">
											<xsl:with-param name="inAnchor" select="concat('#', @id, $firstShadow/@id, $kAnchorField)"/>
											<xsl:with-param name="inDisplayText" select="concat($shadow_count, ' ', $valShadowFields)"/>
										</xsl:call-template>									
									</xsl:when>
									<xsl:when test="$shadow_count = 0">
										<xsl:value-of select="concat($shadow_count, ' ', $valShadowFields)"/>										
									</xsl:when>
								</xsl:choose>

								<xsl:text>, </xsl:text>
								<xsl:variable name="supp_count" select="count(FieldCatalog/Field[@shadowType = 'Supplemental'])"/>
								<xsl:choose>
									<xsl:when test="$supp_count &gt; 0">
										<xsl:variable name="firstSupplemental" select="FieldCatalog/Field[@shadowType = 'Supplemental'][1]"/>
										<xsl:call-template name="Link-WithAnchor">
											<xsl:with-param name="inAnchor" select="concat('#', @id, $firstSupplemental/@id, $kAnchorField)"/>
											<xsl:with-param name="inDisplayText" select="concat($supp_count, ' ', $valSupplementalFields)"/>
										</xsl:call-template>										
									</xsl:when>
									<xsl:when test="$supp_count = 0">
										<xsl:value-of select="concat($supp_count, ' ', $valSupplementalFields)"/>										
									</xsl:when>
								</xsl:choose>
							</td>	

							<td>									
								<xsl:call-template name="TableAliasList">
									<xsl:with-param name="inBaseTable" select="@name"/>
								</xsl:call-template>							
							</td>						

							<td>
								<xsl:call-template name="FileRefReference">
									<xsl:with-param name="inFileReference" select="DataSourceRef"/>
								</xsl:call-template>
                				<xsl:variable name="dataSourceRef" select="DataSourceRef" />
                				<xsl:value-of select="'; '"/>
								<xsl:if test="$dataSourceRef/@catalogName">
									<xsl:value-of select="concat($dataSourceRef/@catalogName, '.')"/>
								</xsl:if>
                				<xsl:if test="$dataSourceRef/@schemaName">
                  					<xsl:value-of select="concat($dataSourceRef/@schemaName, '.')"/>
                				</xsl:if>
                				<xsl:value-of select="$dataSourceRef/@tableName"/>
              				</td>
						</tr>					
					</xsl:for-each>				
		</tbody>
		</table>
	</xsl:if>		
    
		<xsl:if test="BaseTable/FieldCatalog/Field">
			<p>
				<span class="partheading">
					<xsl:call-template name="FieldSectionAnchor"/>
				</span>
			</p>
		</xsl:if>						
    
    <!-- Loop again to generate the field information for the tables -->
    <xsl:for-each select="BaseTable">	
      <!--SORTBYNAME-->
      <!--<xsl:sort select="@name"/>-->

      <xsl:if test="generate-id(.) != generate-id(ancestor::BaseTableCatalog/BaseTable[1]) and FieldCatalog/Field">
				<br/>				
      </xsl:if>
			
      <xsl:apply-templates/>			
    </xsl:for-each>									
    
  </xsl:template>
  
  <!-- Generate a table of field information stuff only right now -->
  <xsl:template name="Table-FieldCatalog" match="FieldCatalog">
		<xsl:if test="count(./Field) &gt; 0">
			<table width="100%" border="1">
				<tbody>
					<!--Generate the table headings -->
					<xsl:call-template name="TableHeadings-FieldCatalog">
						<xsl:with-param name="inBaseTable" select="ancestor::BaseTable"/>
					</xsl:call-template>

					<!--Process each Field child node. -->
					<xsl:apply-templates/>
				</tbody>
			</table>
		</xsl:if>
  </xsl:template>

  <xsl:template name="Table-FieldCalc">
    <xsl:param name="inFieldCalc"/>
    <xsl:if test="$inFieldCalc/Calculation">
      <strong><xsl:value-of select="concat($valCalculation,':')"/></strong>
      <ul>
				<li>
					<xsl:value-of select="concat($valContextTable,': ')"/>
					<xsl:call-template name="TableAliasReferenceGivenName">
						<xsl:with-param name="inTableAliasName" select="$inFieldCalc/Calculation/@table"/>
					</xsl:call-template>
				</li>
				<li>
					<xsl:call-template name="GenerateCalc">
						<xsl:with-param name="inDisplayCalc" select="$inFieldCalc"/>
					</xsl:call-template>
				</li>
      </ul>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="Table-SummaryInfo">
    <xsl:param name="inSummaryInfo"/>
    <xsl:if test="$inSummaryInfo">
      <strong><xsl:value-of select="concat($valSummaryInfo,':')"/></strong>
      <ul>
				<li>
					<xsl:choose>
						<xsl:when test="$inSummaryInfo/@operation = 'Total'">
							<xsl:value-of select="$valTotal"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'RunningTotal'">
							<xsl:value-of select="$valRunningTotal"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'Average'">
							<xsl:value-of select="$valAverage"/>						
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'WeightedAverage'">
							<xsl:value-of select="$valWeightedAverage"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'Count'">
							<xsl:value-of select="$valCount"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'RunningCount'">
							<xsl:value-of select="$valRunningCount"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'Minimum'">
							<xsl:value-of select="$valMinimum"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'Maximum'">
							<xsl:value-of select="$valMaximum"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'StdDeviation'">
							<xsl:value-of select="$valStdDeviation"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'StdDeviationByPopulation'">
							<xsl:value-of select="$valStdDeviationByPopulation"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'Fractional'">
							<xsl:value-of select="$valFractional"/>
						</xsl:when>
						<xsl:when test="$inSummaryInfo/@operation = 'FractionalSubtotal'">
							<xsl:value-of select="$valFractionalSubtotal"/>
						</xsl:when>	
					</xsl:choose>
				</li>
				<li>
					<xsl:choose>
						<xsl:when test="$inSummaryInfo/@summarizeRepetition = 'Together'">
							<xsl:value-of select="$valTogether"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$valIndividually"/>
						</xsl:otherwise>
					</xsl:choose>
				</li>
				<xsl:if test="$inSummaryInfo/@restartForEachSortedGroup = 'True'">
					<li>
						<xsl:value-of select="$valRestartForEachSelectedGroup"/>
					</li>
				</xsl:if>
				
				<li>
					<xsl:value-of select="concat($valSummaryField,': ')"/>
					<xsl:call-template name="Link-WithAnchor">
						<xsl:with-param name="inAnchor" select="concat('#', ancestor::BaseTable/@id, $inSummaryInfo/SummaryField/Field/@id, $kAnchorField)"/>
						<xsl:with-param name="inDisplayText" select="$inSummaryInfo/SummaryField/Field/@name"/>
					</xsl:call-template>
					<xsl:if test="$inSummaryInfo/AdditionalField">
						<xsl:value-of select="concat(', ',$valAdditionalField,': ')"/>
						<xsl:choose>
							<xsl:when test="$inSummaryInfo/AdditionalField/Field/@table">
								<xsl:call-template name="FieldReference-ShowTableAlias">
									<xsl:with-param name="inField" select="$inSummaryInfo/AdditionalField/Field"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="Link-WithAnchor">
									<xsl:with-param name="inAnchor" select="concat('#', ancestor::BaseTable/@id, $inSummaryInfo/AdditionalField/Field/@id, $kAnchorField)"/>
									<xsl:with-param name="inDisplayText" select="$inSummaryInfo/AdditionalField/Field/@name"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</li>
      </ul>			
    </xsl:if>
  </xsl:template>
  
  <!-- Generate a field information -->
  <xsl:template name="Table-Field" match="FieldCatalog/Field">
    <tr class="regularcharttext" vAlign="top">
      <td>				
				<xsl:call-template name="FieldAnchor">
					<xsl:with-param name="inField" select="."/>
					<xsl:with-param name="inBaseTable" select="ancestor::BaseTable"/>
				</xsl:call-template>				
      </td>			
      <td>				
				<xsl:call-template name="FieldType">
					<xsl:with-param name="inFieldType" select="@fieldType"/>
				</xsl:call-template>	
				<xsl:text>, </xsl:text>				
				<xsl:call-template name="DataType">
					<xsl:with-param name="inDataType" select="@dataType"/>
				</xsl:call-template>

				<xsl:if test="@shadowType">
					<xsl:text>, </xsl:text>
					<xsl:call-template name="ShadowType">
						<xsl:with-param name="type" select="@shadowType"/>
					</xsl:call-template>
				</xsl:if>
				<!--<xsl:if test="@alwaysEvaluate = 'True'">
						<xsl:text>, </xsl:text>
						<xsl:value-of select="$valAlwaysEvaluate"/>					
					</xsl:if>-->
      </td>	
      
      <td>
				<!--Field calcs -->
				<xsl:call-template name="Table-FieldCalc">
					<xsl:with-param name="inFieldCalc" select="."/>
				</xsl:call-template>
				
				<!--Summary-->
				<xsl:call-template name="Table-SummaryInfo">
					<xsl:with-param name="inSummaryInfo" select="SummaryInfo"/>
				</xsl:call-template>
				<!-- Auto-enter information. -->
				<xsl:call-template name="Table-AutoEnter">
					<xsl:with-param name="inAutoEnter" select="AutoEnter"/>
				</xsl:call-template>
				
				<!-- Validation informaiton -->		
				<xsl:call-template name="Table-Validation">
					<xsl:with-param name="inValidation" select="Validation"/>
				</xsl:call-template>
				
				<!-- Storage information -->					
				<xsl:call-template name="Table-Storage">
					<xsl:with-param name="inStorage" select="Storage"/>
				</xsl:call-template>	
				
				<!--Furigana-->
				<xsl:if test="AutoEnter/@furigana='True'">
					<xsl:call-template name="Table-Furigana">
						<xsl:with-param name="inFurigana" select="Furigana"/>
					</xsl:call-template>
				</xsl:if>
      </td>	
      
      <!-- Field Comments -->	
      <td>
				<xsl:value-of select="Comment"/>
      </td>	
      
      <!-- Generate the layout references for the fields -->	
      <xsl:variable name="varBaseTable" select="ancestor::BaseTable/@name"/>	
      <xsl:variable name="varFieldName" select="@name"/>
      <td>	
				<ul>							
					<xsl:variable name="layoutList" select="key('LayoutByFieldIndex',$varFieldName)[*/*//Field[key('BaseTable-TableAliasIndex',@table)[@baseTable = $varBaseTable and not(FileReference)]]]"/>
					<xsl:for-each select="$layoutList">
						<!--SORTBYNAME-->
						<!--<xsl:sort select="@name"/>-->
						<li>							
							<xsl:call-template name="LayoutReference">
								<xsl:with-param name="inLayout" select="."/>
							</xsl:call-template>							
						</li>
					</xsl:for-each>																	
				</ul>				
      </td>
      <!-- Relationship References -->			
      <td>				
				<xsl:variable name="varRelationshipList" select="/FMPReport/File/RelationshipGraph/RelationshipList/Relationship[JoinPredicateList/JoinPredicate//Field[(@name = $varFieldName) and (key('BaseTable-TableAliasIndex', @table)/@baseTable = $varBaseTable)]]"/>					
				<ul>
					<xsl:for-each select="$varRelationshipList">
						<li>
							<xsl:call-template name="RelationshipReference">
								<xsl:with-param name="inRelationship" select="."/>
							</xsl:call-template>
						</li>
					</xsl:for-each>
				</ul>
      </td>
      
      <!-- Script references -->
      <td>
				<ul>															
					<xsl:for-each select="key('ScriptByFieldIndex', $varFieldName)[*/*//Field[key('BaseTable-TableAliasIndex',@table)[@baseTable = $varBaseTable and not(FileReference)]]]">																					
						<!--SORTBYNAME-->
						<!--<xsl:sort select="@name"/>-->
						<li>							
							<xsl:call-template name="ScriptReference">
								<xsl:with-param name="inScript" select="."/>
							</xsl:call-template>							
						</li>
					</xsl:for-each>																	
				</ul>							
      </td>
      
      <!-- Generate the value list references for fields -->
      <td>	
				<ul>					
					<xsl:for-each select="key('VLByFieldIndex', $varFieldName)[*/Field[key('BaseTable-TableAliasIndex',@table)[@baseTable = $varBaseTable and not(FileReference)]]]">					
						<!--SORTBYNAME-->
						<!--<xsl:sort select="@name"/>-->
						<li>							
							<xsl:call-template name="VLReference">
								<xsl:with-param name="inVL" select="."/>
							</xsl:call-template>							
						</li>			
					</xsl:for-each>								
				</ul>			
      </td>
      
    </tr>
  </xsl:template>

  <xsl:template name="ConditionalFormattingDetails">
    <xsl:param name="obj"/>

    <xsl:if test="$obj/ConditionalFormatting">
      <table width="100%" border="1">
				<tr class="chartheaders">
					<td width="18%">
						<xsl:value-of select="$valConditionalFormatting"/>
					</td>
					<td align="center" width="43%">
						<xsl:value-of select="$valCondition"/>
					</td>
					<td align="center" width="39%">
						<xsl:value-of select="$valFormat"/>
					</td>
				</tr>
				<tr class="regularcharttext">
					<xsl:for-each select="$obj/ConditionalFormatting">
						<xsl:call-template name="LayoutObjectConditionalFormatting"/>
					</xsl:for-each>
				</tr>
      </table>
    </xsl:if>
  </xsl:template>

  <!-- Generate contents of a Script Triggers column -->
  <!-- Input node is a ScriptTriggers node -->
  <xsl:template name="ScriptTriggersContents">
    <xsl:param name="triggersParent"/>
		<xsl:if test="$triggersParent/ScriptTriggers">
			<xsl:for-each select="$triggersParent/ScriptTriggers/Trigger">
				<xsl:call-template name="OneScriptTrigger">
					<xsl:with-param name="TriggerNode" select="."/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
  </xsl:template>
  
  <!-- Input node is a Trigger -->
  <xsl:template name="OneScriptTrigger">
    <xsl:param name="TriggerNode"/>
	<ul>
				<!-- Trigger Event Name -->
				<b><xsl:value-of select="$TriggerNode/@event"/></b>

				<!-- Trigger Script -->
					<li>
            <xsl:value-of select="$valScriptItem"/>
            <!--Create hyperlink to corresponding script-->
            <xsl:choose>
              <xsl:when test="not($TriggerNode/Script/@fromFile)">
                <xsl:call-template name="ScriptReference">
                  <xsl:with-param name="inScript" select="$TriggerNode/Script"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="ExternalScriptReference">
                  <xsl:with-param name="inFileRef" select="$TriggerNode/Script/FileReference"/>
                  <xsl:with-param name="inScript" select="$TriggerNode/Script"/>
                 </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
					</li>

				<!-- From file -->
				<xsl:if test="$TriggerNode/Script/@fromFile">
					<li>
						<xsl:value-of select="$valFromFileItem"/>
						<xsl:value-of select="$TriggerNode/Script/@fromFile"/>
					</li>
				</xsl:if>

				<!-- Parameter -->
				<xsl:if test="$TriggerNode/Script/@Parameter">
					<li>
						<xsl:value-of select="$valParameterItem"/>
						<xsl:value-of select="$TriggerNode/Script/@Parameter"/>
					</li>
				</xsl:if>

				<!-- Trigger Properties -->
					<li>
						<xsl:value-of select="$valModes"/>
						<xsl:variable name="triggerBrowseMode">
							<xsl:call-template name="Bit">
								<xsl:with-param name="inVal" select="$TriggerNode/@triggerFlags"/>
								<xsl:with-param name="inBit" select="1"/>
							</xsl:call-template>			
						</xsl:variable>
						<xsl:if test="$triggerBrowseMode = 'true'">
								<xsl:value-of select="$valModeBrowse"/>
						</xsl:if>
						<xsl:variable name="triggerFindMode">
							<xsl:call-template name="Bit">
								<xsl:with-param name="inVal" select="$TriggerNode/@triggerFlags"/>
								<xsl:with-param name="inBit" select="2"/>
							</xsl:call-template>			
						</xsl:variable>
						<xsl:if test="$triggerFindMode = 'true'">
								<xsl:if test="$triggerBrowseMode = 'true'">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="$valModeFind"/>
						</xsl:if>
						<xsl:variable name="triggerPreviewMode">
							<xsl:call-template name="Bit">
								<xsl:with-param name="inVal" select="$TriggerNode/@triggerFlags"/>
								<xsl:with-param name="inBit" select="4"/>
							</xsl:call-template>			
						</xsl:variable>
						<xsl:if test="$triggerPreviewMode = 'true'">
								<xsl:if test="$triggerBrowseMode = 'true' or $triggerFindMode = 'true'">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="$valModePreview"/>
						</xsl:if>
					</li>
	</ul>
  </xsl:template>

  <!-- Layout Hierarchy -->
  <xsl:template name="LayoutHierarchy">
  <xsl:param name="inDisplayText"/>
  <xsl:value-of select="$inDisplayText"/>
  <p></p>
   <table class="script_hier">
      <tbody>
        <xsl:for-each select="*">
          <tr>
            <td class="script_hier">
              <a name="{concat(@id, $kAnchorLayout, 'toc')}"/>
              <xsl:choose>
                <xsl:when test="name() = 'Group'">
                  <a href="#{concat(.//Layout[1]/@id, $kAnchorLayout)}">
                    <xsl:value-of select="@name"/>
                  </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="#{concat(@id, $kAnchorLayout)}">
                      <xsl:value-of select="@name"/>
                    </a>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <xsl:if test="name() = 'Group'">
            <tr>
              <td class="script_hier">
                <table class="script_hier">
                  <tbody>
                    <tr class="script_hier_guide">
                      <td class="script_hier_spacer"/>
                      <td class="script_hier">
                        <xsl:call-template name="LayoutHierarchy"/>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </xsl:if>
        </xsl:for-each>
      </tbody>
    </table>
  </xsl:template>

  <!-- Generate a table layout information stuff only right now -->
  <xsl:template name="Table-LayoutCatalog" match="LayoutCatalog">
     <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valLayouts', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valLayouts"/>
				</xsl:call-template>
      </span>
    </p>
    <p>
      <span class="partheading">
      <xsl:call-template name="LayoutHierarchy">
      <xsl:with-param name="inDisplayText" select="$valLayoutHierarchy"/>
      </xsl:call-template>
      </span>
    </p>
    <br/>
    <table width="100%" border="1">
      <tbody>
				<tr class="chartheaders" vAlign="top">
					<td width="10%">
						<xsl:value-of select="$valLayoutName"/>
					</td>
					<td width="5%">
						<xsl:value-of select="$valIncludeInMenu"/>
					</td>
          			<td width="5%">
           				<xsl:value-of select="$valQuickFind"/>
          			</td>
					<td width="13%">
						<xsl:value-of select="$valNumberOfObjects"/>
					</td>
					<td width="10%">
						<xsl:value-of select="$valShowRecordsFrom"/>
					</td>
					<td width="10%">
						<xsl:value-of select="$valSaveRecordChanges"/>
					</td>
					<td width="8%">
						<xsl:value-of select="$valShowFieldFrames"/>
					</td>
					<td width="10%">
						<xsl:value-of select="$valUsedInScripts"/>
					</td>
					<td width="13%">
						<xsl:value-of select="$valCustomMenuSet"/>
					</td>
					<td width="16%">
						<xsl:value-of select="$valScriptTriggers"/>
					</td>
				</tr>				
				<xsl:for-each select=".//Layout">
					<xsl:call-template name="Table-Layout"/>
				</xsl:for-each>
      </tbody>
    </table>
    <xsl:for-each select=".//Layout">
      <xsl:if test="Table">
        <!-- document the layout objects -->
        <p>
				  <span class="partheading">
					  <xsl:value-of select="concat($valLayoutObjects,': ')"/>
					  <xsl:call-template name="LayoutReference">
						  <xsl:with-param name="inLayout" select="."/>
					  </xsl:call-template>
				  </span>
        </p>	
        <xsl:call-template name="Table-Layout-Objects"/>
      </xsl:if>
    </xsl:for-each>
    
  </xsl:template>		
  
  <xsl:template name="Bit">
    <xsl:param name="inVal"/>
    <xsl:param name="inBit"/>
    <xsl:choose>
      <xsl:when test="(($inVal mod ($inBit*2)) - ($inVal mod ($inBit))) &gt; 0">
				<xsl:value-of select="'true'"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="'false'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="FieldFormatType">
    <xsl:param name="inDisplayType"/>
    <xsl:choose>
      <xsl:when test="$inDisplayType='0'">
				<xsl:value-of select="$valEditBox"/>
      </xsl:when>
      <xsl:when test="$inDisplayType='1'">
				<xsl:value-of select="$valPopupList"/>
      </xsl:when>
      <xsl:when test="$inDisplayType='2'">
				<xsl:value-of select="$valPopupMenu"/>
      </xsl:when>
      <xsl:when test="$inDisplayType='3'">
				<xsl:value-of select="$valCheckboxSet"/>
      </xsl:when>
      <xsl:when test="$inDisplayType='4'">
				<xsl:value-of select="$valRadioButtonSet"/>
      </xsl:when>	
      <xsl:when test="$inDisplayType='5'">
				<xsl:value-of select="$valSelectionList"/>
      </xsl:when>				
      <xsl:when test="$inDisplayType='6'">
				<xsl:value-of select="$valDropdownCalendar"/>
      </xsl:when>				
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="FieldFormatFlag">
    <xsl:param name="inText"/>
    <xsl:param name="inVal"/>
    <xsl:param name="inBit"/>
    <xsl:variable name="bitResult">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inVal"/>
				<xsl:with-param name="inBit" select="$inBit"/>
      </xsl:call-template>			
    </xsl:variable>
    <xsl:if test="$bitResult = 'true'">
      <xsl:value-of select="$inText"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="FieldFormatShowRep">
    <xsl:param name="inFieldObject"/>
    <xsl:value-of select="concat($valShowRepetition,': ')"/>
    <xsl:value-of select="concat($inFieldObject/DDRInfo/Field/@repetition,' ',$valThrough,' ')"/>
    <xsl:variable name="numOfReps">
      <xsl:choose>
				<xsl:when test="$inFieldObject/@numOfReps &lt; 0">
					<xsl:value-of select="-($inFieldObject/@numOfReps)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$inFieldObject/@numOfReps"/>
				</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="$inFieldObject/DDRInfo/Field/@repetition + $numOfReps - 1"/>
  </xsl:template>
  
  <xsl:template name="FieldFormatOrientation">
    <xsl:param name="inFieldObject"/>
    <xsl:variable name="orientation">
      <xsl:choose>
				<xsl:when test="$inFieldObject/@numOfReps &lt; 0">
					<xsl:value-of select="$valHorizontal"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$valVertical"/>
				</xsl:otherwise>
      </xsl:choose>		
    </xsl:variable>
    <xsl:value-of select="concat($valOrientation, ': ',$orientation)"/>
  </xsl:template>
  
  <xsl:template name="FieldFormat">
    <xsl:param name="inObject"/>
    
    <!--Bit values -->
    <xsl:variable name="bitVScrollBar" select="256"/>
    <xsl:variable name="bitIncludeOther" select="1"/>
    <xsl:variable name="bitIncludeEdit" select="8"/>
    <xsl:variable name="bitAutoComplete" select="2048"/>
    <xsl:variable name="bitIncludeDropIcon" select="1024"/>
    
    <xsl:value-of select="concat($valFieldFormat,': ')"/>
    <ul>
      <li>
				<xsl:call-template name="FieldFormatType">
					<xsl:with-param name="inDisplayType" select="$inObject/@displayType"/>
				</xsl:call-template>
      </li>
      <xsl:variable name="valueList" select="$inObject/DDRInfo/ValueList"/>
      <xsl:if test="$valueList and $inObject/@displayType != '0' and $inObject/@displayType != '6'">
				<li>
					<xsl:value-of select="concat($valDisplayValFrom, ': ')"/>
					<xsl:call-template name="VLReference">
						<xsl:with-param name="inVL" select="$valueList"/>
					</xsl:call-template>
				</li>
      </xsl:if>
      
      <!--Vertical Scroll bar. -->
      <xsl:variable name="includeVScroll">
				<xsl:call-template name="Bit">
					<xsl:with-param name="inVal" select="$inObject/@flags"/>
					<xsl:with-param name="inBit" select="$bitVScrollBar"/>
				</xsl:call-template>
      </xsl:variable>
      <xsl:if test="$includeVScroll = 'true'">
				<li>
					<xsl:value-of select="$valIncludeVScrollBar"/>
				</li>
      </xsl:if>
      
      <!--Include Other..."-->		
      <xsl:variable name="includeOther">
				<xsl:call-template name="Bit">
					<xsl:with-param name="inVal" select="$inObject/@flags"/>
					<xsl:with-param name="inBit" select="$bitIncludeOther"/>
				</xsl:call-template>
      </xsl:variable>
      <xsl:if test="$includeOther='true'">
				<li>
					<xsl:value-of select="$valIncludeOther"/>
				</li>
      </xsl:if>			
      <!--Include Edit..."-->		
      
      <xsl:variable name="includeEdit">
				<xsl:call-template name="Bit">
					<xsl:with-param name="inVal" select="$inObject/@flags"/>
					<xsl:with-param name="inBit" select="$bitIncludeEdit"/>
				</xsl:call-template>
      </xsl:variable>
      <xsl:if test="$includeEdit='true'">
				<li>
					<xsl:value-of select="$valIncludeEdit"/>
				</li>
      </xsl:if>	
      <!--Include drop icon-->
      <xsl:if test="$inObject/@displayType ='6'">
				<xsl:variable name="includeDropIcon">
					<xsl:call-template name="Bit">
						<xsl:with-param name="inVal" select="$inObject/@flags"/>
						<xsl:with-param name="inBit" select="$bitIncludeDropIcon"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="$includeDropIcon='true'">
					<li>
						<xsl:value-of select="$valIncludeDropIcon"/>
					</li>
				</xsl:if>		
      </xsl:if>
      
      <!--Auto-complete-->
      <xsl:variable name="autoComplete">
				<xsl:call-template name="Bit">
					<xsl:with-param name="inVal" select="$inObject/@flags"/>
					<xsl:with-param name="inBit" select="$bitAutoComplete"/>
				</xsl:call-template>
      </xsl:variable>
      <xsl:if test="$autoComplete='true'">
				<li>					
					<xsl:choose>
						<xsl:when test="$inObject/@displayType ='1'">
							<xsl:value-of select="$valAutoCompleteUsingValueList"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$valAutoCompletePreviousValues"/>
						</xsl:otherwise>
					</xsl:choose>
				</li>				
				
      </xsl:if>		
      
      <!--Include arrow-->
      <xsl:if test="$inObject/@displayType ='1'">
				<xsl:variable name="includeArrow">
					<xsl:call-template name="Bit">
						<xsl:with-param name="inVal" select="$inObject/@flags"/>
						<xsl:with-param name="inBit" select="$bitIncludeDropIcon"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="$includeArrow='true'">
					<li>
						<xsl:value-of select="$valIncludeArrow"/>
					</li>
				</xsl:if>		
      </xsl:if>
      
      <!--Repetition-->								
      <xsl:if test="$inObject/DDRInfo/Field/@maxRepetition > '1'">
				<li>
					<xsl:call-template name="FieldFormatShowRep">
						<xsl:with-param name="inFieldObject" select="$inObject"/>
					</xsl:call-template>
				</li>
				<!--Orientation-->
				<li>
					<xsl:call-template name="FieldFormatOrientation">
						<xsl:with-param name="inFieldObject" select="$inObject"/>
					</xsl:call-template>
				</li>
      </xsl:if>
    </ul>
  </xsl:template>
  
  <xsl:template name="FieldBehaviorInputMode">
    <xsl:param name="inVal"/>
    <xsl:choose>	
      <xsl:when test="$inVal='128'">
				<xsl:value-of select="$valSynchFieldFont"/>
      </xsl:when>
      <xsl:when test="$inVal='129'">
				<xsl:value-of select="$valJapActive"/>
      </xsl:when>
      <xsl:when test="$inVal='130'">
				<xsl:value-of select="$valJapDirect"/>
      </xsl:when>
      <xsl:when test="$inVal='131'">
				<xsl:value-of select="$valHiragana"/>
      </xsl:when>
      <xsl:when test="$inVal='132'">
				<xsl:value-of select="$valFullWidthKatakana"/>
      </xsl:when>
      <xsl:when test="$inVal='133'">
				<xsl:value-of select="$valFullWidthAlpha"/>
      </xsl:when>
      <xsl:when test="$inVal='134'">
				<xsl:value-of select="$valHalfWidthKatakana"/>
      </xsl:when>
      <xsl:when test="$inVal='135'">
				<xsl:value-of select="$valHalfWidthAlpha"/>
      </xsl:when>			
    </xsl:choose>
  </xsl:template>

  <xsl:template name="QuickFind">
    <xsl:param name="inObject"/>

    <xsl:if test="$inObject/@quickFind = 1 or $inObject/@quickFind = 'True'">
      <xsl:value-of select="$valYes"/>
    </xsl:if>
    <xsl:if test="$inObject/@quickFind = 0 or $inObject/@quickFind = 'False'">
      <xsl:value-of select="$valNo"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="FieldBehavior">
    <xsl:param name="inObject"/>
    
    <xsl:variable name="bitNoFindModeEntry" select="16"/>
    <xsl:variable name="bitNoBrowseModeEntry" select="4"/>
    <xsl:variable name="bitSelectEntireContents" select="2"/>
    <xsl:variable name="bitDisableVisualSpellChecking" select="8192"/>
    <xsl:variable name="bitTab" select="32"/>
    <xsl:variable name="bitReturn" select="64"/>
    <xsl:variable name="bitEnter" select="128"/>
    
    <xsl:variable name="findMode">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inObject/@flags"/>
				<xsl:with-param name="inBit" select="$bitNoFindModeEntry"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="browseMode">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inObject/@flags"/>
				<xsl:with-param name="inBit" select="$bitNoBrowseModeEntry"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="selectEntireContents">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inObject/@flags"/>
				<xsl:with-param name="inBit" select="$bitSelectEntireContents"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="disableVisualSpellChecking">
      <xsl:call-template name="Bit">
        <xsl:with-param name="inVal" select="$inObject/@flags"/>
        <xsl:with-param name="inBit" select="$bitDisableVisualSpellChecking"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="useTab">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inObject/@flags"/>
				<xsl:with-param name="inBit" select="$bitTab"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="useReturn">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inObject/@flags"/>
				<xsl:with-param name="inBit" select="$bitReturn"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="useEnter">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inObject/@flags"/>
				<xsl:with-param name="inBit" select="$bitEnter"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="($findMode = 'false') or ($browseMode = 'false') or ($selectEntireContents = 'true') or ($useTab = 'true') or ($useReturn = 'true') or ($useEnter = 'true') or ($disableVisualSpellChecking = 'true')">		
      <xsl:value-of select="concat($valFieldBehavior,':')"/>
      <ul>
				<xsl:variable name="allowFieldEnter">					
					<xsl:if test="$findMode = 'false'">
						<xsl:value-of select="$valInFindMode"/>
					</xsl:if>					
					<xsl:if test="$browseMode = 'false'">
						<xsl:choose>
							<xsl:when test="$findMode = 'false'">
								<xsl:value-of select="concat(', ',$valInBrowseMode)"/>
							</xsl:when>				
							<xsl:otherwise>
								<xsl:value-of select="$valInBrowseMode"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:variable>
				<xsl:if test="string-length($allowFieldEnter) &gt; 0">
					<li>
						<xsl:value-of select="concat($valAllowFieldEnter,': ',$allowFieldEnter)"/>
					</li>
				</xsl:if>	
				<!--Select entire contents-->				
				<xsl:if test="$selectEntireContents='true'">
					<li>
						<xsl:value-of select="$valSelectEntireContents"/>
					</li>
				</xsl:if>
        <!--Enable visual spel-checking-->
        <xsl:if test="$disableVisualSpellChecking='true'">
          <li>
            <xsl:value-of select="$valDisableVisualSpellChecking"/>
          </li>
        </xsl:if>

        <!--Input mode-->
				<xsl:if test="($inObject/@inputMode &lt; '136' and $inObject/@inputMode &gt; '127')">
					<li>
						<xsl:value-of select="concat($valSetInputMethod,': ')"/>
						<xsl:call-template name="FieldBehaviorInputMode">
							<xsl:with-param name="inVal" select="$inObject/@inputMode"/>
						</xsl:call-template>
					</li>
				</xsl:if>
				
				<!--Go to next field-->				
				<xsl:variable name="goToNextField">
					<xsl:if test="$useTab='true'">
						<xsl:value-of select="$valTabKey"/>
					</xsl:if>
					<xsl:if test="$useReturn ='true'">
						<xsl:if test="$useTab='true'">
							<xsl:value-of select="', '"/>
						</xsl:if>
						<xsl:value-of select="$valReturnKey"/>
					</xsl:if>
					<xsl:if test="$useEnter ='true'">
						<xsl:if test="$useReturn='true' or $useTab='true'">
							<xsl:value-of select="', '"/>
						</xsl:if>
						<xsl:value-of select="$valEnterKey"/>
					</xsl:if>
				</xsl:variable>
				<xsl:if test="$useTab = 'true' or $useReturn = 'true' or $useEnter = 'true'">
					<li>
						<xsl:value-of select="concat($valGoToNextField,': ', $goToNextField)"/>
					</li>
				</xsl:if>
      </ul>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="AutoResizeAnchoring">
    <xsl:param name="obj"/>

    <xsl:variable name="bitDontAnchorLeft" select="268435456"/>
    <xsl:variable name="bitDontAnchorTop" select="536870912"/>
    <xsl:variable name="bitAnchorRight" select="1073741824"/>
    <xsl:variable name="bitAnchorBottom" select="2147483648"/>

		<xsl:variable name="Flags" select="$obj/@flags + 4294967296"/>
		
    <xsl:choose>
      <xsl:when test="boolean(floor($Flags div $bitDontAnchorLeft) mod 2) and boolean(floor($Flags div $bitAnchorRight) mod 2 = 0)">
				<xsl:value-of select="$valCenter"/>
      </xsl:when>
      <xsl:when test="boolean(floor($Flags div $bitDontAnchorLeft) mod 2 = 0) and boolean(floor($Flags div $bitAnchorRight) mod 2)">
				<xsl:value-of select="$valAutoResizeLeftRight"/>
      </xsl:when>
      <xsl:when test="floor($Flags div $bitDontAnchorLeft) mod 2 = 0">
				<xsl:value-of select="$valLeft"/>
      </xsl:when>
      <xsl:when test="floor($Flags div $bitAnchorRight) mod 2">
				<xsl:value-of select="$valRight"/>
      </xsl:when>
    </xsl:choose>
		<xsl:text>, </xsl:text>
    <xsl:choose>
      <xsl:when test="boolean(floor($Flags div $bitDontAnchorTop) mod 2) and boolean(floor($Flags div $bitAnchorBottom) mod 2 = 0)">
				<xsl:value-of select="$valCenter"/>
      </xsl:when>
      <xsl:when test="boolean(floor($Flags div $bitDontAnchorTop) mod 2 = 0) and boolean(floor($Flags div $bitAnchorBottom) mod 2)">
				<xsl:value-of select="$valAutoResizeTopBottom"/>
      </xsl:when>
      <xsl:when test="floor($Flags div $bitDontAnchorTop) mod 2 = 0">
				<xsl:value-of select="$valTop"/>
      </xsl:when>
      <xsl:when test="floor($Flags div $bitAnchorBottom) mod 2">
				<xsl:value-of select="$valBottom"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- will spit out draw style of the current node -->
  <xsl:template name="LayoutObjectDrawStyle">
    <xsl:if test="string(@fillColor)">
		<xsl:if test="floor(../../@flags div 4) mod 2">
			<li>
				<xsl:value-of select="concat($valFillColor, ': ', @fillColor)"/>
			</li>
		</xsl:if>	
    </xsl:if>
  </xsl:template>

  <xsl:template name="CharacterStyleFontFace">
    <xsl:variable name="Bold" select="256"/>
    <xsl:variable name="Italic" select="512"/>
    <xsl:variable name="Underline" select="1024"/>
    <xsl:variable name="Condense" select="8192"/>
    <xsl:variable name="Extend" select="16384"/>
    <xsl:variable name="Strikethrough" select="1"/>
    <xsl:variable name="SmallCaps" select="2"/>
    <xsl:variable name="Superscript" select="4"/>
    <xsl:variable name="Subscript" select="8"/>
    <xsl:variable name="Highlight" select="4096"/>
    <xsl:variable name="Uppercase" select="16"/>
    <xsl:variable name="Lowercase" select="32"/>
    <xsl:variable name="TitleCase" select="48"/>
    <xsl:variable name="WordUnderline" select="64"/>
    <xsl:variable name="DoubleUnderline" select="128"/>

    <xsl:if test="floor(Face div $Bold) mod 2">
      <xsl:value-of select="concat($valFontFaceBold, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Italic) mod 2">
      <xsl:value-of select="concat($valFontFaceItalic, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Underline) mod 2">
      <xsl:value-of select="concat($valFontFaceUnderline, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Condense) mod 2">
      <xsl:value-of select="concat($valFontFaceCondense, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Extend) mod 2">
      <xsl:value-of select="concat($valFontFaceExtend, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Strikethrough) mod 2">
      <xsl:value-of select="concat($valFontFaceStrikethrough, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $SmallCaps) mod 2">
      <xsl:value-of select="concat($valFontFaceSmallCaps, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Superscript) mod 2">
      <xsl:value-of select="concat($valFontFaceSuperscript, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Subscript) mod 2">
      <xsl:value-of select="concat($valFontFaceSubscript, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $Highlight) mod 2">
      <xsl:value-of select="concat($valFontFaceHighlight, ', ')"/>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="boolean(floor(Face div $Lowercase) mod 2) and boolean(floor(Face div $Uppercase) mod 2)">
				<xsl:value-of select="concat($valFontFaceTitleCase, ', ')"/>
      </xsl:when>
      <xsl:when test="floor(Face div $Lowercase) mod 2">
				<xsl:value-of select="concat($valFontFaceLowercase, ', ')"/>
      </xsl:when>
      <xsl:when test="floor(Face div $Uppercase) mod 2">
				<xsl:value-of select="concat($valFontFaceUppercase, ', ')"/>
      </xsl:when>
    </xsl:choose>
    <xsl:if test="floor(Face div $WordUnderline) mod 2">
      <xsl:value-of select="concat($valFontFaceWordUnderline, ', ')"/>
    </xsl:if>
    <xsl:if test="floor(Face div $DoubleUnderline) mod 2">
      <xsl:value-of select="concat($valFontFaceDoubleUnderline, ', ')"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="LayoutObjectCharacterStyle">
    <xsl:variable name="ApplyFontFace" select="8"/>
    <xsl:variable name="ApplyFontSize" select="16"/>
    <xsl:variable name="ApplyFontColor" select="2"/>

    <xsl:if test="Font-family">
			<xsl:if test="floor(../../@flags div $ApplyFontFace) mod 2">
				<li>
					<xsl:value-of select="concat($valFontName, ': ', Font-family)"/>
				</li>
			</xsl:if>
    </xsl:if>
    <xsl:if test="Font-size">
			<xsl:if test="floor(../../@flags div $ApplyFontSize) mod 2">
				<li>
					<xsl:value-of select="concat($valFontSize, ': ', Font-size)"/>
				</li>
			</xsl:if>
    </xsl:if>
    <xsl:if test="Color">
			<xsl:if test="floor(../../@flags div $ApplyFontColor) mod 2">
				<li>
					<xsl:value-of select="concat($valFontColor, ': ', Color)"/>
				</li>
			</xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Coordinates">
    <xsl:param name="inBounds"/>
    <ul>
      <li>
				<xsl:value-of select="concat($valTop,': ', format-number($inBounds/@top, '#.###'), ' px')"/>
      </li>
      <li>
				<xsl:value-of select="concat($valLeft,': ', format-number($inBounds/@left, '#.###'), ' px')"/>
      </li>
      <li>
				<xsl:value-of select="concat($valBottom,': ', format-number($inBounds/@bottom, '#.###'), ' px')"/>
      </li>
      <li>
				<xsl:value-of select="concat($valRight,': ', format-number($inBounds/@right, '#.###'), ' px')"/>
      </li>
    </ul>
  </xsl:template>
  
  <xsl:template name="ObjectAnchoring">
	<xsl:param name="inObject"/>
	<ul>
      <li>
				<xsl:value-of select="concat($valAnchoring, ': ')"/>
				<xsl:call-template name="AutoResizeAnchoring">
					<xsl:with-param name="obj" select="$inObject"/>
				</xsl:call-template>
      </li>
    </ul>
  </xsl:template>
  
  <xsl:template name="Bounds">
    <xsl:param name="inBounds"/>
    <xsl:value-of select="concat('(', format-number($inBounds/@top,integer),', ',format-number($inBounds/@left, integer),', ',format-number($inBounds/@bottom, integer),', ',format-number($inBounds/@right, integer),')')"/>
  </xsl:template>

  <xsl:template name="ChartTitle">
    <xsl:param name="inTitle"/>
      <li>
        <xsl:value-of select="concat($valChartValue, ': ')"/>
        <xsl:call-template name="GenerateCalc">
          <xsl:with-param name="inDisplayCalc" select="$inTitle/Text"/>
        </xsl:call-template>        
      </li>
  </xsl:template>

  <xsl:template name="ChartAxisInfo">
    <xsl:param name="inAxis"/>
    <xsl:param name="inSeriesList"/>
    <xsl:param name="inAxisName"/>
    <xsl:param name="hasSeriesTitle"/>
    <xsl:param name="hasMultipleSeries"/>
      <ul>
        <b>
          <xsl:value-of select="$inAxisName"/>
        </b>
        <li>
          <xsl:value-of select="concat($valChartTitle, ': ')"/>
          <xsl:call-template name="GenerateCalc">
            <xsl:with-param name="inDisplayCalc" select="$inAxis/Title/Text"/>
          </xsl:call-template>
        </li>
        <xsl:for-each select="$inSeriesList/Series">
        <li>
          <xsl:choose>
            <xsl:when test="$hasMultipleSeries = 'True'">
              <xsl:value-of select="concat($valChartSeries, ' ', position(), ': ')"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="concat($valChartSeries, ': ')"/>
            </xsl:otherwise>
          </xsl:choose>
          <ul>
            <li>
              <xsl:value-of select="concat($valChartValue, ': ')"/>
              <xsl:call-template name="GenerateCalc">
                <xsl:with-param name="inDisplayCalc" select="Value"/>
              </xsl:call-template>
            </li>
            <xsl:if test="$hasSeriesTitle = 'True'">
              <li>
                <xsl:value-of select="concat($valChartTitle, ': ')"/>
                <xsl:call-template name="GenerateCalc">
                  <xsl:with-param name="inDisplayCalc" select="Title/Text"/>
                </xsl:call-template>
              </li>
            </xsl:if>
          </ul>
        </li>
        </xsl:for-each>
      </ul>
  </xsl:template>
  
  <!--Generate a layout information -->
  <xsl:template name="Table-Layout">
    <xsl:if test="./Table">
      <tr class="regularcharttext" valign="top">
        <td>
          <xsl:call-template name="LayoutAnchor">
            <xsl:with-param name="inLayout" select="."/>
          </xsl:call-template>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="@includeInMenu = 'True'">
              <xsl:value-of select="$valYes"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$valNo"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="@quickFind = 'True'">
              <xsl:value-of select="$valYes"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$valNo"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <!--Ensure proper count of layout objects (i.e. ignore tab panels and group objects)-->
        <td>
          <xsl:variable name="regularFieldObjects" select="count(.//Object[@type='Field'])"/>
          <xsl:variable name="textObjectList" select="count(.//Object[@type='Text']/TextObj/FieldList)"/>
          <xsl:variable name="groupObjectList" select="count(.//Object[@type='GroupButton']/GroupButtonObj/Step)"/>
          <xsl:variable name="portalObjectList" select="count(.//Object[@type='Portal'])"/>
          <xsl:variable name="tabObjects" select="count(.//Object[@type='TabControl'])"/>
          <xsl:variable name="graphicObjectList" select="count(.//Object[contains($kGraphicObjects, @type) and
																											   descendant::*[contains($kReportedGraphicAttrs, name())]])"/>
          <xsl:variable name="chartObjectList" select="count(.//Object[@type ='ExternalObject']/ExternalObj[@typeID = 'CHRT'])"/>
          <xsl:variable name="WBVObjectList" select="count(.//Object[@type ='ExternalObject']/ExternalObj[@typeID = 'WEBV'])"/>
          <ul>
            <xsl:if test="$regularFieldObjects &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valRegularFields"/>
                  <xsl:with-param name="inDisplayText" select="concat($regularFieldObjects, ' ', $valRegularFields)"/>

                </xsl:call-template>
              </li>
            </xsl:if>
            <xsl:if test="$textObjectList &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valMergeFields"/>
                  <xsl:with-param name="inDisplayText" select="concat($textObjectList, ' ', $valMergeFields)"/>
                </xsl:call-template>
              </li>
            </xsl:if>
            <xsl:if test="$groupObjectList &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valButtons"/>
                  <xsl:with-param name="inDisplayText" select="concat($groupObjectList, ' ', $valButtons)"/>
                </xsl:call-template>
              </li>
            </xsl:if>
            <xsl:if test="$portalObjectList &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valPortals"/>
                  <xsl:with-param name="inDisplayText" select="concat($portalObjectList, ' ', $valPortals)"/>
                </xsl:call-template>
              </li>
            </xsl:if>
            <xsl:if test="$tabObjects &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valTabControls"/>
                  <xsl:with-param name="inDisplayText" select="concat($tabObjects, ' ', $valTabControls)"/>
                </xsl:call-template>
              </li>
            </xsl:if>
            <xsl:if test="$graphicObjectList &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valGraphicObjs"/>
                  <xsl:with-param name="inDisplayText" select="concat($graphicObjectList, ' ', $valGraphicObjs)"/>
                </xsl:call-template>
              </li>
            </xsl:if>
            <xsl:if test="$WBVObjectList &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valWebControls"/>
                  <xsl:with-param name="inDisplayText" select="concat($WBVObjectList, ' ', $valWebControls)"/>
                </xsl:call-template>
              </li>
            </xsl:if>
            <xsl:if test="$chartObjectList &gt; 0">
              <li>
                <xsl:call-template name="LayoutObjectSectionReference">
                  <xsl:with-param name="inLayout" select="."/>
                  <xsl:with-param name="inSection" select="$valChartObjects"/>
                  <xsl:with-param name="inDisplayText" select="concat($chartObjectList, ' ', $valChartObjects)"/>
                </xsl:call-template>
              </li>
            </xsl:if>
          </ul>
        </td>
        <td>
          <xsl:call-template name="TableAliasReference">
            <xsl:with-param name="inTableAlias" select="Table"/>
          </xsl:call-template>
        </td>

        <td>
          <xsl:call-template name="GetState">
            <xsl:with-param name="inValue" select="Options/@saveRecord"/>
          </xsl:call-template>
        </td>
        <td>
          <xsl:call-template name="GetState">
            <xsl:with-param name="inValue" select="Options/@showFieldFrames"/>
          </xsl:call-template>
        </td>
        <td>
          <xsl:variable name="currentLayout" select="."/>
          <xsl:variable name="usedScriptList" select="key('ScriptByLayoutIndex',$currentLayout/@id)"/>
          <xsl:if test="$usedScriptList">
            <ul>

              <xsl:for-each select="$usedScriptList">
                <li>
                  <xsl:call-template name="ScriptReference">
                    <xsl:with-param name="inScript" select="."/>
                  </xsl:call-template>
                </li>
              </xsl:for-each>

            </ul>
          </xsl:if>
        </td>
        <td>
          <xsl:call-template name="CustomMenuSetReference">
            <xsl:with-param name="inCustomMenuSet" select="CustomMenuSet"/>
          </xsl:call-template>

        </td>
        <td>
          <xsl:call-template name="ScriptTriggersContents">
            <xsl:with-param name="triggersParent" select="."/>
          </xsl:call-template>

        </td>
      </tr>
    </xsl:if>
  </xsl:template>		
  
  <xsl:template name="Tab-Justification">
    <xsl:param name="inJustificationFlag"/>
    <xsl:choose>			
      <xsl:when test="$inJustificationFlag = '2'">
				<xsl:value-of select="$valCenter"/>
      </xsl:when>
      <xsl:when test="$inJustificationFlag = '3'">
				<xsl:value-of select="$valRight"/>
      </xsl:when>
      <xsl:when test="$inJustificationFlag = '4'">
				<xsl:value-of select="$valFull"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$valLeft"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="GetObjectInlineAttrs">
    <xsl:param name="inObject"/>

    <xsl:if test="$inObject/ToolTip">
      <ul>
				<b><xsl:value-of select="concat($valTooltip, ':')"/></b>
				<li>
					<xsl:call-template name="GenerateCalc">
						<xsl:with-param name="inDisplayCalc" select="$inObject/ToolTip"/>
					</xsl:call-template>	
				</li>
      </ul>
    </xsl:if>
  </xsl:template>

  <xsl:template name="GetObjectFooter">
    <xsl:param name="obj"/>

    <xsl:call-template name="ConditionalFormattingDetails">
      <xsl:with-param name="obj" select="$obj/ancestor-or-self::Object"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="Table-Layout-Objects">
    <!--Document field objects-->
    <xsl:variable name="regularFieldObjects" select=".//Object[@type='Field']"/>
    <xsl:variable name="textObjectList" select=".//Object[@type='Text']"/>
    <xsl:variable name="groupObjectList" select=".//Object[@type='GroupButton']"/>
    
    <!--Report regular field objects here -->
    <xsl:if test="$regularFieldObjects">
      <p>
				<span class="partheading">
					<xsl:call-template name="LayoutObjectSectionAnchor">
						<xsl:with-param name="inLayout" select="."/>
						<xsl:with-param name="inSection" select="$valRegularFields"/>
						<xsl:with-param name="inDisplayText" select="$valRegularFields"/>
					</xsl:call-template>
				</span> 
      </p>
      
      <xsl:for-each select="$regularFieldObjects">
				<table width="100%" border="1">
					<tbody>
						<tr class="chartheaders" valign="top">
							<td colspan="6" class="privsetfirst">
								<xsl:value-of select="concat($valFieldName, ': ')"/>
								<xsl:call-template name="FieldReference-ShowTableAlias">
									<xsl:with-param name="inField" select="FieldObj/DDRInfo/Field"/>
								</xsl:call-template>	
							</td>
						</tr>
						
						<tr class="chartsubheads" valign="top">
							<td class="chartheaders" colspan="2"><xsl:value-of select="$valFieldProperties"/></td>
							<td class="chartheaders" width="14%" colspan="1"><xsl:value-of select="$valCoordinates"/></td>
							<td class="chartheaders" width="17%" colspan="1"><xsl:value-of select="$valFieldFormat"/></td>
							<td class="chartheaders" width="30%" colspan="1"><xsl:value-of select="$valFieldBehavior"/></td>
							<td class="chartheaders" width="10%" colspan="1"><xsl:value-of select="$valQuickFind"/></td>
						</tr>
						<tr class="regularcharttext" valign="top">
							<td colspan="2">
								<xsl:call-template name="LayoutObjectAnchor">
									<xsl:with-param name="inLayoutObject" select="."/>
									<xsl:with-param name="inDisplayText" select="''"/>
								</xsl:call-template>								
								<xsl:if test="@name">
									<ul>
										<b><xsl:value-of select="concat($valObjectName, ':')"/></b>
										<li>
											<xsl:value-of select="@name"/>
										</li>
									</ul>
								</xsl:if>

								<ul>
									<b>
										<xsl:value-of select="concat($valLayoutName,':')"/>
									</b>
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="ancestor::Layout"/>
										</xsl:call-template>
									</li>
                  						<xsl:if test="./FieldObj/@tableViewVisibility = 1">
                  						<p></p><b>
										<xsl:value-of select="concat($valTableView,':')"/>
									</b>
									<li>    
                      						<xsl:value-of select="$valTableViewNotVisible"/>
                    						</li>  
                    						</xsl:if>
                    						<xsl:if test="./FieldObj/@tableViewVisibility = 2">
                  						<p></p><b>
										<xsl:value-of select="concat($valTableView,':')"/>
									</b>
                    						<li>
                      						<xsl:value-of select="$valTableViewVisible"/>
                    						</li>
                    						</xsl:if>
								</ul>

								<xsl:call-template name="GetObjectInlineAttrs">
									<xsl:with-param name="inObject" select="."/>
								</xsl:call-template>

								<xsl:call-template name="ScriptTriggersContents">
									<xsl:with-param name="triggersParent" select="."/>
								</xsl:call-template>
							</td>
							<td colspan="1">
								<xsl:call-template name="Coordinates">
									<xsl:with-param name="inBounds" select="Bounds"/>
								</xsl:call-template>
								<xsl:call-template name="ObjectAnchoring">
									<xsl:with-param name="inObject" select="."/>
								</xsl:call-template>
							</td>
							<td colspan="1">
								<xsl:call-template name="FieldFormat">
									<xsl:with-param name="inObject" select="FieldObj"/>
								</xsl:call-template>
							</td>
							<td colspan="1">
								<xsl:call-template name="FieldBehavior">
									<xsl:with-param name="inObject" select="FieldObj"/>
								</xsl:call-template>
							</td>
              				<td colspan="1">
                				<xsl:call-template name="QuickFind">
                  					<xsl:with-param name="inObject" select="FieldObj"/>
                				</xsl:call-template>
              				</td>
						</tr>
					</tbody>
				</table>
				<xsl:call-template name="GetObjectFooter">
					<xsl:with-param name="obj" select="."/>
				</xsl:call-template>
				<br/>
      </xsl:for-each>
    </xsl:if>	
    
    <!--Document merge fields-->
    <xsl:variable name="mergeFields" select="$textObjectList/TextObj/FieldList"/>
    <xsl:if test="$mergeFields">
      <p>
				<span class="partheading">
					<xsl:call-template name="LayoutObjectSectionAnchor">
						<xsl:with-param name="inLayout" select="."/>
						<xsl:with-param name="inSection" select="$valMergeFields"/>
						<xsl:with-param name="inDisplayText" select="$valMergeFields"/>
					</xsl:call-template>
				</span> 
      </p>

      <xsl:for-each select="$mergeFields">
				<table width="100%" border="1">
					<tbody>
						<tr class="chartsubheads" valign="top">
							<td colspan="2"><xsl:value-of select="$valFieldProperties"/></td>
							<td colspan="2"><xsl:value-of select="$valCoordinates"/></td>
							<td colspan="2" width="27%"><xsl:value-of select="$valFields"/></td>
              <td colspan="2" width="10%"><xsl:value-of select="$valQuickFind"/></td>
            </tr>


						<tr class="regularcharttext" valign="top">
							<td colspan="2">
								<xsl:variable name="theParentObject" select="parent::TextObj/parent::Object"/>
								<xsl:call-template name="LayoutObjectAnchor">
									<xsl:with-param name="inLayoutObject" select="$theParentObject"/>
									<xsl:with-param name="inDisplayText" select="''"/>
								</xsl:call-template>
								<xsl:if test="$theParentObject/@name">
									<ul>
										<b><xsl:value-of select="concat($valObjectName, ':')"/></b>
										<li>
											<xsl:value-of select="$theParentObject/@name"/>
										</li>
									</ul>
								</xsl:if>

								<ul>
									<b>
										<xsl:value-of select="concat($valText,':')"/>
									</b>
									<li>
										<em>
											<xsl:value-of select="parent::TextObj/CharacterStyleVector/Style/Data"/>
										</em>
									</li>
								</ul>

								<ul>
									<b>
										<xsl:value-of select="concat($valLayoutName,':')"/>
									</b>
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="ancestor::Layout"/>
										</xsl:call-template>
									</li>
								</ul>

								<xsl:call-template name="GetObjectInlineAttrs">
									<xsl:with-param name="inObject" select="parent::TextObj/parent::Object"/>
								</xsl:call-template>
								
							</td>
							<td colspan="2">
								<xsl:call-template name="Coordinates">
									<xsl:with-param name="inBounds" select="parent::TextObj/parent::Object/Bounds"/>
								</xsl:call-template>
								<xsl:call-template name="ObjectAnchoring">
									<xsl:with-param name="inObject" select="parent::TextObj/parent::Object"/>
								</xsl:call-template>
							</td>
							<td colspan="2">
								<ul>
									<xsl:for-each select="Field">
										<li>
											<xsl:call-template name="FieldReference-ShowTableAlias">
												<xsl:with-param name="inField" select="."/>
											</xsl:call-template>	
										</li>
									</xsl:for-each>
								</ul>
							</td>
              <td colspan="2">
                  <xsl:call-template name="QuickFind">
                    <xsl:with-param name="inObject" select="."/>
                  </xsl:call-template>
              </td>
            </tr>
					</tbody>
				</table>
				<xsl:call-template name="GetObjectFooter">
					<xsl:with-param name="obj" select="."/>
				</xsl:call-template>
				<br/>
      </xsl:for-each>
    </xsl:if>
    
    <!--Document Buttons-->
    <xsl:variable name="groupButtonList" select="$groupObjectList/GroupButtonObj/Step"/>
    <xsl:if test="$groupButtonList">
      
      <p>
				<span class="partheading">
					<xsl:call-template name="LayoutObjectSectionAnchor">
						<xsl:with-param name="inLayout" select="."/>
						<xsl:with-param name="inSection" select="$valButtons"/>
						<xsl:with-param name="inDisplayText" select="$valButtons"/>
					</xsl:call-template>
				</span> 
      </p>
      
      <xsl:for-each select="$groupButtonList">
				<table width="100%" border="1">
					<tbody>
						<tr class="chartsubheads" valign="top">
							<td colspan="2"><xsl:value-of select="$valButtonProperties"/></td>
							<td colspan="1" width="14%"><xsl:value-of select="$valCoordinates"/></td>
							<td colspan="3" width="43%"><xsl:value-of select="$valButtonScriptStep"/></td>
						</tr>
						
						<tr class="regularcharttext" valign="top">
							<td colspan="2">
								<xsl:variable name="theParentObject" select="parent::GroupButtonObj/parent::Object"/>
								<xsl:call-template name="LayoutObjectAnchor">
									<xsl:with-param name="inLayoutObject" select="$theParentObject"/>
									<xsl:with-param name="inDisplayText" select="''"/>
								</xsl:call-template>
								<xsl:if test="$theParentObject/@name">
									<ul>
										<b><xsl:value-of select="concat($valObjectName, ':')"/></b>
										<li>
											<xsl:value-of select="$theParentObject/@name"/>
										</li>
									</ul>
								</xsl:if>
								<ul>
									<b>
										<xsl:value-of select="concat($valType, ':')"/>
									</b>
									<li>
										<xsl:call-template name="ButtonName">
											<xsl:with-param name="inButton" select="parent::GroupButtonObj/parent::Object"/>
										</xsl:call-template>
									</li>
								</ul>

								<ul>
									<b>
										<xsl:value-of select="concat($valLayoutName,':')"/>
									</b>
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="ancestor::Layout"/>
										</xsl:call-template>
									</li>
								</ul>
								
								<xsl:call-template name="GetObjectInlineAttrs">
									<xsl:with-param name="inObject" select="parent::GroupButtonObj/Object[last()]"/>
								</xsl:call-template>
								
								<xsl:variable name="handCursor">
									<xsl:call-template name="Bit">
										<xsl:with-param name="inVal" select="parent::GroupButtonObj/parent::Object/@flags"/>
										<xsl:with-param name="inBit" select="65536"/>								
									</xsl:call-template>
								</xsl:variable>
								<xsl:variable name="buttonStyle">
									<xsl:call-template name="ButtonStyle">
										<xsl:with-param name="inButton" select="parent::GroupButtonObj/parent::Object"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:if test="$handCursor = 'true' or string-length($buttonStyle) !='0'">
									<ul>
										<b>
											<xsl:value-of select="concat($valAdditionalProperties,':')"/>
										</b>
										<xsl:if test="$handCursor = 'true'">
											<li>
												<xsl:value-of select="$valHandCursor"/>
											</li>
										</xsl:if>
										<xsl:if test="string-length($buttonStyle) !='0'">
											<li>
												<xsl:value-of select="$buttonStyle"/>
											</li>
										</xsl:if>
									</ul>
								</xsl:if>

								<xsl:call-template name="ScriptTriggersContents">
									<xsl:with-param name="triggersParent" select="$theParentObject"/>
								</xsl:call-template>
							</td>
							<td colspan="1">
								<xsl:call-template name="Coordinates">
									<xsl:with-param name="inBounds" select="parent::GroupButtonObj/parent::Object/Bounds"/>
								</xsl:call-template>
								<xsl:call-template name="ObjectAnchoring">
									<xsl:with-param name="inObject" select="parent::GroupButtonObj/parent::Object"/>
								</xsl:call-template>			
							</td>
							<td colspan="3">
								<xsl:value-of select="StepText"/>
								<xsl:variable name="buttonScriptRefList" select="Script"/>
								<xsl:variable name="buttonFieldRefList" select=".//Field"/>
								<xsl:variable name="layoutRefList" select="Layout"/>
								<xsl:if test="$buttonScriptRefList">
									<p><b><xsl:value-of select="concat($valScripts,':')"/></b></p>
									<ul>
										<xsl:for-each select="$buttonScriptRefList">
											<li>
												<xsl:call-template name="ScriptReference">
													<xsl:with-param name="inScript" select="."/>
												</xsl:call-template>	
											</li>
										</xsl:for-each>
									</ul>
								</xsl:if>
								<xsl:if test="$buttonFieldRefList">
									<p><b><xsl:value-of select="concat($valFields,':')"/></b></p>
									<ul>
										<xsl:for-each select="$buttonFieldRefList">
											<li>
												<xsl:call-template name="FieldReference-ShowTableAlias">
													<xsl:with-param name="inField" select="."/>
												</xsl:call-template>		
											</li>
										</xsl:for-each>
									</ul>
								</xsl:if>
								<xsl:if test="$layoutRefList/@id">
									<p><b><xsl:value-of select="concat($valLayouts,':')"/></b></p>
									<ul>
                      <li>
                        <xsl:call-template name="LayoutReference">
                          <xsl:with-param name="inLayout" select="$layoutRefList"/>
                        </xsl:call-template>
                      </li>
									</ul>
								</xsl:if>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:call-template name="GetObjectFooter">
					<xsl:with-param name="obj" select="."/>
				</xsl:call-template>
				<br/>
      </xsl:for-each>
    </xsl:if>
    
    <!--Document the portal objects-->
    <xsl:variable name="portalObjectList" select=".//Object[@type='Portal']"/>
    <xsl:if test="$portalObjectList">
      
      <p>
				<span class="partheading">
					<xsl:call-template name="LayoutObjectSectionAnchor">
						<xsl:with-param name="inLayout" select="."/>
						<xsl:with-param name="inSection" select="$valPortals"/>
						<xsl:with-param name="inDisplayText" select="$valPortals"/>
					</xsl:call-template>
				</span> 
      </p>
      
      <xsl:for-each select="$portalObjectList">
				<table border="1" width="100%">
					<tbody>
						<tr class="chartsubheads" valign="top">
							<td colspan="2"><xsl:value-of select="$valPortalProperties"/></td>
							<td colspan="1" width="15%"><xsl:value-of select="$valCoordinates"/></td>
							<td colspan="1" width="10%" ><xsl:value-of select="$valFields"/></td>
							<td colspan="2"><xsl:value-of select="$valOptions"/></td>
						</tr>

						<tr class="regularcharttext" valign="top">
							<td colspan="2">
								<xsl:call-template name="LayoutObjectAnchor">
									<xsl:with-param name="inLayoutObject" select="."/>
									<xsl:with-param name="inDisplayText" select="''"/>
								</xsl:call-template>
								
								<xsl:if test="@name">
									<ul>
										<b><xsl:value-of select="concat($valObjectName, ':')"/></b>
										<li>
											<xsl:value-of select="@name"/>
										</li>
									</ul>
								</xsl:if>
								
								<ul>
									<b><xsl:value-of select="concat($valTable,':')"/></b>
									<li>
										<xsl:call-template name="TableAliasReferenceGivenName">
											<xsl:with-param name="inTableAliasName" select="PortalObj/TableAliasKey"/>
										</xsl:call-template>
									</li>
								</ul>

								<ul>
									<b>
										<xsl:value-of select="concat($valLayoutName,':')"/>
									</b>
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="ancestor::Layout"/>
										</xsl:call-template>
									</li>
								</ul>

								<!--Portal object details-->
								<xsl:call-template name="GetObjectInlineAttrs">
									<xsl:with-param name="inObject" select="."/>
								</xsl:call-template>

								<xsl:call-template name="ScriptTriggersContents">
									<xsl:with-param name="triggersParent" select="."/>
								</xsl:call-template>

							</td>
							
							<!-- Coordinates -->
							<td colspan="1">
								<xsl:call-template name="Coordinates">
									<xsl:with-param name="inBounds" select="Bounds"/>
								</xsl:call-template>
								<xsl:call-template name="ObjectAnchoring">
									<xsl:with-param name="inObject" select="."/>
								</xsl:call-template>
							</td>
							
							<td colspan="1">
								<xsl:if test="PortalObj/FieldList">
									<ul>
										<xsl:for-each select="PortalObj/FieldList/Field">
											<li>	
												<xsl:call-template name="FieldReference-ShowTableAlias">
													<xsl:with-param name="inField" select="."/>
												</xsl:call-template>
											</li>
										</xsl:for-each>
									</ul>
								</xsl:if>
							</td>
							<td colspan="2">
								<ul>
									<xsl:choose>
										<xsl:when test="PortalObj/SortList/@value='True'">
											<li>
												<xsl:value-of select="concat($valSortRecords,': ',$valOn)"/>
												<xsl:for-each select="PortalObj/SortList/Sort">
													<xsl:call-template name="Sort">
														<xsl:with-param name="inSort" select="."/>
													</xsl:call-template>
												</xsl:for-each>	
											</li>
											<br/>
										</xsl:when>
									  <xsl:otherwise>
											<li>
												<xsl:value-of select="concat($valSortRecords,': ', $valOff)"/>
											</li>
									  </xsl:otherwise>
									</xsl:choose>

									<xsl:choose>
										<xsl:when test="PortalObj/FilterCalc/@enable='True'">
											<li>
												<xsl:value-of select="concat($valFilterCalc, ': ')"/>
												<br />
												<xsl:call-template name="GenerateCalc">
													<xsl:with-param name="inDisplayCalc" select="PortalObj/FilterCalc"/>
												</xsl:call-template>
											</li>
											<br/>
										</xsl:when>
										<xsl:otherwise>
											<li>
												<xsl:value-of select="concat($valFilterCalc,': ', $valNone)"/>
											</li>
										</xsl:otherwise>
									</xsl:choose>

									<li>
										<xsl:value-of select="concat($valInitRow,': ',PortalObj/@initialRow)"/>
									</li>
									<li>
										<xsl:value-of select="concat($valNumOfRows,': ', PortalObj/@numOfRows)"/>
									</li>
									
									<xsl:variable name="showVBarResult">
										<xsl:call-template name="Bit">
											<xsl:with-param name="inVal" select="PortalObj/@portalFlags"/>
											<xsl:with-param name="inBit" select="1"/>
										</xsl:call-template>			
									</xsl:variable>
									<xsl:if test="$showVBarResult = 'true'">
										<li>
											<xsl:value-of select="$valShowVBar"/>
										</li>
									</xsl:if>
									
									<xsl:variable name="allowDeleteResult">
										<xsl:call-template name="Bit">
											<xsl:with-param name="inVal" select="PortalObj/@portalFlags"/>
											<xsl:with-param name="inBit" select="4"/>
										</xsl:call-template>			
									</xsl:variable>
									<xsl:if test="$allowDeleteResult = 'true'">
										<li>
											<xsl:value-of select="$valAllowDeletePortalRecords"/>
										</li>
									</xsl:if>
									
									<xsl:variable name="resetScrollBarAfterExit">
										<xsl:call-template name="Bit">
											<xsl:with-param name="inVal" select="PortalObj/@portalFlags"/>
											<xsl:with-param name="inBit" select="16"/>
										</xsl:call-template>	
									</xsl:variable>
									<xsl:if test="$resetScrollBarAfterExit = 'false'">
										<li>
											<xsl:value-of select="$valResetScrollBarAfterExit"/>
										</li>
									</xsl:if>
								</ul>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:call-template name="GetObjectFooter">
					<xsl:with-param name="obj" select="."/>
				</xsl:call-template>
				<br/>
      </xsl:for-each>
    </xsl:if>
    
    <!--Document tab objects-->
    <xsl:variable name="tabObjects" select=".//Object[@type='TabControl']"/>
    <xsl:if test="$tabObjects">
      <p>
				<span class="partheading">
					<xsl:call-template name="LayoutObjectSectionAnchor">
						<xsl:with-param name="inLayout" select="."/>
						<xsl:with-param name="inSection" select="$valTabControls"/>
						<xsl:with-param name="inDisplayText" select="$valTabControls"/>
					</xsl:call-template>
				</span> 
      </p>
      
      <!--Now go through each tab object and report them-->
      <xsl:for-each select="$tabObjects">		
				<table border="1" width="100%">
					<tbody>

						<!--Output the row title for the tab objects-->
						<tr class="chartsubheads" valign="top">
							<td colspan="3"><xsl:value-of select="$valTabProperties"/></td>
							<td colspan="4"><xsl:value-of select="$valCoordinates"/></td>
						</tr>
						
						<!--Start off with the row with all the property titles-->
						<tr class="regularcharttext" valign="top">
							<!--Now report the Coordinates of the tab control object-->
							<td colspan="3">
								<xsl:call-template name="LayoutObjectAnchor">
									<xsl:with-param name="inLayoutObject" select="."/>
									<xsl:with-param name="inDisplayText" select="''"/>
								</xsl:call-template>

								<ul>
									<b>
										<xsl:value-of select="concat($valLayoutName,':')"/>
									</b>
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="ancestor::Layout"/>
										</xsl:call-template>
									</li>
								</ul>

								<ul>
									<b><xsl:value-of select="concat($valJustification,': ')"/></b>
									<li>
										<xsl:call-template name="Tab-Justification">
											<xsl:with-param name="inJustificationFlag" select="preceding-sibling::ObjectStyle[1]/ParagraphStyle/Justification"/>
										</xsl:call-template>
									</li>
								</ul>
								<ul>
									<b><xsl:value-of select="concat($valAppearance,': ')"/></b>
									<li>									
										<xsl:choose>
											<xsl:when test="TabControlObj/@tabStyle = '0'">
												<xsl:value-of select="$valRounded"/>
											</xsl:when>
											<xsl:when test="TabControlObj/@tabStyle ='1'">
												<xsl:value-of select="$valSquare"/>
											</xsl:when>									
										</xsl:choose>
									</li>
								</ul>

								<!-- Tab width -->
								<xsl:variable name="tabFlagSet" select="TabControlObj/@tabFlagSet"/>
								<xsl:variable name="tabWidthFlag" select="floor($tabFlagSet div 16)"/>
								<xsl:variable name="tabWidthUnits" select="floor(($tabFlagSet - $tabWidthFlag * 16) div 4)"/>
								<xsl:variable name="tabWidthPixels" select="TabControlObj/@tabWidthModifier"/>


								<xsl:variable name="formattedTabWidth">
									<xsl:choose>
										<xsl:when test="'0' = $tabWidthUnits">
											<xsl:value-of select="concat(format-number($tabWidthPixels div 72, '#.###'), ' in')"/>
										</xsl:when>
										
										<xsl:when test="'1' = $tabWidthUnits">
											<xsl:value-of select="concat(format-number(($tabWidthPixels div 72) * 2.54, '#.###'), ' cm')"/>
										</xsl:when>
										
										<xsl:when test="'2' = $tabWidthUnits">
											<xsl:value-of select="concat($tabWidthPixels, ' px')"/>
										</xsl:when>
									</xsl:choose>
								</xsl:variable>

								<ul>
									<b><xsl:value-of select="concat($valTabWidth, ': ')"/></b>
									<li>
										<xsl:choose>
											<xsl:when test="'0' = $tabWidthFlag">
												<xsl:value-of select="$valLabelWidth"/>
											</xsl:when>
											<xsl:when test="'1' = $tabWidthFlag">
												<xsl:value-of select="concat($valLabelWidthPlusMarginOf, ' ', $formattedTabWidth)"/>
											</xsl:when>
											<xsl:when test="'2' = $tabWidthFlag">
												<xsl:value-of select="$valLabelWidthWidest"/>
											</xsl:when>
											<xsl:when test="'3' = $tabWidthFlag">
												<xsl:value-of select="concat($valLabelWidthMinimumOf, ' ', $formattedTabWidth)"/>
											</xsl:when>
											<xsl:when test="'4' = $tabWidthFlag">
												<xsl:value-of select="concat($valLabelWidthFixedOf, ' ', $formattedTabWidth)"/>
											</xsl:when>
										</xsl:choose>
									</li>
								</ul>

								<!-- Default front tab -->
								<ul>
									<b><xsl:value-of select="concat($valDefaultFrontTab, ': ')"/></b>
									<li>
										<xsl:value-of select="concat($valPanel, ' ', TabControlObj/@defaultVisPanelIndex)"/>
									</li>
								</ul>

								<xsl:call-template name="ScriptTriggersContents">
									<xsl:with-param name="triggersParent" select="."/>
								</xsl:call-template>

							</td>
							<td colspan="4">
								<xsl:call-template name="Coordinates">
									<xsl:with-param name="inBounds" select="Bounds"/>
								</xsl:call-template>
								<xsl:call-template name="ObjectAnchoring">
									<xsl:with-param name="inObject" select="."/>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td colspan="7" class="chartsubheads"><xsl:value-of select="$valPanels"/></td>
						</tr>

						<!-- Tab panel headings -->
						<tr>  
							<td width="15%" class="chartsubheads"><xsl:value-of select="$valPanelProperties"/></td>
							<td width="23%" class="chartsubheads"><xsl:value-of select="$valTabs"/></td>
							<td class="chartsubheads"><xsl:value-of select="$valFields"/></td>
							<td class="chartsubheads"><xsl:value-of select="$valButtons"/></td>
							<td width="25%" class="chartsubheads"><xsl:value-of select="$valPortals"/></td>
							<td width="12%" class="chartsubheads"><xsl:value-of select="$valWebControls"/></td>
              <td width="12%" class="chartsubheads"><xsl:value-of select="$valChartObjects"/></td>
            </tr>
						
						<!--Now iterate through the panel itself.-->
						<xsl:variable name="currentTabObject" select="."/>
						<xsl:variable name="tabPanelList" select="TabControlObj/TabPanelObj"/>
						<xsl:for-each select="$tabPanelList">
							<tr class="regularcharttext" valign="top">
								<!--First thing, report the Tab Panel information-->
								<td>
									<ul>
										<b><xsl:value-of select="concat($valPanel, ' ', position() - 1, ': ')"/></b>
										<li>
											<xsl:choose>
												<xsl:when test="generate-id($tabPanelList[$currentTabObject/TabControlObj/@visPanelIndex + 1]) = generate-id(.)">
													<em>
														<xsl:value-of select="TextObj/CharacterStyleVector/Style/Data"/>
													</em>
												</xsl:when>	
												<xsl:otherwise>
													<xsl:value-of select="TextObj/CharacterStyleVector/Style/Data"/>
												</xsl:otherwise>
											</xsl:choose>
										</li>
									</ul>	
									<xsl:if test="@name">
										<ul>
											<b><xsl:value-of select="concat($valObjectName,':')"/></b>
											<li><xsl:value-of select="@name"/></li>
										</ul>
									</xsl:if>

									<xsl:call-template name="GetObjectInlineAttrs">
										<xsl:with-param name="inObject" select="."/>
									</xsl:call-template>
									
								</td>
								
								<!--Now report the tab objects inside the panel-->
								<td>
									<!--Get all the tab objects inside that tab panel"-->
									<xsl:variable name="tabObjectsInPanel" select="Object[@type = 'TabControl']"/>
									<ul>
										<!--Iterate through each tab object inside that panel and hyperlink them-->
										<xsl:for-each select="$tabObjectsInPanel">
											<li>
												<xsl:call-template name="LayoutObjectReference">
													<xsl:with-param name="inLayoutObject" select="."/>
													<xsl:with-param name="inDisplayText" select="$valTabObject"/>
												</xsl:call-template>
												<xsl:value-of select="concat(' ',$valAt,' ')"/>
												<xsl:call-template name="Bounds">
													<xsl:with-param name="inBounds" select="Bounds"/>
												</xsl:call-template>
											</li>
										</xsl:for-each>	
									</ul>
								</td>
								
								<!--Now report the field objects inside the tab panel-->
								<td>
									<xsl:variable name="regularFieldList" select="Object[@type ='Field']"/>
									<xsl:if test="$regularFieldList">
										<xsl:value-of select="$valFieldObjects"/>
										<ul>									
											<xsl:for-each select="$regularFieldList">
												<li>	
													<!--<xsl:variable name="fieldObjName">
															<xsl:choose>
																<xsl:when test="string-length(FieldObj/DDRInfo/Field/@name) = '0'">
																	<xsl:value-of select="valMissingField"/>
																</xsl:when>
																<xsl:when test="string-length(FieldObj/DDRInfo/Field/@table) = '0'">
																	<xsl:value-of select="valMissingTable"/>
																</xsl:when>
																<xsl:otherwise>
																	<xsl:value-of select="concat(FieldObj/DDRInfo/Field/@table, '::',FieldObj/DDRInfo/Field/@name)"/>
																</xsl:otherwise>
															</xsl:choose>												
															</xsl:variable>
															<xsl:call-template name="LayoutObjectReference">
																<xsl:with-param name="inLayoutObject" select="."/>
																<xsl:with-param name="inDisplayText" select="$fieldObjName"/>
															</xsl:call-template>
															<xsl:value-of select="concat(' ',$valAt,' ')"/>
															<xsl:call-template name="Bounds">
																<xsl:with-param name="inBounds" select="Bounds"/>
															</xsl:call-template>-->
													<xsl:call-template name="FieldReference-ShowTableAlias">
														<xsl:with-param name="inField" select="FieldObj/DDRInfo/Field"/>
													</xsl:call-template>
													<xsl:value-of select="concat(' ',$valAt,' ')"/>
													<xsl:call-template name="Bounds">
														<xsl:with-param name="inBounds" select="Bounds"/>
													</xsl:call-template>
												</li>
											</xsl:for-each>
										</ul>
									</xsl:if>
									<xsl:variable name="mergeFieldList" select="Object[@type='Text']/TextObj/FieldList"/>
									<xsl:if test="$mergeFieldList">
										<xsl:value-of select="$valMergeFieldObjects"/>
										<ul>
											<xsl:for-each select="$mergeFieldList">
												
												<li>	
													<xsl:variable name="parent" select="parent::TextObj/parent::Object"/>
													<xsl:call-template name="LayoutObjectReference">
														<xsl:with-param name="inLayoutObject" select="$parent"/>
														<xsl:with-param name="inDisplayText" select="$parent/TextObj/CharacterStyleVector/Style/Data"/>
													</xsl:call-template>
													<xsl:value-of select="concat(' ',$valAt,' ')"/>
													<xsl:call-template name="Bounds">
														<xsl:with-param name="inBounds" select="$parent/Bounds"/>
													</xsl:call-template>
												</li>
											</xsl:for-each>
										</ul>
									</xsl:if>
								</td>
								
								<!--Now report all the buttons-->
								<td>
									<xsl:variable name="buttonList" select="Object[@type = 'GroupButton']"/>
									<xsl:if test="$buttonList">
										<xsl:for-each select="$buttonList">
											<xsl:if test="GroupButtonObj/Step">
												<li>					
													<xsl:variable name="displayButtonText">
														<xsl:call-template name="ButtonInfo">
															<xsl:with-param name="inButton" select="."/>
														</xsl:call-template>
													</xsl:variable>		
													<xsl:call-template name="LayoutObjectReference">
														<xsl:with-param name="inLayoutObject" select="."/>
														<xsl:with-param name="inDisplayText" select="$displayButtonText"/>
													</xsl:call-template>
													<xsl:value-of select="concat(' ',$valAt,' ')"/>
													<xsl:call-template name="Bounds">
														<xsl:with-param name="inBounds" select="Bounds"/>
													</xsl:call-template>
													
												</li>
											</xsl:if>
										</xsl:for-each>
									</xsl:if>
								</td>
								
								<!--Now report all the portals-->
								<td>
									<xsl:variable name="portalList" select="Object[@type='Portal']"></xsl:variable>
									<xsl:if test="$portalList">
										<ul>
											<xsl:for-each select="$portalList">
												<li>
													<xsl:call-template name="LayoutObjectReference">
														<xsl:with-param name="inLayoutObject" select="."/>
														<xsl:with-param name="inDisplayText" select="$valPortalObject"/>
													</xsl:call-template>	
													<xsl:value-of select="concat(' ',$valAt,' ')"/>
													<xsl:call-template name="Bounds">
														<xsl:with-param name="inBounds" select="Bounds"/>
													</xsl:call-template>											
												</li>
											</xsl:for-each>
										</ul>
									</xsl:if>
								</td>
								
								<!--Now report all the Web control references-->
								<td>
									<xsl:variable name="webViewerList" select="Object[@type ='ExternalObject']/ExternalObj[@typeID = 'WEBV']"/>
									<xsl:if test="$webViewerList">
										<!-- Report how many web viewers -->
										<xsl:value-of select="concat(count($webViewerList), ' ', $valWebControls)"/>
										<!-- Report individual coordinates (with links) -->
										<ul>
											<xsl:for-each select="$webViewerList">
												<li>
													<xsl:call-template name="LayoutObjectReference">
														<xsl:with-param name="inLayoutObject" select=".."/>
														<xsl:with-param name="inDisplayText" select="concat($valCoordinates, ' (', round(../Bounds/@top), ', ', round(../Bounds/@left), ', ', round(../Bounds/@bottom), ', ', round(../Bounds/@right), ')')"/>
													</xsl:call-template>	
												</li>
											</xsl:for-each>
										</ul>
									</xsl:if>
								</td>

                <!--Now report all the Chart references-->
                <td>
                  <xsl:variable name="chartList" select="Object[@type ='ExternalObject']/ExternalObj[@typeID = 'CHRT']"/>
                  <xsl:if test="$chartList">
                    <!-- Report how many web viewers -->
                    <xsl:value-of select="concat(count($chartList), ' ', $valChartObjects)"/>
                    <!-- Report individual coordinates (with links) -->
                    <ul>
                      <xsl:for-each select="$chartList">
                        <li>
                          <xsl:call-template name="LayoutObjectReference">
                            <xsl:with-param name="inLayoutObject" select=".."/>
                            <xsl:with-param name="inDisplayText" select="concat($valCoordinates, ' (', round(../Bounds/@top), ', ', round(../Bounds/@left), ', ', round(../Bounds/@bottom), ', ', round(../Bounds/@right), ')')"/>
                          </xsl:call-template>
                        </li>
                      </xsl:for-each>
                    </ul>
                  </xsl:if>
                </td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
				<xsl:call-template name="GetObjectFooter">
					<xsl:with-param name="obj" select="."/>
				</xsl:call-template>
				<br/>
      </xsl:for-each>
    </xsl:if>

    <!--Document Graphic objects-->
    <xsl:variable name="graphicObjectList" select=".//Object[contains($kGraphicObjects, @type) and
																									 descendant::*[contains($kReportedGraphicAttrs, name())]]"/>
    <xsl:if test="$graphicObjectList">
      <p>
				<span class="partheading">
					<xsl:call-template name="LayoutObjectSectionAnchor">
						<xsl:with-param name="inLayout" select="."/>
						<xsl:with-param name="inSection" select="$valGraphicObjs"/>
						<xsl:with-param name="inDisplayText" select="$valGraphicObjs"/>
					</xsl:call-template>
				</span> 
      </p>
      <xsl:for-each select="$graphicObjectList">
				<table border="1" width="100%">
					<tbody>
						<!--
								<tr class="chartsubheads" valign="top">
									<td colspan="6">
										<xsl:value-of select="$valGraphicObjs"/>
										
									</td>
								</tr>
								-->
						<tr class="chartsubheads" valign="top">
							<td colspan="3"><xsl:value-of select="$valGraphicObjectProperties"/></td>
							<td colspan="3"><xsl:value-of select="$valCoordinates"/></td>
						</tr>

						<tr class="regularcharttext" valign="top">
							<td colspan="3">
								
								<xsl:if test="./@name">
									<ul>
										<b><xsl:value-of select="concat($valObjectName, ':')"/></b>
										<li>
											<xsl:value-of select="./@name"/>
										</li>
									</ul>
								</xsl:if>

								<ul>
									<b><xsl:value-of select="concat($valType, ':')"/></b>
									<li>
										<xsl:choose>
											<xsl:when test="./@type = 'Text'">
												<xsl:value-of select="concat($valText,': ')"/>
												<xsl:value-of select="./TextObj/CharacterStyleVector/Style/Data"/>								
											</xsl:when>
											<xsl:when test="./@type = 'Graphic'">
												<xsl:value-of select="$valGraphic"/>
											</xsl:when>
											<xsl:when test="./@type = 'Rect'">
												<xsl:value-of select="$valRect"/>
											</xsl:when>
											<xsl:when test="./@type = 'RRect'">
												<xsl:value-of select="$valRRect"/>
											</xsl:when>
											<xsl:when test="./@type = 'Line'">
												<xsl:value-of select="$valLine"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$valOval"/>
											</xsl:otherwise>
										</xsl:choose>
									</li>
								</ul>

								<ul>
									<b>
										<xsl:value-of select="concat($valLayoutName,':')"/>
									</b>
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="ancestor::Layout"/>
										</xsl:call-template>
									</li>
								</ul>

								<xsl:call-template name="GetObjectInlineAttrs">
									<xsl:with-param name="inObject" select="."/>
								</xsl:call-template>
								
							</td>
							<td colspan="3">
								<xsl:call-template name="Coordinates">
									<xsl:with-param name="inBounds" select="./Bounds"/>
								</xsl:call-template>
								<xsl:call-template name="ObjectAnchoring">
									<xsl:with-param name="inObject" select="."/>
								</xsl:call-template>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:call-template name="GetObjectFooter">
					<xsl:with-param name="obj" select="."/>
				</xsl:call-template>
				<br/>
      </xsl:for-each>
    </xsl:if>	
    
    <!-- Document web view control -->
    <xsl:variable name="externalObjectList" select=".//Object[@type ='ExternalObject']/ExternalObj[@typeID = 'WEBV']"/>
    <xsl:if test="$externalObjectList">
      <p>
				<span class="partheading">
					<xsl:call-template name="LayoutObjectSectionAnchor">
						<xsl:with-param name="inLayout" select="."/>
						<xsl:with-param name="inSection" select="$valWebControls"/>
						<xsl:with-param name="inDisplayText" select="$valWebControls"/>
					</xsl:call-template>
				</span> 
      </p>
      <xsl:for-each select="$externalObjectList">
				<table border="1" width="100%">
					<tbody>
						<tr class="chartsubheads" valign="top">
							<td colspan="2" width="40%"><xsl:value-of select="$valWebControlProperties"/></td>
							<td width="20%" colspan="2"><xsl:value-of select="$valCoordinates"/></td>
							<td width="40%" colspan="2"><xsl:value-of select="$valWebAddress"/></td>
						</tr>

						<tr class="regularcharttext" valign="top">
							<xsl:variable name="theParentObject" select="parent::Object"/>	
							<td colspan="2">
								<xsl:call-template name="LayoutObjectAnchor">
									<xsl:with-param name="inLayoutObject" select="$theParentObject"/>
									<xsl:with-param name="inDisplayText" select="''"/>
								</xsl:call-template>
								
								<xsl:if test="$theParentObject/@name">
									<ul>
										<b><xsl:value-of select="concat($valObjectName, ':')"/></b>
										<li>
											<xsl:value-of select="$theParentObject/@name"/>
										</li>
									</ul>
								</xsl:if>

								<ul>
									<b>
										<xsl:value-of select="concat($valLayoutName,':')"/>
									</b>
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="ancestor::Layout"/>
										</xsl:call-template>
									</li>
								</ul>
								
								<xsl:call-template name="GetObjectInlineAttrs">
									<xsl:with-param name="inObject" select="$theParentObject"/>
								</xsl:call-template>
								
								<xsl:variable name="bitFindWBV">
									<xsl:call-template name="Bit">
										<xsl:with-param name="inVal" select="@externalFlagSet"/>
										<xsl:with-param name="inBit" select="2"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:variable name="bitAllowInteractWBV">
									<xsl:call-template name="Bit">
										<xsl:with-param name="inVal" select="@externalFlagSet"/>
										<xsl:with-param name="inBit" select="1"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:variable name="bitDisplayProgressBar">
									<xsl:call-template name="Bit">
										<xsl:with-param name="inVal" select="@externalFlagSet"/>
										<xsl:with-param name="inBit" select="4"/>
									</xsl:call-template>
								</xsl:variable>
								<xsl:variable name="bitDisplayStatusMessages">
									<xsl:call-template name="Bit">
										<xsl:with-param name="inVal" select="@externalFlagSet"/>
										<xsl:with-param name="inBit" select="8"/>
									</xsl:call-template>
								</xsl:variable>

								<xsl:if test="($bitFindWBV = 'true') or ($bitAllowInteractWBV = 'true') or ($bitDisplayProgressBar = 'true') or ($bitDisplayStatusMessages = 'true')">
									<ul>
										<b><xsl:value-of select="concat($valAdditionalProperties, ':')"/></b>
										<xsl:if test="$bitAllowInteractWBV = 'true'">
											<li>
												<xsl:value-of select="$valAllowInteractWebViewer"/>
											</li>
										</xsl:if>
										<xsl:if test="$bitFindWBV = 'true'">
											<li>
												<xsl:value-of select="$valDisplayContentFindMode"/>
											</li>
										</xsl:if>
										<xsl:if test="'true' = $bitDisplayProgressBar">
											<li>
												<xsl:value-of select="$valDisplayProgressBar"/>
											</li>
										</xsl:if>
										<xsl:if test="'true' = $bitDisplayStatusMessages">
											<li>
												<xsl:value-of select="$valDisplayStatusMessages"/>
											</li>
										</xsl:if>
									</ul>
								</xsl:if>

								<xsl:call-template name="ScriptTriggersContents">
									<xsl:with-param name="triggersParent" select="$theParentObject"/>
								</xsl:call-template>

							</td>
							<td colspan="2">
								<xsl:call-template name="Coordinates">
									<xsl:with-param name="inBounds" select="$theParentObject/Bounds"/>
								</xsl:call-template>
								<xsl:call-template name="ObjectAnchoring">
									<xsl:with-param name="inObject" select="$theParentObject"/>
								</xsl:call-template>
							</td>
							<td colspan="2">
								<xsl:call-template name="GenerateCalc">
									<xsl:with-param name="inDisplayCalc" select="."/>
								</xsl:call-template>
							</td>
						</tr>
					</tbody>
				</table>
				<xsl:call-template name="GetObjectFooter">
					<xsl:with-param name="obj" select="."/>
				</xsl:call-template>
				<br/>
      </xsl:for-each>
    </xsl:if>

    <!-- Document Chart Object -->
    <xsl:variable name="externalChartList" select=".//Object[@type ='ExternalObject']/ExternalObj[@typeID = 'CHRT']"/>
    <xsl:if test="$externalChartList">
      <p>
        <span class="partheading">
          <xsl:call-template name="LayoutObjectSectionAnchor">
            <xsl:with-param name="inLayout" select="."/>
            <xsl:with-param name="inSection" select="$valChartObjects"/>
            <xsl:with-param name="inDisplayText" select="$valChartObjects"/>
          </xsl:call-template>
        </span>
      </p>
      <xsl:for-each select="$externalChartList">
        <table border="1" width="100%">
          <tbody>
            <tr class="chartsubheads" valign="top">
              <td width="40%" colspan="2">
                <xsl:value-of select="$valChartProperties"/>
              </td>
              <td width="20%" colspan="2">
                <xsl:value-of select="$valCoordinates"/>
              </td>
              <td width="40%" colspan="2">
                <xsl:value-of select="$varChartAxisInfo"/>
              </td>
            </tr>

            <tr class="regularcharttext" valign="top">
              <xsl:variable name="theParentObject" select="parent::Object"/>
              <!-- Property Column-->
              <td colspan="2">
                <xsl:call-template name="LayoutObjectAnchor">
                  <xsl:with-param name="inLayoutObject" select="$theParentObject"/>
                  <xsl:with-param name="inDisplayText" select="''"/>
                </xsl:call-template>

                <xsl:if test="$theParentObject/@name">
                  <ul>
                    <b>
                      <xsl:value-of select="concat($valObjectName, ':')"/>
                    </b>
                    <li>
                      <xsl:value-of select="$theParentObject/@name"/>
                    </li>
                  </ul>
                </xsl:if>

                <ul>
                  <b>
                    <xsl:value-of select="concat($valLayoutName,':')"/>
                  </b>
                  <li>
                    <xsl:call-template name="LayoutReference">
                      <xsl:with-param name="inLayout" select="ancestor::Layout"/>
                    </xsl:call-template>
                  </li>
                </ul>

                <!-- Tooltips -->
                <xsl:call-template name="GetObjectInlineAttrs">
                  <xsl:with-param name="inObject" select="$theParentObject"/>
                </xsl:call-template>

                <!-- Additional Properties-->
                <ul>
                  <b>
                    <xsl:value-of select="concat($valAdditionalProperties,':')"/>
                  </b>

                  <!-- Chart Type-->
                  <li>
                    <xsl:choose>
                      <xsl:when test="Visual/Type = 'Bar'">
                        <xsl:value-of select="concat($valType, ': ', $valChartTypeBar)"/>
                      </xsl:when>
                      <xsl:when test="Visual/Type = 'Horizontal Bar'">
                        <xsl:value-of select="concat($valType, ': ', $valChartTypeHBar)"/>
                      </xsl:when>
                      <xsl:when test="Visual/Type = 'Line'">
                        <xsl:value-of select="concat($valType, ': ', $valChartTypeLine)"/>
                      </xsl:when>
                      <xsl:when test="Visual/Type = 'Area'">
                        <xsl:value-of select="concat($valType, ': ', $valChartTypeArea)"/>
                      </xsl:when>
                      <xsl:when test="Visual/Type = 'Pie'">
                        <xsl:value-of select="concat($valType, ': ', $valChartTypePie)"/>
                      </xsl:when>
                    </xsl:choose>
                  </li>

                  <!-- Chart Title-->
                  <li>
                    <xsl:value-of select="concat($valChartTitle, ': ')"/>
                    <xsl:call-template name="GenerateCalc">
                      <xsl:with-param name="inDisplayCalc" select="Title/Text"/>
                    </xsl:call-template>
                  </li>

                  <!-- Include Legend-->
                  <li>
                    <xsl:value-of select="concat($varChartIncludeLegend, ': ')"/>
                    <xsl:if test="not(Legend/@style = 'None')">
                      <xsl:value-of select="$valYes"/>
                    </xsl:if>
                    <xsl:if test="Legend/@style = 'None'">
                      <xsl:value-of select="$valNo"/>
                    </xsl:if>
                  </li>

                  <!-- Series Source-->
                  <li>
                    <xsl:choose>
                      <xsl:when test="SeriesSource/@source = 'Unknown'">
                        <xsl:value-of select="concat($varChartSourceFrom, ': ', $valUnknown)"/>
                      </xsl:when>
                      <xsl:when test="SeriesSource/@source = 'Current Record (delimited data)'">
                        <xsl:value-of select="concat($varChartSourceFrom, ': ', $valSeriesSourceDelimited)"/>
                      </xsl:when>
                      <xsl:when test="SeriesSource/@source = 'Current Found Set'">
                        <xsl:value-of select="concat($varChartSourceFrom, ': ', $valSeriesSourceCurrentFoundSet)"/>
                        <li>
                          <xsl:choose>
                            <xsl:when test="SeriesSource/ShowRecordGroupDataWhenSorted = 'True'">
                              <xsl:value-of select="concat($valShowDataPoints, ': ', $valYes)"/>
                            </xsl:when>
                            <xsl:when test="SeriesSource/ShowRecordGroupDataWhenSorted = 'False'">
                              <xsl:value-of select="concat($valShowDataPoints, ': ', $valNo)"/>
                            </xsl:when>
                          </xsl:choose>
                        </li>
                      </xsl:when>
                      <xsl:when test="SeriesSource/@source = 'Related Records'">
                        <xsl:value-of select="concat($varChartSourceFrom, ': ', $valRelatedRecords)"/>
                        <xsl:if test="SeriesSource/SourceTable">
                          <!-- Table Name-->
                          <li>
                            <xsl:value-of select="concat($varChartSourceTable,': ')"/>
                            <xsl:call-template name="TableAliasReferenceGivenName">
                              <xsl:with-param name="inTableAliasName" select="SeriesSource/SourceTable"/>
                            </xsl:call-template>
                          </li>
                          <li>
                            <xsl:if test="SeriesSource/SortList">
                              <xsl:value-of select="concat($valSortRecords,': ',$valOn)"/>
                            </xsl:if>
                            <xsl:if test="not(SeriesSource/SortList)">
                              <xsl:value-of select="concat($valSortRecords,': ',$valOff)"/>
                            </xsl:if>
                            <xsl:for-each select="SeriesSource/SortList/Sort">
                              <xsl:call-template name="Sort">
                                <xsl:with-param name="inSort" select="."/>
                              </xsl:call-template>
                            </xsl:for-each>
                          </li>
                        </xsl:if>
                      </xsl:when>
                    </xsl:choose>
                  </li>
                </ul>

                <xsl:call-template name="ScriptTriggersContents">
                  <xsl:with-param name="triggersParent" select="$theParentObject"/>
                </xsl:call-template>
              </td>

              <!-- Coordinates Column-->
              <td colspan="2">
                <xsl:call-template name="Coordinates">
                  <xsl:with-param name="inBounds" select="$theParentObject/Bounds"/>
                </xsl:call-template>
                <xsl:call-template name="ObjectAnchoring">
                  <xsl:with-param name="inObject" select="$theParentObject"/>
                </xsl:call-template>
              </td>

              <!-- Axis Info-->
              <td colspan="2">
                <!-- X Axis List-->
                <xsl:call-template name="ChartAxisInfo">
                  <xsl:with-param name="inAxis" select="ChartAxis/XAxisList/Axis"/>
                  <xsl:with-param name="inSeriesList" select="ChartSeries/XSeriesList"/>
                  <xsl:with-param name="inAxisName" select="$varChartXAxis"/>
                  <xsl:with-param name="hasSeriesTitle" select="'False'"/>
                  <xsl:with-param name="hasMultipleSeries" select="'False'"/>
                </xsl:call-template>
                <!-- Y Axis List-->
                <xsl:call-template name="ChartAxisInfo">
                  <xsl:with-param name="inAxis" select="ChartAxis/YAxisList/Axis"/>
                  <xsl:with-param name="inSeriesList" select="ChartSeries/YSeriesList"/>
                  <xsl:with-param name="inAxisName" select="$varChartYAxis"/>
                  <xsl:with-param name="hasSeriesTitle" select="'True'"/>
                  <xsl:with-param name="hasMultipleSeries" select="'True'"/>
                </xsl:call-template>
              </td>
            </tr>
          </tbody>

        </table>
        <xsl:call-template name="GetObjectFooter">
          <xsl:with-param name="obj" select="."/>
        </xsl:call-template>
        <br/>
      </xsl:for-each>
    </xsl:if>

    <!-- Document External control -->
    <xsl:variable name="externalNonWBVList" select=".//Object[@type ='ExternalObject']/ExternalObj[not(@typeID = 'WEBV') and not(@typeID = 'CHRT')]"/>
    <xsl:if test="$externalNonWBVList">
      <p>
        <span class="partheading">
          <xsl:call-template name="LayoutObjectSectionAnchor">
            <xsl:with-param name="inLayout" select="."/>
            <xsl:with-param name="inSection" select="$valExternalObjects"/>
            <xsl:with-param name="inDisplayText" select="$valExternalObjects"/>
          </xsl:call-template>
        </span>
      </p>
      <xsl:for-each select="$externalNonWBVList">
        <table border="1" width="100%">
          <tbody>
            <tr class="chartsubheads" valign="top">
              <td colspan="2" width="40%">
                <xsl:value-of select="$valExternalObjectProperties"/>
              </td>
              <td width="20%" colspan="2">
                <xsl:value-of select="$valCoordinates"/>
              </td>
              <td width="40%" colspan="2">
                <xsl:value-of select="$valCalculations"/>
              </td>
            </tr>

            <tr class="regularcharttext" valign="top">
              <xsl:variable name="theParentObject" select="parent::Object"/>
              <td colspan="2">
                <xsl:call-template name="LayoutObjectAnchor">
                  <xsl:with-param name="inLayoutObject" select="$theParentObject"/>
                  <xsl:with-param name="inDisplayText" select="''"/>
                </xsl:call-template>

                <xsl:if test="$theParentObject/@name">
                  <ul>
                    <b>
                      <xsl:value-of select="concat($valObjectName, ':')"/>
                    </b>
                    <li>
                      <xsl:value-of select="$theParentObject/@name"/>
                    </li>
                  </ul>
                </xsl:if>

                <ul>
                  <b>
                    <xsl:value-of select="concat($valLayoutName,':')"/>
                  </b>
                  <li>
                    <xsl:call-template name="LayoutReference">
                      <xsl:with-param name="inLayout" select="ancestor::Layout"/>
                    </xsl:call-template>
                  </li>
                </ul>

                <xsl:call-template name="GetObjectInlineAttrs">
                  <xsl:with-param name="inObject" select="$theParentObject"/>
                </xsl:call-template>

              </td>
              <td colspan="2">
                <xsl:call-template name="Coordinates">
                  <xsl:with-param name="inBounds" select="$theParentObject/Bounds"/>
                </xsl:call-template>
                <xsl:call-template name="ObjectAnchoring">
                  <xsl:with-param name="inObject" select="$theParentObject"/>
                </xsl:call-template>
              </td>
              <td colspan="2">
                <xsl:choose>
                  <xsl:when test="DisplayCalculation">
                    <ul>
                      <xsl:for-each select="DisplayCalculation">
                        <li>
                          <xsl:call-template name="GenerateDisplayCalcChunks">
                            <xsl:with-param name="inDisplayCalcChunk" select="."/>
                          </xsl:call-template>
                        </li>
                      </xsl:for-each>
                    </ul>
                  </xsl:when>
                  <xsl:otherwise>
                    <ul>
                      <xsl:for-each select="Calculation">
                        <li>
                          <xsl:value-of select="."/>
                        </li>
                      </xsl:for-each>
                    </ul>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </tbody>
        </table>
        <xsl:call-template name="GetObjectFooter">
          <xsl:with-param name="obj" select="."/>
        </xsl:call-template>
        <br/>
      </xsl:for-each>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="ButtonInfo">
    <xsl:param name="inButton"/>
    <xsl:call-template name="ButtonName">
      <xsl:with-param name="inButton" select="$inButton"/>
    </xsl:call-template>
    <xsl:text>--&gt;</xsl:text>
    <xsl:value-of select="$inButton/GroupButtonObj/Step/StepText"/>
  </xsl:template>
  
  <xsl:template name="ButtonName">
    <xsl:param name="inButton"/>
    <xsl:choose>
      <xsl:when test="$inButton/GroupButtonObj/@numOfObjs &gt; 3">
				<xsl:value-of select="$valGroupButton"/>
      </xsl:when>
      <xsl:when test="$inButton/GroupButtonObj/@numOfObjs = 3">
				<xsl:choose>
					<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Text'">
						<xsl:value-of select="concat($valText,': ', $inButton/GroupButtonObj/Object/TextObj/CharacterStyleVector/Style/Data)"/>
					</xsl:when>
					<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Field'">
						<xsl:call-template name="FieldReference-ShowTableAlias">
							<xsl:with-param name="inField" select="$inButton/GroupButtonObj/Object/FieldObj/DDRInfo/Field"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Rect'">
						<xsl:value-of select="$valRect"/>
					</xsl:when>
					<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'RRect'">
						<xsl:value-of select="$valRRect"/>
					</xsl:when>
					<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Portal'">
						<xsl:value-of select="$valPortal"/>
					</xsl:when>					
					<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Line'">
						<xsl:value-of select="$valLine"/>
					</xsl:when>
					<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Oval'">
						<xsl:value-of select="$valOval"/>
					</xsl:when>
				</xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="ButtonStyle">
    <xsl:param name="inButton"/>
    <xsl:if test="$inButton/GroupButtonObj/@numOfObjs = 3"> 
      <xsl:choose>
				<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Text'">
					<xsl:variable name="rounded">
						<xsl:call-template name="Bit">
							<xsl:with-param name="inVal" select="$inButton/GroupButtonObj/Object/TextObj/@flags"/>
							<xsl:with-param name="inBit" select="'16'"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$rounded = 'true'">
							<xsl:value-of select="$valRounded"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$valRectangular"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'Rect'">
					<xsl:value-of select="$valRectangular"/>
				</xsl:when>
				<xsl:when test="$inButton/GroupButtonObj/Object/@type = 'RRect'">
					<xsl:value-of select="$valRounded"/>
				</xsl:when>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name="CFUnaryConditionString">
    <xsl:value-of select="concat(' ', Condition/RangeBegin)"/>
  </xsl:template>

  <xsl:template name="CFBinaryConditionString">
    <xsl:value-of select="concat(' ', Condition/RangeBegin, ' ', $valCFAnd, ' ', Condition/RangeEnd)"/>
  </xsl:template>

  <xsl:template name="CFCondition">
    <xsl:variable name="Op" select="Condition/@op"/>
    <xsl:choose>
      <xsl:when test="$Op = '1'">
				<xsl:value-of select="$valCFBetween"/>
				<xsl:call-template name="CFBinaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '2'">
				<xsl:value-of select="$valCFNotBetween"/>
				<xsl:call-template name="CFBinaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '3'">
				<xsl:value-of select="$valCFEqualTo"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '4'">
				<xsl:value-of select="$valCFNotEqualTo"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '5'">
				<xsl:value-of select="$valCFGreaterThan"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '6'">
				<xsl:value-of select="$valCFLessThan"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '7'">
				<xsl:value-of select="$valCFGreaterThanOrEqualTo"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '8'">
				<xsl:value-of select="$valCFLessThanOrEqualTo"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '9'">
				<xsl:value-of select="$valCFContaining"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '10'">
				<xsl:value-of select="$valCFNotContaining"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '11'">
				<xsl:value-of select="$valCFBeginningWith"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '12'">
				<xsl:value-of select="$valCFEndingWith"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '13'">
				<xsl:value-of select="$valCFEmpty"/>
      </xsl:when>
      <xsl:when test="$Op = '14'">
				<xsl:value-of select="$valCFBeforeToday"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '15'">
				<xsl:value-of select="$valCFToday"/>
      </xsl:when>
      <xsl:when test="$Op = '16'">
				<xsl:value-of select="$valCFAfterToday"/>
				<xsl:call-template name="CFUnaryConditionString"/>
      </xsl:when>
      <xsl:when test="$Op = '17'">
				<xsl:value-of select="concat($valCFMoreThan, ' ')"/>
				<xsl:value-of select="concat(Condition/RangeBegin, ' ')"/>
				<xsl:value-of select="$valCFDaysPassed"/>
      </xsl:when>
      <xsl:when test="$Op = '18'">
				<xsl:value-of select="concat($valCFMoreThan, ' ')"/>
				<xsl:value-of select="concat(Condition/RangeBegin, ' ')"/>
				<xsl:value-of select="$valCFDaysAhead"/>
      </xsl:when>
      <xsl:when test="$Op = '19'">
				<xsl:value-of select="concat($valCFLessThan, ' ')"/>
				<xsl:value-of select="concat(Condition/RangeBegin, ' ')"/>
				<xsl:value-of select="$valCFDaysPassed"/>
      </xsl:when>
      <xsl:when test="$Op = '20'">
				<xsl:value-of select="concat($valCFLessThan, ' ')"/>
				<xsl:value-of select="concat(Condition/RangeBegin, ' ')"/>
				<xsl:value-of select="$valCFDaysAhead"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="CFFormat">
    <ul>
      <xsl:for-each select="Format/CharacterStyle">
				<xsl:call-template name="LayoutObjectCharacterStyle"/>
				<xsl:variable name="CharStyle">
					<xsl:call-template name="CharacterStyleFontFace"/>
				</xsl:variable>
				<xsl:if test="string($CharStyle)">
					<li>
						<xsl:value-of select="concat($valFontStyle, ': ')"/>
						<xsl:value-of select="substring($CharStyle, 0, string-length($CharStyle) - 1)"/>
					</li>
				</xsl:if>
      </xsl:for-each>
      <xsl:for-each select="Format/DrawStyle">
				<xsl:call-template name="LayoutObjectDrawStyle"/>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <xsl:template name="LayoutObjectConditionalFormatting">
    <xsl:for-each select="Item">
      <tr class="regularcharttext">	
				<!-- index -->
				<td align="right" valign="top">
					<xsl:if test="@flags mod 2 = 0">
						<b>
							<xsl:value-of select="concat('&lt;', $valDisabled, '&gt; ')"/>
						</b>
					</xsl:if>
					<b><xsl:value-of select="position()"/>.</b>
				</td>

				<!-- condition -->
				<td valign="top">
					<ul>
						<xsl:if test="Condition/@op &gt; 0">
							<li>					
								<xsl:value-of select="concat($valCFValueIs, ' ')"/>
								<xsl:call-template name="CFCondition"/>
							</li>
						</xsl:if>
						<li>
							<xsl:value-of select="concat($valFormula, ': ')"/>
							<xsl:call-template name="GenerateCalc">
								<xsl:with-param name="inDisplayCalc" select="Condition"/>
							</xsl:call-template>	
						</li>
					</ul>
				</td>

				<!-- format -->
				<td valign="top" align="left">
					<xsl:call-template name="CFFormat"/>
				</td>
      </tr>
    </xsl:for-each>
  </xsl:template>
  
  <!--<xsl:template name="ButtonBoundary">
      <xsl:param name="inButton"/>
    </xsl:template>-->
  
  <!-- Generate Relationships -->
  <xsl:template name="TableHeadings-TableOcurrences">
    <tr class="chartheaders" vAlign="top"> 
      <td width="9%"><xsl:value-of select="$valTableOccurrence"/></td>
      <td width="13%"><xsl:value-of select="$valSourceTable"/></td>
      <td width="11%"><xsl:value-of select="$valSourceFile"/></td>
      <td width="16%"><xsl:value-of select="$valInRelationships"/></td>
      <td width="12%"><xsl:value-of select="$valInScripts"/></td>
      <td width="16%"><xsl:value-of select="$valInFieldDefinitions"/></td>
      <td width="13%"><xsl:value-of select="$valInValueLists"/></td>
      <td width="10%"><xsl:value-of select="$valAssociatedLayouts"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template name="Tables-Relationship" match="RelationshipGraph">
    <xsl:apply-templates/>
  </xsl:template>
  
  <!-- Get table alias. If it represents an external table, make it a reference. Otherwise, make it an anchor. -->
  <xsl:template name="GetTableAlias">
    <xsl:param name="inTableAlias"/>
    <xsl:choose>
      <!-- External table occurrence, make a reference! -->
      <xsl:when test="$inTableAlias/FileReference">
				<xsl:call-template name="TableAliasReference">
					<xsl:with-param name="inTableAlias" select="$inTableAlias"/>
				</xsl:call-template>
      </xsl:when>
      <!-- Internal table occurrence, make an anchor! -->
      <xsl:otherwise>
				<xsl:call-template name="TableAliasAnchor">
					<xsl:with-param name="inTableAlias" select="$inTableAlias"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="Table-TableOccurrences" match="TableList">
    <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valRelationships', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="concat($valRelationships,': ', $valTableOccurrences)"/>
				</xsl:call-template>				
      </span>
    </p>
    <table width="100%" border="1">
      <xsl:call-template name="TableHeadings-TableOcurrences"/>
      
      <xsl:for-each select="Table">
				<!--SORTBYNAME-->
				<!--<xsl:sort select="@name"/>-->
				<tr class="regularcharttext" vAlign="top">
					<!--Table Occurrence-->
					<td bgColor="{@color}">
						
						<xsl:call-template name="GetTableAlias">
							<xsl:with-param name="inTableAlias" select="."/>
						</xsl:call-template>
					</td>
					<!-- Source Tables -->
					<td>
						<xsl:call-template name="BaseTableRefGivenTableAlias">
							<xsl:with-param name="inTableAlias" select="."/>
						</xsl:call-template>
					</td>
					<!-- Source File -->
					<td>
						<xsl:call-template name="GetSourceFileGivenTableAlias">
							<xsl:with-param name="inTableAlias" select ="."/>
						</xsl:call-template>
					</td>
					<!--Relationship reference -->
					<td>
						<xsl:variable name="relationshipsWithTable" select="key('Relationship-LeftTableAliasIndex', @name) | key('Relationship-RightTableAliasIndex', @name)"/>
						<ul>
							<xsl:for-each select="$relationshipsWithTable">
								<li>
									<xsl:call-template name="RelationshipReference">
										<xsl:with-param name="inRelationship" select="."/>
									</xsl:call-template>
								</li>
							</xsl:for-each>
						</ul>
					</td>
					<!--Script reference -->
					<xsl:variable name="varTableName" select="@name"/>
					<td>												
						<xsl:variable name="scriptRefList" select="/FMPReport/File/ScriptCatalog/Script[(*/*//Field[@table = $varTableName]) or (*/*//Table[@name = $varTableName])] | /FMPReport/File/ScriptCatalog//Group/Script[(*/*//Field[@table = $varTableName]) or (*/*//Table[@name = $varTableName])]"/>
						<ul>
							<xsl:for-each select="$scriptRefList">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<li>
									<xsl:call-template name="ScriptReference">
										<xsl:with-param name="inScript" select="."/>
									</xsl:call-template>
								</li>
							</xsl:for-each>
						</ul>
					</td>
					<!--Field Defintion references-->
					<td>						
						<xsl:variable name="fieldRefList" select="key('FieldByTableOccurrenceIndex',$varTableName)"/>
						<ul>
							<xsl:for-each select="$fieldRefList">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<li>
									<xsl:call-template name="FieldDefinitionReference">
										<xsl:with-param name="inFieldDefinition" select="."/>
									</xsl:call-template>
								</li>
							</xsl:for-each>
						</ul>
					</td>
					<!-- ValueList References -->
					<td>					
						<xsl:variable name="tableName" select="@name"/>
						<xsl:variable name="VL-List" select="/FMPReport/File/ValueListCatalog/ValueList[*/Field[@table = $tableName]]"/>
						<ul>
							<xsl:for-each select="$VL-List">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<li>
									<xsl:call-template name="VLReference">
										<xsl:with-param name="inVL" select="."/>
									</xsl:call-template>
								</li>
							</xsl:for-each>
						</ul>
					</td>
					<!-- Layout Reference-->
					<td>						
						<xsl:variable name="tableOccurrenceName" select="@name"/>
						<xsl:variable name="layoutList" select="key('LayoutByTableIndex', $tableOccurrenceName)"/>
						<ul>
							<xsl:for-each select="$layoutList">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<li>
									<xsl:call-template name="LayoutReference">
										<xsl:with-param name="inLayout" select="."/>
									</xsl:call-template>
								</li>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
      </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template name="Table-RelationshipDetails" match="RelationshipList">
    <xsl:if test="Relationship">
      <p>
        <span class="partheading">
				  <xsl:call-template name="AnchorPoint">
					  <xsl:with-param name="inAnchor" select="concat('valDetails', $kAnchorSection)"/>
					  <xsl:with-param name="inDisplayText" select="concat($valRelationships,': ', $valDetails)"/>
				  </xsl:call-template>				
        </span>
      </p>
    </xsl:if>
    <xsl:for-each select="Relationship">
      <p>
				<span class="partheading">
					<xsl:value-of select="concat($valRelationship,': ')"/>
					<xsl:call-template name="RelationshipAnchor">
						<xsl:with-param name="inRelationship" select="."/>
					</xsl:call-template>
				</span>
      </p>
      <xsl:variable name="leftTableName" select="LeftTable/@name"/>
      <xsl:variable name="rightTableName" select="RightTable/@name"/>
      <table width="100%" border="1">
				<tbody>
					<tr vAlign="top">
						<td class="chartheadersnobg" width="18%"><xsl:value-of select="$valTableOccurrence"/></td>
						<td class="regularcharttext" bgColor="{key('BaseTable-TableAliasIndex',$leftTableName)/@color}">
							<xsl:call-template name="TableAliasReferenceGivenName">
								<xsl:with-param name="inTableAliasName" select="$leftTableName"/>
							</xsl:call-template>
						</td>
						<td class="regularcharttext"></td>
						<td class="regularcharttext" bgColor="{key('BaseTable-TableAliasIndex',$rightTableName)/@color}">
							<xsl:call-template name="TableAliasReferenceGivenName">
								<xsl:with-param name="inTableAliasName" select="$rightTableName"/>
							</xsl:call-template>
						</td>
					</tr>
					<!--Now report the join predicates of the relationship!-->
					<xsl:for-each select="JoinPredicateList/JoinPredicate">
						<tr vAlign="top">
							<xsl:choose>
								<xsl:when	test="generate-id(.) = generate-id(ancestor::JoinPredicateList/JoinPredicate[1])">
									<td class="chartheadersnobg">
										<xsl:value-of select="$valField"/>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<td class="chartheadersnobg" align="right">
										<xsl:value-of select="$valAnd"/>
									</td>
								</xsl:otherwise>
							</xsl:choose>
							<td class="regularcharttext">
								<xsl:call-template name="FieldReference-ShowFieldNameOnly">
									<xsl:with-param name="inField" select="LeftField/Field"/>
								</xsl:call-template>
							</td>
							<td class="regularcharttext"  align="middle">
								<xsl:call-template name="JoinPredicateType">
									<xsl:with-param name="inJoinPredicate" select="."/>
								</xsl:call-template>
							</td>
							<td class="regularcharttext">
								<xsl:call-template name="FieldReference-ShowFieldNameOnly">
									<xsl:with-param name="inField" select="RightField/Field"/>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:for-each>
					
					<!--Source Table -->
					<xsl:variable name="leftTableAlias" select="/FMPReport/File/RelationshipGraph/TableList/Table[@name = $leftTableName]"/>
					<xsl:variable name="rightTableAlias" select="/FMPReport/File/RelationshipGraph/TableList/Table[@name = $rightTableName]"/>
					
					<tr vAlign="top">
						<td class="chartheadersnobg">
							<xsl:value-of select="$valSourceTable"/>
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="BaseTableRefGivenTableAlias">
								<xsl:with-param name="inTableAlias" select="$leftTableAlias"/>
							</xsl:call-template>
						</td>
						<td class="regularcharttext">
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="BaseTableRefGivenTableAlias">
								<xsl:with-param name="inTableAlias" select="$rightTableAlias"/>
							</xsl:call-template>
						</td>
					</tr>
					<!--Source File -->
					<tr vAlign="top">
						<td class="chartheadersnobg">
							<xsl:value-of select="$valSourceFile"/>
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="GetSourceFileGivenTableAlias">
								<xsl:with-param name="inTableAlias" select="$leftTableAlias"/>
							</xsl:call-template>
						</td>
						<td class="regularcharttext">
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="GetSourceFileGivenTableAlias">
								<xsl:with-param name="inTableAlias" select="$rightTableAlias"/>
							</xsl:call-template>
						</td>
					</tr>
					<!--Cascade create-->
					<tr vAlign="top">
						<td class="chartheadersnobg">
							<xsl:value-of select="$valAllowCreationRelatedRecords"/>
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="GetState">
								<xsl:with-param name="inValue" select="LeftTable/@cascadeCreate"/>
							</xsl:call-template>
						</td>
						<td class="regularcharttext">
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="GetState">
								<xsl:with-param name="inValue" select="RightTable/@cascadeCreate"/>
							</xsl:call-template>
						</td>
					</tr>
					<!--Cascade Delete-->
					<tr vAlign="top">
						<td class="chartheadersnobg">
							<xsl:value-of select="$valAllowDeleteRelatedRecords"/>
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="GetState">
								<xsl:with-param name="inValue" select="LeftTable/@cascadeDelete"/>
							</xsl:call-template>
						</td>
						<td class="regularcharttext">
						</td>
						<td class="regularcharttext">
							<xsl:call-template name="GetState">
								<xsl:with-param name="inValue" select="RightTable/@cascadeDelete"/>
							</xsl:call-template>
						</td>
					</tr>					
					<tr vAlign="top">
						<td class="chartheadersnobg">
							<xsl:value-of select="$valSortRecords"/>
						</td>
						<td class="regularcharttext">
							<xsl:choose>
								<xsl:when test="LeftTable/SortList/@value='True'">
									<p><xsl:value-of select="$valOn"/></p>
									<xsl:for-each select="LeftTable/SortList/Sort">
										<xsl:call-template name="Sort">
											<xsl:with-param name="inSort" select="."/>
										</xsl:call-template>
									</xsl:for-each>									
								</xsl:when>
								<xsl:otherwise>
									<p><xsl:value-of select="$valOff"/></p>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="regularcharttext">
						</td>
						<td class="regularcharttext">
							<xsl:choose>
								<xsl:when test="RightTable/SortList/@value='True'">
									<xsl:value-of select="$valOn"/>
									<xsl:for-each select="RightTable/SortList/Sort">
										<xsl:call-template name="Sort">
											<xsl:with-param name="inSort" select="."/>
										</xsl:call-template>
									</xsl:for-each>	
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$valOff"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</tbody>
      </table>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="Sort">
    <xsl:param name="inSort"/>
    <xsl:if test="$inSort/PrimaryField">
      <p>
				
				<xsl:value-of select="concat($valField,': ')"/>
				<xsl:call-template name="FieldReference-ShowFieldNameOnly">
					<xsl:with-param name="inField" select="$inSort/PrimaryField/Field"/>
				</xsl:call-template>
      </p>
      <ul>
				<li>
					<xsl:call-template name="SortType">
						<xsl:with-param name="inSort" select="$inSort"/>
					</xsl:call-template>
					<xsl:if test="$inSort/@type = 'Custom'">
						<xsl:text>: </xsl:text>
						<xsl:call-template name="VLReference">
							<xsl:with-param name="inVL" select="$inSort/ValueList"/>
						</xsl:call-template>
					</xsl:if>
				</li>				
				<li>
					<xsl:value-of select="concat($valReorderSummaryField,': ')"/>
					<xsl:choose>
						<xsl:when test="($inSort/SummaryField) and ($inSort/SummaryField/Field/@id > '0')">
							<xsl:call-template name="FieldReference-ShowFieldNameOnly">
								<xsl:with-param name="inField" select="$inSort/SummaryField/Field"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$valOff"/>
						</xsl:otherwise>
					</xsl:choose>
				</li>				
				<li>
					<xsl:choose>
						<xsl:when test="$inSort/OverrideLanguage">
							<xsl:value-of select="concat($valOverrideFieldLang,': ')"/>
							<xsl:call-template name="Language">
								<xsl:with-param name="inLang" select="$inSort/OverrideLanguage/@language"/>
							</xsl:call-template>							
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($valOverrideFieldLang,': ',$valOff)"/>
						</xsl:otherwise>	
					</xsl:choose>										
				</li>				
      </ul>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="SortType">
    <xsl:param name="inSort"/>
    <xsl:choose>
      <xsl:when test="$inSort/@type = 'Ascending'">
				<xsl:value-of select="$valAscending"/>
      </xsl:when>
      <xsl:when test="$inSort/@type = 'Descending'">
				<xsl:value-of select="$valDescending"/>
      </xsl:when>
      <xsl:when test="$inSort/@type = 'Custom'">
				<xsl:value-of select="$valCustomValueList"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  <!--Get TableAlias Reference given the name -->
  <xsl:template name="TableAliasReferenceGivenName">
    <xsl:param name="inTableAliasName"/>
    <xsl:variable name="tableAlias" select="/FMPReport/File/RelationshipGraph/TableList/Table[@name = $inTableAliasName]"/>
    <xsl:choose>
      <xsl:when test="$tableAlias">
				<xsl:call-template name="TableAliasReference">
					<xsl:with-param name="inTableAlias" select="$tableAlias"/>
				</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
				<em><xsl:value-of select="$inTableAliasName"/></em>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Get the relationship reference -->
  <xsl:template name="RelationshipReference">
    <xsl:param name="inRelationship"/>
    <xsl:variable name="relationshipName">
      <xsl:call-template name="GetRelationshipName">
				<xsl:with-param name="inRelationship" select="$inRelationship"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="ItalicLink-WithAnchor">
      <xsl:with-param name="inAnchor" select="concat('#',$relationshipName, $kAnchorRelationship)"/>
      <xsl:with-param name="inDisplayText" select="$relationshipName"/>
    </xsl:call-template>		
  </xsl:template>
  
  <!--Relationship anchor -->
  <xsl:template name="RelationshipAnchor">
    <xsl:param name="inRelationship"/>
    <xsl:variable name="relationshipName">
      <xsl:call-template name="GetRelationshipName">
				<xsl:with-param name="inRelationship" select="$inRelationship"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:call-template name="ItalicAnchorPoint">
      <xsl:with-param name="inAnchor" select="concat($relationshipName, $kAnchorRelationship)"/>
      <xsl:with-param name="inDisplayText" select="$relationshipName"/>
    </xsl:call-template>		
  </xsl:template>
  
  
  <xsl:template name="GetRelationshipName">
    <xsl:param name="inRelationship"/>
    <xsl:variable name="relationshipType">
      <xsl:call-template name="GetRelationshipType">
				<xsl:with-param name="inRelationship" select="$inRelationship"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="concat($inRelationship/LeftTable/@name, $relationshipType, $inRelationship/RightTable/@name)"/>
  </xsl:template>
  
  <xsl:template name="GetRelationshipType">
    <xsl:param name="inRelationship"/>
    <xsl:choose>
      <xsl:when test="count($inRelationship/JoinPredicateList/JoinPredicate) &gt; 1">
				<xsl:value-of select="$valInfinite"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:call-template name="JoinPredicateType">
					<xsl:with-param name="inJoinPredicate" select="$inRelationship/JoinPredicateList/JoinPredicate[1]"/>
				</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="JoinPredicateType">
    <xsl:param name="inJoinPredicate"/>
    <xsl:choose>
      <xsl:when test="$inJoinPredicate/@type = 'Equal'">
				<xsl:value-of select="$valEqual"/>
      </xsl:when>
      <xsl:when test="$inJoinPredicate/@type = 'NotEqual'">
				<xsl:value-of select="$valNotEqual"/>
      </xsl:when>
      <xsl:when test="$inJoinPredicate/@type = 'LessThan'">
				<xsl:value-of select="$valLessThan"/>
      </xsl:when>
      <xsl:when test="$inJoinPredicate/@type = 'LessThanOrEqualTo'">
				<xsl:value-of select="$valLessThanOrEqualTo"/>
      </xsl:when>
      <xsl:when test="$inJoinPredicate/@type = 'GreaterThan'">
				<xsl:value-of select="$valGreaterThan"/>
      </xsl:when>
      <xsl:when test="$inJoinPredicate/@type = 'GreaterThanOrEqualTo'">
				<xsl:value-of select="$valGreaterThanOrEqualTo"/>
      </xsl:when>
      <xsl:when test="$inJoinPredicate/@type = 'CartesianProduct'">
				<xsl:value-of select="$valCartesianProduct"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="GetSourceFileGivenTableAlias">
    <xsl:param name="inTableAlias"/>
    <xsl:choose>
      <xsl:when test="$inTableAlias/FileReference">
				<xsl:value-of select="concat($valDataSource,': ')"/>
				<xsl:call-template name="FileRefReference">
					<xsl:with-param name="inFileReference" select="$inTableAlias/FileReference"/>
				</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="/FMPReport/File/@name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="GetState">
    <xsl:param name="inValue"/>
    <xsl:choose>
      <xsl:when test="$inValue = 'True'">
				<xsl:value-of select="$valOn"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$valOff"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>		
  
  
  <!--Generate privilege information-->
  <xsl:template name="Table-PrivilegeCatalog" match="PrivilegesCatalog">
    <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valPrivilegeSets', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valPrivilegeSets"/>
				</xsl:call-template>				
      </span>
    </p>
    <xsl:for-each select="PrivilegeSet">
      <table width="95%" border="1">
				<tbody>
					<tr class="privsetfirst" vAlign="top">
						<td colSpan="2">
							<xsl:value-of select="concat($valPrivilegeSet, ': ')"/>
							<xsl:call-template name="PrivilegeSetAnchor">
								<xsl:with-param name="inPrivilegeSet" select="."/>
							</xsl:call-template>
						</td>
					</tr>
					<tr vAlign="top">
						<td class="chartheadersnobg" width="11%">
							<xsl:value-of select="$valDescription"/>
						</td>
						<td class="regularcharttext" width="89%">
							<xsl:value-of select="@comment"/>
						</td>
					</tr>
					<tr vAlign="top">
						<td class="chartheadersnobg">
							<xsl:value-of select="$valUsedBy"/>
						</td>
						<td class="regularcharttext">
							<xsl:variable name="currentPrivilegeSet" select="."/>
							<xsl:variable name="accountList" select="/FMPReport/File/AccountCatalog/Account[@privilegeSet = $currentPrivilegeSet/@name]"/>
							<xsl:for-each select="$accountList">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<xsl:if test="generate-id(.) != generate-id($accountList[1])">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:call-template name="AccountReference">
									<xsl:with-param name="inAccount" select="."/>
								</xsl:call-template>
							</xsl:for-each>
						</td>
					</tr>
				</tbody>
      </table>
      <!--Data Access and Design -->
      <table width="95%" border="1">
				<tbody>
					<tr vAlign="top">
						<td class="chartsubheads" colSpan="5">
							<xsl:value-of select="$valDataAccessAndDesign"/>
						</td>
					</tr>
					<!--Record privileges-->
					<tr vAlign="top">
						<td class="chartheadersnobg" width="11%">
							<xsl:value-of select="$valRecords"/>
						</td>
						<td class="regularcharttext" width="19%">
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="Records/@value"/>
							</xsl:call-template>
						</td>
						<xsl:choose>
							<xsl:when test="Records/@value != 'Custom'">
								<td class="regularcharttext" width="70%">
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="69%" colSpan="2">
									<xsl:call-template name="TablePrivileges">
										<xsl:with-param name="inTableList" select="Records/TableList"/>
									</xsl:call-template>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					
					<!--Layout privileges-->
					<tr vAlign="top">
						<td class="chartheadersnobg" width="11%">
							<xsl:value-of select="$valLayouts"/>
						</td>
						<td class="regularcharttext" width="19%">
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="Layouts/@value"/>
							</xsl:call-template>
						</td>
						<xsl:choose>
							<xsl:when test="Layouts/@value != 'Custom'">
								<td class="regularcharttext" width="70%">
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="69%" colSpan="2">
									<span class="regularcharttext">
										<xsl:value-of select="concat($valAllowCreationLayouts, ': ')"/>
										<xsl:call-template name="GetState">
											<xsl:with-param name="inValue" select="Layouts/@allowCreation"/>
										</xsl:call-template>
									</span>
									<xsl:call-template name="LayoutPrivileges">
										<xsl:with-param name="inLayoutList" select="Layouts/LayoutList"/>
									</xsl:call-template>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					
					<!-- Value list privileges-->
					<tr vAlign="top">
						<td class="chartheadersnobg" width="11%">
							<xsl:value-of select="$valValueLists"/>
						</td>
						<td class="regularcharttext" width="19%">
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="ValueLists/@value"/>
							</xsl:call-template>
						</td>
						<xsl:choose>
							<xsl:when test="ValueLists/@value != 'Custom'">
								<td class="regularcharttext" width="70%">
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="69%" colSpan="2">
									<span class="regularcharttext">
										<xsl:value-of select="concat($valAllowCreationValueLists, ': ')"/>
										<xsl:call-template name="GetState">
											<xsl:with-param name="inValue" select="ValueLists/@allowCreation"/>
										</xsl:call-template>
									</span>
									<xsl:call-template name="ValueListPrivileges">
										<xsl:with-param name="inValueListList" select="ValueLists/ValueListList"/>
									</xsl:call-template>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
					
					<!--Script Privileges-->
					<tr vAlign="top">
						<td class="chartheadersnobg" width="11%">
							<xsl:value-of select="$valScripts"/>
						</td>
						<td class="regularcharttext" width="19%">
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="Scripts/@value"/>
							</xsl:call-template>
						</td>
						<xsl:choose>
							<xsl:when test="Scripts/@value != 'Custom'">
								<td class="regularcharttext" width="70%">
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td width="69%" colSpan="2">
									<span class="regularcharttext">
										<xsl:value-of select="concat($valAllowCreationScripts, ': ')"/>
										<xsl:call-template name="GetState">
											<xsl:with-param name="inValue" select="Scripts/@allowCreation"/>
										</xsl:call-template>
									</span>
									<xsl:call-template name="ScriptPrivileges">
										<xsl:with-param name="inScriptList" select="Scripts/ScriptList"/>
									</xsl:call-template>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</tr>
				</tbody>
      </table>
      
      <!--Other privileges -->
      <xsl:call-template name="OtherPrivileges">
				<xsl:with-param name="inPrivilegeSet" select="."/>
      </xsl:call-template>
      
      <!--Selected Extended Privileges-->
      <xsl:call-template name="SelectedExtendedPrivileges">
				<xsl:with-param name="inPrivilegeSet" select="."/>
      </xsl:call-template>
      
      <xsl:choose>
				<xsl:when test="generate-id(.) != generate-id(/FMPReport/File/PrivilegesCatalog/Privilege[last()])">
					<br/>
				</xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="GetAccessType">
    <xsl:param name="inAccessType"/>
    <xsl:choose>
      <xsl:when test="'ViewOnly' = $inAccessType">
				<xsl:value-of select="$valViewOnly"/>
      </xsl:when>
      <xsl:when test="'CreateEdit' = $inAccessType">
				<xsl:value-of select="$valCreateEdit"/>
      </xsl:when>
      <xsl:when test="'CreateEditDelete' = $inAccessType">
				<xsl:value-of select="$valCreateEditDelete"/>
      </xsl:when>
      <xsl:when test="'Modifiable' = $inAccessType">
				<xsl:value-of select="$valModifiable"/>
      </xsl:when>
      <xsl:when test="'NoAccess' = $inAccessType">
				<xsl:value-of select="$valNoAccess"/>
      </xsl:when>
      <xsl:when test="'Custom' = $inAccessType">
				<xsl:value-of select="$valCustom"/>
      </xsl:when>
      <xsl:when test="'ExecutableOnly' = $inAccessType">
				<xsl:value-of select="$valExecutableOnly"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="TablePrivileges">
    <xsl:param name="inTableList"/>
    <table borderColor="#cccccc" cellSpacing="1" cellPadding="1" width="100%" border="1">
      <tbody>
				<tr class="limitedPSchartheadings">
					<td width="18%">
						<strong><xsl:value-of select="$valTableName"/></strong>
					</td>
					<td width="18%">
						<strong><xsl:value-of select="$valView"/></strong>
					</td>
					<td width="14%">
						<strong><xsl:value-of select="$valEdit"/></strong>
					</td>
					<td width="14%">
						<strong><xsl:value-of select="$valCreate"/></strong>
					</td>
					<td width="14%">
						<strong><xsl:value-of select="$valDelete"/></strong>
					</td>
					<td width="22%">
						<strong><xsl:value-of select="$valFieldAccess"/></strong>
					</td>
				</tr>
				<xsl:for-each select="$inTableList/BaseTable">
					<!--SORTBYNAME-->
					<!--<xsl:sort select="@name"/>-->
					<tr class="regularcharttext" vAlign="top">
						<td>
							<xsl:call-template name="BaseTableReference">
								<xsl:with-param name="inBaseTable" select="@name"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessValue">
								<xsl:with-param name="inAccess" select="View"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessValue">
								<xsl:with-param name="inAccess" select="Edit"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessValue">
								<xsl:with-param name="inAccess" select="Create"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessValue">
								<xsl:with-param name="inAccess" select="Delete"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="FieldAccess">
								<xsl:with-param name="inAccess" select="FieldAccess"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:template name="LayoutPrivileges">
    <xsl:param name="inLayoutList"/>
    <table borderColor="#cccccc" cellSpacing="1" cellPadding="1" width="100%" border="1">
      <tbody>
				<tr class="limitedPSchartheadings">
					<td width="27%">
						<strong><xsl:value-of select="$valLayoutName"/></strong>
					</td>
					<td width="27%">
						<strong><xsl:value-of select="$valLayoutAccess"/></strong>
					</td>
					<td width="17%">
						<strong><xsl:value-of select="$valDataAccess"/></strong>
					</td>
					<td width="29%">
						<strong><xsl:value-of select="$valAssociatedTableOccurrence"/></strong>
					</td>
				</tr>
				<xsl:for-each select="$inLayoutList/Layout">
					<!--SORTBYNAME-->
					<!--<xsl:sort select="@name"/>-->
					<tr class="regularcharttext" vAlign="top">
						<td>
							<xsl:call-template name="LayoutReference">
								<xsl:with-param name="inLayout" select="."/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="LayoutAccess/@value"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="DataAccess/@value"/>
							</xsl:call-template>
						</td>						
						<td>
							<xsl:variable name="layoutName" select="@name"/>
							<xsl:variable name="layoutID" select="@id"/>
							<xsl:variable name="tableOccurrence" select="key('LayoutIndex',concat($layoutName,$layoutID))/Table"/>
							<xsl:if test="$tableOccurrence">
								<xsl:call-template name="TableAliasReference">
									<xsl:with-param name="inTableAlias" select="$tableOccurrence"/>
								</xsl:call-template>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:template name="ValueListPrivileges">
    <xsl:param name="inValueListList"/>
    <table borderColor="#cccccc" cellSpacing="1" cellPadding="1" width="100%" border="1">
      <tbody>
				<tr class="limitedPSchartheadings">
					<td>
						<strong><xsl:value-of select="$valValueListName"/></strong>
					</td>
					<td>
						<strong><xsl:value-of select="$valValueListAccess"/></strong>
					</td>
				</tr>
				<xsl:for-each select="$inValueListList/ValueList">
					<!--SORTBYNAME-->
					<!--<xsl:sort select="@name"/>-->
					<tr class="regularcharttext" vAlign="top">
						<td>
							<xsl:call-template name="VLReference">
								<xsl:with-param name="inVL" select="."/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="Access/@value"/>
							</xsl:call-template>
						</td>
					</tr>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:template name="ScriptPrivileges">
    <xsl:param name="inScriptList"/>
    <table borderColor="#cccccc" cellSpacing="1" cellPadding="1" width="100%" border="1">
      <tbody>
				<tr class="limitedPSchartheadings">
					<td>
						<strong><xsl:value-of select="$valScriptName"/></strong>
					</td>
					<td>
						<strong><xsl:value-of select="$valScriptAccess"/></strong>
					</td>
					<td>
						<strong><xsl:value-of select="$valNotes"/></strong>
					</td>
				</tr>
				<xsl:for-each select="$inScriptList/Script">
					<!--SORTBYNAME-->
					<!--<xsl:sort select="@name"/>-->
					<tr class="regularcharttext" vAlign="top">
						<td>
							<xsl:call-template name="ScriptReference">
								<xsl:with-param name="inScript" select="."/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="GetAccessType">
								<xsl:with-param name="inAccessType" select="Access/@value"/>
							</xsl:call-template>
						</td>						
						<td>
							<xsl:if test="@runFullAccess = 'True'">
								<xsl:value-of select="$valRunScriptFullAccess"/>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:template name="FieldAccess">		
    <xsl:param name="inAccess"/>
    <xsl:call-template name="GetAccessValue">
      <xsl:with-param name="inAccess" select="$inAccess"/>
    </xsl:call-template>
    <xsl:if test="$inAccess/FieldList">
      <ul>
				<xsl:for-each select="$inAccess/FieldList/Field">	
					<li>
						<xsl:call-template name="FieldDefinitionReference">
							<xsl:with-param name="inFieldDefinition" select="."/>
						</xsl:call-template>	
						<xsl:text>: </xsl:text>
						<xsl:call-template name="GetAccessType">
							<xsl:with-param name="inAccessType" select="@accessRestriction"/>
						</xsl:call-template>				
					</li>
				</xsl:for-each>
      </ul>
    </xsl:if>		
  </xsl:template>
  
  <xsl:template name="GetAccessValue">
    <xsl:param name="inAccess"/>
    <xsl:choose>
      <xsl:when test="$inAccess/@value = 'True'">
				<xsl:value-of select="$valYes"/>
      </xsl:when>
      <xsl:when test="$inAccess/@value = 'False'">
				<xsl:value-of select="$valNo"/>
      </xsl:when>
      <xsl:when test="$inAccess/@value = 'Limited'">
				<p><xsl:value-of select="$valLimited"/></p>
				<xsl:if test="$inAccess/Calculation">
					<p><xsl:value-of select="concat($valCalculation, ':')"/></p>
					<p>
						<xsl:call-template name="GenerateCalc">
							<xsl:with-param name="inDisplayCalc" select="$inAccess"/>
						</xsl:call-template>
					</p>
				</xsl:if>
      </xsl:when>
      <xsl:when test="$inAccess/@value = 'All'">
				<xsl:value-of select="$valAll"/>
      </xsl:when>
      <xsl:when test="$inAccess/@value = 'NoAccess'">
				<xsl:value-of select="$valNone"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="PrivilegeMenu">
    <xsl:param name="inMenu"/>
    <xsl:choose>
      <xsl:when test="$inMenu = 'All'">
				<xsl:value-of select="$valAll"/>
      </xsl:when>
      <xsl:when test="$inMenu = 'EditOnly'">
				<xsl:value-of select="$valEditingOnly"/>
      </xsl:when>
      <xsl:when test="$inMenu = 'Minimal'">
				<xsl:value-of select="$valMinimal"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="OtherPrivileges">
    <xsl:param name="inPrivilegeSet"/>
    <table width="95%" border="1">
      <tbody>
				<tr vAlign="top">
					<td class="chartsubheads" colSpan="5">
						<xsl:value-of select="$valOtherPrivileges"/>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="34%">
						<xsl:value-of select="$valAllowPrinting"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="$inPrivilegeSet/@printing"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="53%">
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="34%">
						<xsl:value-of select="$valAllowExporting"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="$inPrivilegeSet/@exporting"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="53%">
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="34%">
						<xsl:value-of select="$valManageExtPrivileges"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="$inPrivilegeSet/@managedExtended"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="53%">
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="34%">
						<xsl:value-of select="$valAllowDataValidation"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="$inPrivilegeSet/@overrideValidationWarning"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="53%">
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="34%">
						<xsl:value-of select="$valDisconnectFromFMServer"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="$inPrivilegeSet/@idleDisconnect"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="53%">
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="34%">
						<xsl:value-of select="$valAllowModifyPassword"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="$inPrivilegeSet/@allowModifyPassword"/>
						</xsl:call-template>						
					</td>
					<td class="regularcharttext" width="53%">
						<xsl:if test="$inPrivilegeSet/@passwordExpiry or $inPrivilegeSet/@passwordMinLength">
							<ul>
								<xsl:if test="$inPrivilegeSet/@passwordExpiry">
									<li>
										<xsl:value-of select="concat($valExpiraryDate,': ', $inPrivilegeSet/@passwordExpiry,' ',$valDays)"/>
									</li>
								</xsl:if>
								<xsl:if test="$inPrivilegeSet/@passwordMinLength">
									<li>
										<xsl:value-of select="concat($valMinPasswordLength,': ', $inPrivilegeSet/@passwordMinLength,' ',$valCharacters)"/>
									</li>
								</xsl:if>
							</ul>
						</xsl:if>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="34%">
						<xsl:value-of select="$valAvailableMenuCommands"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="PrivilegeMenu">
							<xsl:with-param name="inMenu" select="$inPrivilegeSet/@menu"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="53%">
					</td>
				</tr>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:template name="SelectedExtendedPrivileges">
    <xsl:param name="inPrivilegeSet"/>				
    <xsl:variable name="extendedPrivileges" select="/FMPReport/File/ExtendedPrivilegeCatalog/ExtendedPrivilege[PrivilegeSetList/PrivilegeSet/@name = $inPrivilegeSet/@name]"/>		
    <xsl:if test="count($extendedPrivileges) &gt; 0">
      <table width="95%" border="1">
				<tbody>
					<tr vAlign="top">
						<td class="chartsubheads" colSpan="4">
							<xsl:value-of select="$valExtendedPrivileges"/>
						</td>
					</tr>
					<xsl:for-each select="$extendedPrivileges">
						<!--SORTBYNAME-->
						<!--<xsl:sort select="@name"/>-->
						<tr vAlign="top">
							<td class="regularcharttext">
								<xsl:call-template name="ExtendedPrivilegeReference">
									<xsl:with-param name="inExtendedPrivilege" select="."/>
								</xsl:call-template>
							</td>
						</tr>
					</xsl:for-each>
				</tbody>
      </table>
    </xsl:if>
  </xsl:template>
  
  <!--Extended Privileges -->
  <xsl:template name="Table-ExtendedPrivilegeCatalog" match="ExtendedPrivilegeCatalog">
    <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valExtendedPrivileges', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valExtendedPrivileges"/>
				</xsl:call-template>				
      </span>
    </p>
    
    <table width="95%" border="1">
      <tbody>
				<tr class="chartheaders" vAlign="top">
					<td width="16%">
						<xsl:value-of select="$valKeyword"/>
					</td>
					<td width="50%">
						<xsl:value-of select="$valDescription"/>
					</td>
					<td width="34%">
						<xsl:value-of select="$valPrivilegeSet"/>
					</td>
				</tr>
				<xsl:for-each select="ExtendedPrivilege">
					<!--SORTBYNAME-->
					<!--<xsl:sort select="@name"/>-->
					<tr class="regularcharttext" vAlign="top">
						<td>
							<xsl:call-template name="ExtendedPrivilegeAnchor">
								<xsl:with-param name="inExtendedPrivilege" select="."/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:value-of select="@comment"/>
						</td>
						<td>
							<xsl:if test="PrivilegeSetList">
								<ul>
									<xsl:for-each select="PrivilegeSetList/PrivilegeSet">
										<!--SORTBYNAME-->
										<!--<xsl:sort select="@name"/>-->
										<li>
											<xsl:call-template name="PrivilegeSetReference">
												<xsl:with-param name="inPrivilegeSetName" select="@name"/>
											</xsl:call-template>
										</li>
									</xsl:for-each>
								</ul>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <!--User Account -->
  <xsl:template name="Table-AccountCatalog" match="AccountCatalog">
    <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valAccounts', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valAccounts"/>
				</xsl:call-template>				
      </span>
    </p>
    <table width="95%" border="1">
      <tbody>
				<tr class="chartheaders" vAlign="top">
					<td width="12%">
						<xsl:value-of select="$valAccountName"/>
					</td>
					<td width="13%">
						<xsl:value-of select="$valPassword"/>
					</td>
					<td width="9%">
						<xsl:value-of select="$valStatus"/>
					</td>
					<td width="6%">
						<xsl:value-of select="$valType"/>
					</td>
					<td width="15%">
						<xsl:value-of select="$valPrivilegeSet"/>
					</td>
					<td width="15%">
						<xsl:value-of select="$valDescription"/>
					</td>
					<td width="27%">
						<xsl:value-of select="$valChangePassword"/>
					</td>
				</tr>
				<xsl:for-each select="Account">
					<!--SORTBYNAME-->
					<!--<xsl:sort select="@name"/>-->
					<tr class="regularcharttext">
						<td>
							<xsl:call-template name="AccountAnchor">
								<xsl:with-param name="inAccount" select="."/>
							</xsl:call-template>
						</td>						
						<td>
							<xsl:if test="@emptyPassword = 'False'">
								<xsl:value-of select="'*********'"/>
							</xsl:if>
						</td>
						<td>
							<xsl:call-template name="AccountStatus">
								<xsl:with-param name="inStatus" select="@status"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="AccountType">
								<xsl:with-param name="inAccountType" select="@managedBy"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:call-template name="PrivilegeSetReference">
								<xsl:with-param name="inPrivilegeSetName" select="@privilegeSet"/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:value-of select="Description"/>
						</td>
						<td>
							<xsl:if test="@changePasswordOnNextLogin">							
								<xsl:call-template name="GetState">
									<xsl:with-param name="inValue" select="@changePasswordOnNextLogin"/>
								</xsl:call-template>
							</xsl:if>
						</td>
					</tr>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template name="AccountStatus">
    <xsl:param name="inStatus"/>
    <xsl:choose>
      <xsl:when test="$inStatus = 'Active'">
				<xsl:value-of select="$valActive"/>
      </xsl:when>
      <xsl:when test="$inStatus = 'Inactive'">
				<xsl:value-of select="$valInactive"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="AccountType">
    <xsl:param name="inAccountType"/>
    <xsl:choose>
      <xsl:when test="$inAccountType = 'FileMaker'">
				<xsl:value-of select="$valFileMaker"/>
      </xsl:when>
      <xsl:when test="$inAccountType = 'External'">
				<xsl:value-of select="$valExternalServer"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

	<!--File Access / Authorized Files-->
	<xsl:template name="Table-AuthFileCatalog" match="AuthFileCatalog">
		<p>
			<span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valFileAccess', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valFileAccess"/>
				</xsl:call-template>
			</span>
		</p>
		<table width="95%" border="1">
			<tbody>
				<tr class="chartheaders" vAlign="top">
					<td width="100%" colSpan="3">
						<xsl:value-of select="$valFileAccessOptions"/>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="30%">
						<xsl:value-of select="$valFileAccessRequireV2"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="@restrictOldVersions"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="57%">
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg" width="30%">
						<xsl:value-of select="$valFileAccessRequireAuth"/>
					</td>
					<td class="regularcharttext" width="13%">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="@requireAuthorization"/>
						</xsl:call-template>
					</td>
					<td class="regularcharttext" width="57%">
					</td>
				</tr>
			</tbody>
		</table>

		<xsl:if test="count(Inbound) &gt; 0">
			<table width="95%" border="1">
				<tbody>
					<tr class="chartheaders" vAlign="top">
						<td width="60%">
							<xsl:call-template name="AnchorPoint">
								<xsl:with-param name="inAnchor" select="concat('valFileAccessInbound', $kAnchorSection)"/>
								<xsl:with-param name="inDisplayText" select="$valFileAccessInboundFiles"/>
							</xsl:call-template>
						</td>
						<td width="20%">
							<xsl:value-of select="$valFileAccessAuthUser"/>
						</td>
						<td width="20%">
							<xsl:value-of select="$valFileAccessAuthDate"/>
						</td>
					</tr>
					<xsl:for-each select="Inbound/InboundAuthorization">
						<!--SORTBYNAME-->
						<!--<xsl:sort select="@name"/>-->
						<tr class="regularcharttext" vAlign="top">
							<td>
								<xsl:value-of select="@filenames"/>
							</td>
							<td>
								<xsl:value-of select="@user"/>
							</td>
							<td>
								<xsl:value-of select="@date"/>
							</td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
		</xsl:if>
		
		<xsl:if test="count(Outbound) &gt; 0">
			<table width="95%" border="1">
				<tbody>
					<tr class="chartheaders" vAlign="top">
						<td width="60%">
							<xsl:call-template name="AnchorPoint">
								<xsl:with-param name="inAnchor" select="concat('valFileAccessOutbound', $kAnchorSection)"/>
								<xsl:with-param name="inDisplayText" select="$valFileAccessOutboundFiles"/>
							</xsl:call-template>
						</td>
						<td width="20%">
							<xsl:value-of select="$valFileAccessAuthUser"/>
						</td>
						<td width="20%">
							<xsl:value-of select="$valFileAccessAuthDate"/>
						</td>
					</tr>
					<xsl:for-each select="Outbound/OutboundAuthorization">
						<!--SORTBYNAME-->
						<!--<xsl:sort select="@name"/>-->
						<tr class="regularcharttext" vAlign="top">
							<td>
								<xsl:value-of select="@filenames"/>
							</td>
							<td>
								<xsl:value-of select="@user"/>
							</td>
							<td>
								<xsl:value-of select="@date"/>
							</td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
		</xsl:if>
				
	</xsl:template>

		<!--File reference-->
  <xsl:template name="Table-FileReferenceCatalog" match="FileReferenceCatalog">
	<xsl:if test="count(FileReference) &gt; 0">
		<p>
		<span class="partheading">
					<xsl:call-template name="AnchorPoint">
						<xsl:with-param name="inAnchor" select="concat('valFileReferences', $kAnchorSection)"/>
						<xsl:with-param name="inDisplayText" select="$valFileReferences"/>
					</xsl:call-template>				
		</span>
		</p>
		<table width="100%" border="1" cellSpacing="1" cellPadding="1">
		<tbody>
					<tr class="chartheaders" vAlign="top">
						<td width="22%">
							<xsl:value-of select="$valFileReference"/>
						</td>
						<td width="78%">
							<xsl:value-of select="$valPathList"/>
						</td>
					</tr>
					<xsl:for-each select="FileReference">
						<!--SORTBYNAME-->
						<!--<xsl:sort select="@name"/>-->
						<tr class="regularcharttext" vAlign="top">
							<td>
								<xsl:call-template name="FileRefAnchor">
									<xsl:with-param name="inFileReference" select="."/>
								</xsl:call-template>
							</td>
							<td>
								<xsl:value-of select="@pathList"/>
							</td>
						</tr>
					</xsl:for-each>
		</tbody>
		</table>
    </xsl:if>

	<xsl:if test="count(OdbcDataSource) &gt; 0">
		<p>
			<span class="partheading">
				<xsl:call-template name="OdbcDataSourceSectionAnchor"/>
			</span>
		</p>	

		<table width="100%" border="1">
			<tbody>
				<tr class="chartheaders">
					<td>
						<xsl:value-of select="$valName"/>
					</td>
					<td>
						<xsl:value-of select="$valDSN"/>
					</td>
					<td>
						<xsl:value-of select="$valAuthentication"/>
					</td>
					<td>
						<xsl:value-of select="$valFiltering"/>
					</td>
				</tr>

				<xsl:for-each select="OdbcDataSource">
					<tr class="regularcharttext" valign="top">
						<td>
							<xsl:call-template name="FileRefAnchor">
								<xsl:with-param name="inFileReference" select="."/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:value-of select="@DSN"/>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="@promptForLogin = 'True'">
									<xsl:value-of select="$valPromptForLogin"/>
								</xsl:when>
								<xsl:when test="@useSso = 'True'">
									<xsl:value-of select="$valLoginWithSingleSignOn"/>
									<ul>
										<li>
											<xsl:value-of select="concat($valSPN, ': ')"/>
											<xsl:value-of select="ssoSpn"/>
										</li>
									</ul>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$valLoginWithCredentials"/>
									<ul>
										<li>
											<xsl:value-of select="concat($valUsername, ': ')"/>
											<xsl:call-template name="GenerateCalc">
												<xsl:with-param name="inDisplayCalc" select="Username"/>
											</xsl:call-template>
										</li>
										<li>
											<xsl:value-of select="concat($valPassword, ': ')"/>
											<xsl:call-template name="GenerateCalc">
												<xsl:with-param name="inDisplayCalc" select="Password"/>
											</xsl:call-template>
										</li>
									</ul>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td>
							<ul>
								<xsl:if test="string(FilterTables/@catalogName)">
									<li>
										<xsl:value-of select="concat($valCatalogName, ': ', FilterTables/@catalogName)"/>
									</li>
								</xsl:if>
								<xsl:if test="string(FilterTables/@schemaName)">
									<li>
										<xsl:value-of select="concat($valSchemaName, ': ', FilterTables/@schemaName)"/>
									</li>
								</xsl:if>
								<xsl:if test="string(FilterTables/@tableName)">
									<li>
										<xsl:value-of select="concat($valTableName, ': ', FilterTables/@tableName)"/>
									</li>
								</xsl:if>

								<xsl:if test="FilterTables/@typeBasedFilter = 'True'">
									<xsl:variable name="ftypes">
										<xsl:if test="FilterTables/@retrieveViews = 'True'">
											<xsl:value-of select="concat($valFilterViews, ', ')"/>
										</xsl:if>
										<xsl:if test="FilterTables/@retrieveTables = 'True'">
											<xsl:value-of select="concat($valFilterTables, ', ')"/>
										</xsl:if>
										<xsl:if test="FilterTables/@retrieveSystemTables = 'True'">
											<xsl:value-of select="concat($valFilterSystemTables, ', ')"/>
										</xsl:if>
									</xsl:variable>

									<li>
										<xsl:value-of select="concat($valFilterTypes, ': ')"/>
										<xsl:value-of select="substring($ftypes, 0, string-length($ftypes) - 1)"/>
									</li>
								</xsl:if>
							</ul>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:if>
  </xsl:template>
  
  <!--Custom Function-->
  <xsl:template name="Table-CustomFunctionCatalog" match="CustomFunctionCatalog">
    <xsl:if test="CustomFunction">
      <p>
        <span class="partheading">
				  <xsl:call-template name="AnchorPoint">
					  <xsl:with-param name="inAnchor" select="concat('valCustomFunctions', $kAnchorSection)"/>
					  <xsl:with-param name="inDisplayText" select="$valCustomFunctions"/>
				  </xsl:call-template>	
        </span>
      </p>
      <table width="100%" border="1" cellSpacing="1" cellPadding="1">
        <tbody>
				  <tr class="chartheaders" vAlign="top">
					  <td width="18%">
						  <xsl:value-of select="$valFunctionName"/>
					  </td>
					  <td width="18%">
						  <xsl:value-of select="$valParameters"/>
					  </td>
					  <td width="18%">
						  <xsl:value-of select="$valAvailability"/>
					  </td>
					  <td width="20%">
						  <xsl:value-of select="$valDefinition"/>
					  </td>
					  <td width="18%">
						  <xsl:value-of select="$valInFieldDefinitions"/>
					  </td>
					  <td width="18%">
						  <xsl:value-of select="$valInScripts"/>
					  </td>
				  </tr>
				  <xsl:for-each select="CustomFunction">
					  <!--SORTBYNAME-->
					  <!--<xsl:sort select="@name"/>-->
					  <tr class="regularcharttext" vAlign="top">
						  <td>
							  <xsl:call-template name="CustomFunctionAnchor">
								  <xsl:with-param name="inCustomFunction" select="."/>
							  </xsl:call-template>
						  </td>
						  <td>
							  <xsl:value-of select="@parameters"/>
						  </td>						
						  <td>
							  <xsl:choose>
								  <xsl:when test="@visible = 'True'">
									  <xsl:value-of select="$valAllAccounts"/>
								  </xsl:when>
								  <xsl:otherwise>
									  <xsl:value-of select="$valOnlyAccountsFullPrivilege"/>
								  </xsl:otherwise>
							  </xsl:choose>
						  </td>						
						  <td>
							  <xsl:call-template name="GenerateCalc">
								  <xsl:with-param name="inDisplayCalc" select="."/>
							  </xsl:call-template>
						  </td>
  						
						  <!--References to field defintion-->						
						  <xsl:variable name="customFuncName" select="@name"/>
						  <td>
							  <xsl:variable name="fieldDefList" select="/FMPReport/File/BaseTableCatalog/BaseTable/FieldCatalog/Field[DisplayCalculation/Chunk[@type = 'CustomFunctionRef' and text() = $customFuncName] or AutoEnter/DisplayCalculation/Chunk[@type = 'CustomFunctionRef' and text() = $customFuncName] or Validation/DisplayCalculation/Chunk[@type = 'CustomFunctionRef' and text() = $customFuncName]]"/>
							  <ul>
								  <xsl:for-each select="$fieldDefList">
									  <li>
										  <xsl:call-template name="FieldDefinitionReference">
											  <xsl:with-param name="inFieldDefinition" select="."/>
										  </xsl:call-template>
									  </li>
								  </xsl:for-each>
							  </ul>
						  </td>						
						  <td>
							  <xsl:variable name="scriptList" select="/FMPReport/File/ScriptCatalog/Script[*/*//Chunk[@type = 'CustomFunctionRef' and text() = $customFuncName]] | /FMPReport/File/ScriptCatalog//Group/Script[*/*//Chunk[@type = 'CustomFunctionRef' and text() = $customFuncName]]"/>
							  <xsl:if test="$scriptList">
								  <ul>
									  <xsl:for-each select="$scriptList">
										  <!--SORTBYNAME-->
										  <!--<xsl:sort select="@name"/>-->
										  <li>
											  <xsl:call-template name="ScriptReference">
												  <xsl:with-param name="inScript" select="."/>
											  </xsl:call-template>
										  </li>
									  </xsl:for-each>
								  </ul>
							  </xsl:if>
						  </td>
					  </tr>
				  </xsl:for-each>
        </tbody>
      </table>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="Table-ValueListCatalog" match="ValueListCatalog">
    <xsl:if test="ValueList">
      <p>
        <span class="partheading">
				  <xsl:call-template name="AnchorPoint">
					  <xsl:with-param name="inAnchor" select="concat('valValueLists', $kAnchorSection)"/>
					  <xsl:with-param name="inDisplayText" select="$valValueLists"/>
				  </xsl:call-template>				
        </span>
      </p>
      <table width="95%" border="1">
        <tbody>
				  <tr class="chartheaders" vAlign="top">
					  <td width="20%">
						  <xsl:value-of select="$valValueListName"/>
					  </td>
					  <td width="19%">
						  <xsl:value-of select="$valSource"/>
					  </td>
					  <td width="36%">
						  <xsl:value-of select="$valValues"/>
					  </td>
					  <td width="25%">
						  <xsl:value-of select="$valOnLayouts"/>
					  </td>
				  </tr>
				  <xsl:for-each select="ValueList">
					  <!--SORTBYNAME-->
					  <!--<xsl:sort select="@name"/>-->
					  <tr class="regularcharttext">
						  <td>
							  <xsl:call-template name="VLAnchor">
								  <xsl:with-param name="inVL" select="."/>
							  </xsl:call-template>
						  </td>
						  <td>
							  <xsl:call-template name="VLSource">
								  <xsl:with-param name="inSourceValue" select="Source/@value"/>
							  </xsl:call-template>
						  </td>
						  <td>
							  <ul>
								  <xsl:if test="Source/@value = 'Custom' and CustomValues">
									  <li>
										  <xsl:call-template name="ReplaceString">
											  <xsl:with-param name="inputString" select="CustomValues/Text"/>
											  <xsl:with-param name="findString" select="'&#xa;'"/>
											  <xsl:with-param name="replaceString" select="', '"/>
										  </xsl:call-template>										
									  </li>
								  </xsl:if>
								  <xsl:if test="Source/@value ='Field'">
									  <xsl:if test="PrimaryField">
										  <xsl:value-of select="$valPrimaryField"/>
										  <li>
											  <xsl:value-of select="concat($valField,': ')"/>
											  <xsl:call-template name="FieldReference-ShowTableAlias">
												  <xsl:with-param name="inField" select="PrimaryField/Field"/>
											  </xsl:call-template>
										  </li>
										  <br/>
									  </xsl:if>
									  <xsl:if test="SecondaryField">
										  <xsl:value-of select="$valSecondaryField"/>
										  <li>
											  <xsl:value-of select="concat($valField,': ')"/>
											  <xsl:call-template name="FieldReference-ShowTableAlias">
												  <xsl:with-param name="inField" select="SecondaryField/Field"/>
											  </xsl:call-template>
										  </li>	
										  <br/>
									  </xsl:if>
									  <xsl:if test="SecondaryField/@show = 'True'">
										  <li>
											  <xsl:value-of select="$valShowValuesOnlyFromSecondField"/>
										  </li>
									  </xsl:if>
									  <xsl:if test="PrimaryField/@sort='True'">
										  <li>
											  <xsl:value-of select="$valSortByFirstField"/>
										  </li>
										  <xsl:if test="PrimaryField/@resortLanguage!=''">
											  <li>
												  <xsl:value-of select="concat($valResortLanguage,': ')"/>
												  <xsl:call-template name="Language">
													  <xsl:with-param name="inLang" select="PrimaryField/@resortLanguage"/>
												  </xsl:call-template>
											  </li>										
										  </xsl:if>
									  </xsl:if>
									  <xsl:if test="SecondaryField/@sort='True'">
										  <li>
											  <xsl:value-of select="$valSortBySecondField"/>
										  </li>
										  <xsl:if test="SecondaryField/@resortLanguage!=''">
											  <li>
												  <xsl:value-of select="concat($valResortLanguage,': ')"/>
												  <xsl:call-template name="Language">
													  <xsl:with-param name="inLang" select="SecondaryField/@resortLanguage"/>
												  </xsl:call-template>
											  </li>
										  </xsl:if>
									  </xsl:if>
									  <xsl:if test="ShowRelated/@value = 'True'">
										  <li>
											  <xsl:value-of select="concat($valTableOccurrence,': ')"/>
											  <xsl:call-template name="TableAliasReferenceGivenName">
												  <xsl:with-param name="inTableAliasName" select="ShowRelated/Table/@name"/>
											  </xsl:call-template>
										  </li>
									  </xsl:if>
								  </xsl:if>
								  <xsl:if test="Source/@value='External' and External">
									  <li>
										  <xsl:value-of select="concat($valFileReference, ': ')"/>
										  <xsl:call-template name="FileRefReference">
											  <xsl:with-param name="inFileReference" select="External/FileReference"/>											
										  </xsl:call-template>
									  </li>
									  <li>
										  <xsl:value-of select="concat($valValueList, ': ')"/>
										  <xsl:call-template name="ExternalVLReference">
											  <xsl:with-param name="inExternalVL" select="External/ValueList"/>
											  <xsl:with-param name="inFileRef" select="External/FileReference"/>	
										  </xsl:call-template>
									  </li>
								  </xsl:if>
							  </ul>
						  </td>
						  <td>
							  <ul>
								  <xsl:variable name="valuelistName" select="@name"/>								
								  <xsl:for-each select="key('LayoutByVLIndex',$valuelistName)">
									  <!--SORTBYNAME-->
									  <!--<xsl:sort select="@name"/>-->
									  <li>
										  <xsl:call-template name="LayoutReference">
											  <xsl:with-param name="inLayout" select="."/>
										  </xsl:call-template>
									  </li>
								  </xsl:for-each>
							  </ul>
						  </td>
					  </tr>
				  </xsl:for-each>
        </tbody>
      </table>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="VLSource">
    <xsl:param name="inSourceValue"/>
    <xsl:choose>
      <xsl:when test="$inSourceValue = 'Field'">
				<xsl:value-of select="$valField"/>
      </xsl:when>
      <xsl:when test="$inSourceValue = 'Custom'">
				<xsl:value-of select="$valCustom"/>
      </xsl:when>
      <xsl:when test="$inSourceValue = 'External'">
				<xsl:value-of select="$valExternal"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
  
  <!--Script Catalog-->
  <xsl:template name="Table-ScriptCatalog" match="ScriptCatalog">
    <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valScripts', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valScriptHierarchy"/>
				</xsl:call-template>					
      </span>
    </p>

    <xsl:call-template name="ScriptHierarchy"/>
    <br/>
    <xsl:call-template name="ScriptDetails"/>
  </xsl:template>

  <!-- Script Navigation Bar -->
  <xsl:template name="ScriptNavBar">
    <table class="script_navbar">
      <tbody>
				<tr class="script_navbar">
					<a name="{concat(@id, $kAnchorScript)}"/>
					<td class="script_navbar">
						<xsl:for-each select="preceding-sibling::Script[1]">
							<a href="#{concat(@id, $kAnchorScript)}">
								<span>
									<xsl:value-of select="concat($valPreviousScript, ': [', @name, ']')"/>
								</span>
							</a>
						</xsl:for-each>
					</td>
					<td class="script_navbar">
						<xsl:for-each select="parent::Group[1]">
							<a href="#{concat(@id, $kAnchorScript)}">
								<span>
									<xsl:value-of select="concat($valParentGroup, ': [', @name, ']')"/>
								</span>
							</a>
						</xsl:for-each>
					</td>
					<td class="script_navbar">
						<xsl:for-each select="following-sibling::Script[1]">
							<a href="#{concat(@id, $kAnchorScript)}">
								<span>
									<xsl:value-of select="concat($valNextScript, ': [', @name, ']')"/>
								</span>
							</a>
						</xsl:for-each>
					</td>
				</tr>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template name="ScriptDetails">
    <xsl:for-each select="Script">
      <xsl:call-template name="ScriptNavBar"/>
      <xsl:call-template name="Table-Script"/>
      <br/>
    </xsl:for-each>

    <xsl:for-each select="Group">
      <p>
				<span class="partheading">
					<a name="{concat(@id, $kAnchorScript)}"/>
					<a href="#{concat(@id, $kAnchorScript, 'toc')}"><xsl:value-of select="@name"/></a>
				</span>
      </p>
      <xsl:call-template name="ScriptDetails"/>
    </xsl:for-each>					
  </xsl:template>

  <!-- Script Hierarchy -->
  <xsl:template name="ScriptHierarchy">
    <table class="script_hier">
      <tbody>
				<xsl:for-each select="*">
 					<tr>
						<td class="script_hier">
							<a name="{concat(@id, $kAnchorScript, 'toc')}"/>
							<a href="#{concat(@id, $kAnchorScript)}">
								<xsl:value-of select="@name"/>
							</a>
						</td>
					</tr>
					<xsl:if test="name() = 'Group'">
						<tr>
							<td class="script_hier">
								<table class="script_hier">
									<tbody>
										<tr class="script_hier_guide">
											<td class="script_hier_spacer"/>
											<td class="script_hier">
												<xsl:call-template name="ScriptHierarchy"/>
											</td>
										</tr>
									</tbody>
								</table>
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <!--Script-->
  <xsl:template name="Table-Script">
    <table width="100%" border="1">
      <tbody>
				<tr class="privsetfirst" vAlign="top">
					<td width="35%">
						<xsl:value-of select="$valScriptName"/>
					</td>
					<td width="65%">
						<xsl:value-of select="@name"/>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valRunScriptFullAccess"/>
					</td>
					<td class="regularcharttext">
						<xsl:call-template name="GetState">
							<xsl:with-param name="inValue" select="@runFullAccess"/>
						</xsl:call-template>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valIncludeInMenu"/>
					</td>
					<td class="regularcharttext">
						<xsl:choose>
							<xsl:when test="@includeInMenu='True'">
								<xsl:value-of select="$valYes"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$valNo"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<xsl:variable name="scriptId" select="@id"/>
				<xsl:variable name="scriptName" select="@name"/>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valLayoutsUseThisScript"/>
					</td>
					<td class="regularcharttext">
						<ul>																			
							<xsl:for-each select="key('LayoutByScriptIndex', $scriptId)">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<li>
									<xsl:call-template name="LayoutReference">
										<xsl:with-param name="inLayout" select="."/>
									</xsl:call-template>
								</li>								
							</xsl:for-each>			
						</ul>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valScriptsUseThisScript"/>
					</td>
					<td class="regularcharttext">
						<ul>						
							<xsl:for-each select="(/FMPReport/File/ScriptCatalog/Script | /FMPReport/File/ScriptCatalog//Group/Script)[StepList/Step/Script[@name = $scriptName and @id=$scriptId] and not(StepList/Step[child::FileReference])]">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<li>
                  <xsl:call-template name="ScriptReference">
                    <xsl:with-param name="inScript" select="."/>
                  </xsl:call-template>
								</li>								
							</xsl:for-each>	
						</ul>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartsubheads" colSpan="2">
						<xsl:value-of select="$valScriptDefinition"/>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valScriptSteps"/>
					</td>
					<td class="regularcharttext">
						<ul>
							<xsl:for-each select="StepList/Step">
								<li>
									<xsl:value-of select="StepText"/>
								</li>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
				<xsl:variable name="fieldList" select="StepList/Step//Field"/>
				<xsl:variable name="tableOccurrenceList" select="StepList/Step//Table"/>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valFieldsUsedInScript"/>
					</td>
					<td class="regularcharttext">
						<ul>
							<xsl:for-each select="$fieldList">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<xsl:variable name="field" select="."/>
								<xsl:if test="generate-id($fieldList[(@name = $field/@name) and (@table = $field/@table)][1]) = generate-id(.)">
									<xsl:choose>
										<xsl:when test="$field/parent::Criteria/parent::RequestRow/parent::Query/parent::Step/Restore/@state='False'">											
										</xsl:when>
										<xsl:when test="$field/parent::PrimaryField/parent::Sort/parent::SortList/parent::Step/Restore/@state='False'">
										</xsl:when>
										<xsl:when test="$field/parent::SummaryField/parent::Sort/parent::SortList/parent::Step/Restore/@state='False'">
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="parent::SummaryField and @id = '0'">
												</xsl:when>
												<xsl:otherwise>
													<li>
														<xsl:call-template name="FieldReference-ShowTableAlias">
															<xsl:with-param name="inField" select="."/>
														</xsl:call-template>
													</li>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</xsl:for-each>
						</ul>
					</td>
				</tr>	
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valScriptsUsedInScript"/>
					</td>
					<td class="regularcharttext">
						<ul>
							<xsl:variable name="scriptList" select="StepList/Step//Script"/>
							<xsl:for-each select="$scriptList">	
								<!--SORTBYNAME-->							
								<!--<xsl:sort select="@name"/>-->
								<xsl:variable name="script" select="."/>
								<xsl:if test="generate-id($scriptList[(@name = $script/@name) and (@id = $script/@id)][1]) = generate-id(.)">
									<li>
										<xsl:variable name="fileRef" select="preceding-sibling::FileReference"/>
										<xsl:choose>
											<xsl:when test="$fileRef">
												<xsl:call-template name="ExternalScriptReference">
													<xsl:with-param name="inFileRef" select="$fileRef"/>
													<xsl:with-param name="inScript" select="$script"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="ScriptReference">
													<xsl:with-param name="inScript" select="$script"/>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</li>
								</xsl:if>							
							</xsl:for-each>
						</ul>
					</td>
				</tr>			
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valLayoutsUsedInScript"/>
					</td>
					<td class="regularcharttext">
						<ul>
							<xsl:variable name="layoutList" select="StepList/Step//Layout"/>
							<xsl:for-each select="$layoutList">
								<!--SORTBYNAME-->
								<!--<xsl:sort select="@name"/>-->
								<xsl:variable name="layout" select="."/>
								<xsl:if test="generate-id($layoutList[(@name = $layout/@name) and (@id = $layout/@id)][1]) = generate-id(.)">
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="."/>
										</xsl:call-template>
									</li>
								</xsl:if>
							</xsl:for-each>
						</ul>
					</td>
				</tr>

				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valTablesUsedInScript"/>
					</td>
					<td class="regularcharttext">
						<ul>							
							<xsl:for-each select="$fieldList">	
								<xsl:sort select="key('BaseTable-TableAliasIndex',@table)[1]/@baseTable"/>								
								<xsl:choose>
									<xsl:when test="parent::Criteria/parent::RequestRow/parent::Query/parent::Step/Restore/@state='False'">											
									</xsl:when>
									<xsl:when test="parent::PrimaryField/parent::Sort/parent::SortList/parent::Step/Restore/@state='False'">
									</xsl:when>
									<xsl:when test="parent::SummaryField/parent::Sort/parent::SortList/parent::Step/Restore/@state='False'">
									</xsl:when>
									<xsl:otherwise>
										
										<xsl:variable name="field" select="."/>
										<xsl:variable name="uniqueFieldList" select="$fieldList[@table = $field/@table]"/>
										
										<xsl:if test="generate-id(.) = generate-id($uniqueFieldList[1])">									
											<!--sort according to base table names!!-->
											
											<xsl:variable name="tableAlias" select="/FMPReport/File/RelationshipGraph/TableList/Table[@name = $field/@table]"/>								
											<xsl:if test="generate-id($fieldList[
																		(@name = $field/@name) 
																		and (key('BaseTable-TableAliasIndex',@table)[1]/@baseTable = $tableAlias/@baseTable)
																		and (string(key('BaseTable-TableAliasIndex',@table)[1]/FileReference/@name) = string($tableAlias/FileReference/@name))
																		
																		][1]) = generate-id(.)">
												<li>
													<xsl:call-template name="BaseTableRefGivenTableAlias">
														<xsl:with-param name="inTableAlias" select="$tableAlias"/>
													</xsl:call-template>
												</li>
											</xsl:if>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valTableOccurrencesUsedInScript"/>
					</td>
					<td class="regularcharttext">
						<ul>
							<xsl:for-each select="$fieldList">								
								<xsl:sort select="@table"/>
								<xsl:choose>
									<xsl:when test="parent::Criteria/parent::RequestRow/parent::Query/parent::Step/Restore/@state='False'">											
									</xsl:when>
									<xsl:when test="parent::PrimaryField/parent::Sort/parent::SortList/parent::Step/Restore/@state='False'">
									</xsl:when>
									<xsl:when test="parent::SummaryField/parent::Sort/parent::SortList/parent::Step/Restore/@state='False'">
									</xsl:when>
									<xsl:otherwise>
										
										<xsl:variable name="field" select="."/>
										<xsl:if test="generate-id($fieldList[@table = $field/@table][1]) = generate-id(.)">
											<xsl:variable name="tableOccurrence" select="key('BaseTable-TableAliasIndex',$field/@table)"/>
											<xsl:if test="$tableOccurrence">
												<li>
													<xsl:call-template name="TableAliasReference">
														<xsl:with-param name="inTableAlias" select="$tableOccurrence"/>
													</xsl:call-template>
												</li>
											</xsl:if>
										</xsl:if>							
									</xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
							<xsl:for-each select="$tableOccurrenceList">
								<xsl:variable name="tableOccurrenceName" select="@name"/>
								<xsl:if test=" not($fieldList[@table = $tableOccurrenceName])">
									<li>
                    					<xsl:variable name="tableOccurrence" select="key('BaseTable-TableAliasIndex',$tableOccurrenceName)"/>
                    						<xsl:choose>
                      							<xsl:when test="$tableOccurrence">
                        							<xsl:call-template name="TableAliasReference">
                          								<xsl:with-param name="inTableAlias" select="$tableOccurrence"/>
                        							</xsl:call-template>
                      							</xsl:when>
                      						<xsl:otherwise>
                        							<xsl:call-template name="TableAliasReference">
                          								<xsl:with-param name="inTableAlias" select="."/>
                        							</xsl:call-template>
                      						</xsl:otherwise>
                    					</xsl:choose>
                  					</li>
								</xsl:if>
							</xsl:for-each>
						</ul>
					</td>
				</tr>			
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valCustomFunctionsUsedInScript"/>
					</td>
					<td class="regularcharttext">
						<ul>
							<xsl:variable name="chunkList" select="StepList/Step/*//Chunk[@type = 'CustomFunctionRef']"/>
							<xsl:for-each select="$chunkList">
								<!--Sort according to function name!!-->
								<!--SORTBYNAME-->
								<!--<xsl:sort select="text()"/>-->
								<xsl:variable name="chunk" select="."/>
								<!--Remove duplicates-->
								<xsl:if test="generate-id($chunkList[text() = $chunk/text()][1]) = generate-id(.)">
									<li>
										<xsl:call-template name="CustomFunctionReference">
											<xsl:with-param name="inCustomFunctionName" select="$chunk/text()"/>
										</xsl:call-template>
									</li>
								</xsl:if>
							</xsl:for-each>							
						</ul>
					</td>
				</tr>		
				<tr vAlign="top">
					<td class="chartheadersnobg">
						<xsl:value-of select="$valCustomMenuSetUsedByScript"/>
					</td>
					<td class="regularcharttext">
						<ul>
							<xsl:variable name="customMenuList" select="StepList/Step/CustomMenuSet"/>
							<xsl:for-each select="$customMenuList">
								<li>
									<xsl:call-template name="CustomMenuSetReference">
										<xsl:with-param name="inCustomMenuSet" select="."/>
									</xsl:call-template>
								</li>
							</xsl:for-each>							
						</ul>
					</td>
				</tr>		
      </tbody>
    </table>
  </xsl:template>
  
  <!--Don't do anything, already handled-->
  <xsl:template name="Options" match="Options">
  </xsl:template>
  
  <xsl:template name="Language">
    <xsl:param name="inLang"/>
    <xsl:choose>
      <xsl:when test="$inLang = 'Unicode_Raw'">
				<xsl:value-of select="$valUnicode_Raw"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Unicode_Standard'">
				<xsl:value-of select="$valUnicode_Standard"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Catalog'">
				<xsl:value-of select="$valCatalog"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Catalan'">
				<xsl:value-of select="$valCatalan"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Croatian'">
				<xsl:value-of select="$valCroatian"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Czech'">
				<xsl:value-of select="$valCzech"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Danish'">
				<xsl:value-of select="$valDanish"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Dutch'">
				<xsl:value-of select="$valDutch"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Unicode_Raw'">
				<xsl:value-of select="$valUnicode_Raw"/>
      </xsl:when>
      <xsl:when test="$inLang = 'English'">
				<xsl:value-of select="$valEnglish"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Finnish'">
				<xsl:value-of select="$valFinnish"/>
      </xsl:when>
      <xsl:when test="$inLang = 'Finnish_Custom'">
				<xsl:value-of select="$valFinnish_Custom"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Finnish_Custom'">
				<xsl:value-of select="$valFinnish_Custom"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'French'">
				<xsl:value-of select="$valFrench"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'German'">
				<xsl:value-of select="$valGerman"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'German_Dictionary'">
				<xsl:value-of select="$valGerman_Dictionary"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Greek'">
				<xsl:value-of select="$valGreek"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Hungarian'">
				<xsl:value-of select="$valHungarian"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Icelandic'">
				<xsl:value-of select="$valIcelandic"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Italian'">
				<xsl:value-of select="$valItalian"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Japanese'">
				<xsl:value-of select="$valJapanese"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Norwegian'">
				<xsl:value-of select="$valNorwegian"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Polish'">
				<xsl:value-of select="$valPolish"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Portuguese'">
				<xsl:value-of select="$valPortuguese"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Romanian'">
				<xsl:value-of select="$valRomanian"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Russian'">
				<xsl:value-of select="$valRussian"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Slovak'">
				<xsl:value-of select="$valSlovak"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Slovenian'">
				<xsl:value-of select="$valSlovenian"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Spanish'">
				<xsl:value-of select="$valSpanish"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Spanish_Traditional'">
				<xsl:value-of select="$valSpanish_Traditional"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Swedish'">
				<xsl:value-of select="$valSwedish"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Swedish_Custom'">
				<xsl:value-of select="$valSwedish_Custom"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Turkish'">
				<xsl:value-of select="$valTurkish"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Ukrainian'">
				<xsl:value-of select="$valUkrainian"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Chinese'">
				<xsl:value-of select="$valChinesePinYin"/>
      </xsl:when>	
      <xsl:when test="$inLang = 'Chinese_Stroke'">
				<xsl:value-of select="$valChineseStroke"/>
      </xsl:when>	
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="CustomMenu-Table" match="CustomMenuCatalog">
    <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valCustomMenus', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valCustomMenus"/>
				</xsl:call-template>
      </span>
    </p>
    <xsl:for-each select="CustomMenu">
      <table border="1" cellpadding="1" cellspacing="1" width="100%">
				<tbody>
					<tr class="chartheaders" valign="top">
						<td colspan="7" class="privsetfirst">
							<xsl:value-of select="concat($valMenuName,': ')"/>
							<xsl:call-template name="CustomMenuAnchor">
								<xsl:with-param name="inCustomMenu" select="."/>
							</xsl:call-template>
						</td>
					</tr>
					<tr valign="top">
						<td colspan="3" class="chartheadersnobg" width="46%"><xsl:value-of select="$valCustomMenuSets"/></td>
						<td colspan="4" class="regularcharttext">
							<xsl:variable name="customMenuName" select="@name"/>
							<ul>
								<xsl:for-each select="/FMPReport/File/CustomMenuSetCatalog/CustomMenuSet[CustomMenuList/CustomMenu[@name = $customMenuName]]">
									<li>
										<xsl:call-template name="CustomMenuSetReference">
											<xsl:with-param name="inCustomMenuSet" select="."/>
										</xsl:call-template>
									</li>
								</xsl:for-each>
							</ul>
						</td>
					</tr>
					<tr valign="top">
						<td colspan="3" class="chartheadersnobg" width="46%"><xsl:value-of select="$valDefaultMenuTitle"/></td>
						<td colspan="4" class="regularcharttext"><xsl:value-of select="BaseMenu/@name"/></td>
					</tr>
					<tr valign="top">
						<td colspan="3" class="chartheadersnobg" width="46%"><xsl:value-of select="$valComments"/></td>
						<td colspan="4" class="regularcharttext"><xsl:value-of select="Comment"/></td>
					</tr>
					<tr class="chartsubheads" valign="top">
						<td colspan="7"><xsl:value-of select="$valMenuOptions"/></td>
					</tr>
					<tr valign="top">
						<td colspan="3" class="chartheadersnobg" width="46%"><xsl:value-of select="$valOverrideDisplayTitle"/></td>
						<td colspan="4" class="regularcharttext">
							<xsl:call-template name="GenerateCalc">
								<xsl:with-param name="inDisplayCalc" select="Title"></xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
					<tr valign="top">
						<td colspan="3" class="chartheadersnobg" width="46%"><xsl:value-of select="$valMenuPlatform"/></td>
						<td colspan="4" class="regularcharttext">
							<xsl:if test="Options/@winPlatform = 'True'">
								<xsl:value-of select="$valWindows"/>
							</xsl:if>
							<xsl:if test="Options/@macPlatform = 'True'">
								<xsl:if test="Options/@winPlatform = 'True'">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="$valMacintosh"/>
							</xsl:if>
						</td>
					</tr>
					<tr valign="top">
						<td colspan="3" class="chartheadersnobg" width="46%"><xsl:value-of select="$valMenuMode"/></td>
						<td colspan="4" class="regularcharttext">
							<xsl:if test="Options/@browseMode = 'True'">
								<xsl:value-of select="$valBrowse"/>
							</xsl:if>
							<xsl:if test="Options/@findMode = 'True'">
								<xsl:if test="Options/@browseMode = 'True'">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="$valFind"/>
							</xsl:if>
							<xsl:if test="Options/@previewMode = 'True'">
								<xsl:if test="Options/@browseMode = 'True' or Options/@findMode='True'">
									<xsl:value-of select="', '"/>
								</xsl:if>
								<xsl:value-of select="$valPreview"/>
							</xsl:if>
						</td>
					</tr>
					<xsl:if test="MenuItemList">
						<tr class="chartsubheads" valign="top">
							<td colspan="7"><xsl:value-of select="$valMenuItems"/></td>
						</tr>
						<tr class="regularcharttext" valign="top">
							<td class="chartsubheads" width="14%"><xsl:value-of select="$valType"/></td>
							<td class="chartsubheads" width="15%"><xsl:value-of select="$valCommand"/></td>
							<td class="chartsubheads" width="17%"><xsl:value-of select="$valPlatform"/></td>
							<td class="chartsubheads" width="20%"><xsl:value-of select="$valOverrideTitle"/></td>
							<td class="chartsubheads" width="17%"><xsl:value-of select="$valOverrideAction"/></td>
							<td class="chartsubheads" width="17%"><xsl:value-of select="$valOverrideShortcut"/></td>
						</tr>
						<xsl:for-each select="MenuItemList/MenuItem">
							<tr class="regularcharttext" valign="top">
								<td>
									<xsl:call-template name="MenuItemType">
										<xsl:with-param name="inMenuItem" select="."/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:choose>
										<xsl:when test="Command/@name">
											<xsl:value-of select="Command/@name"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:if test="@isSeparatorItem = 'False' and @isSubMenuItem='False'">
												<xsl:value-of select="concat('&lt;',$valNone,'&gt;')"/>
											</xsl:if>											
										</xsl:otherwise>
									</xsl:choose>
								</td>
								<td>
									<xsl:if test="@winPlatform = 'True'">
										<xsl:value-of select="$valWindows"/>
									</xsl:if>
									<xsl:if test="@macPlatform = 'True'">
										<xsl:if test="@winPlatform = 'True'">
											<xsl:value-of select="', '"/>
										</xsl:if>
										<xsl:value-of select="$valMacintosh"/>
									</xsl:if>
								</td>
								<td>
									<xsl:call-template name="GenerateCalc">
										<xsl:with-param name="inDisplayCalc" select="Name"/>
									</xsl:call-template>
								</td>
								<td>
									<xsl:if test="@overrideAction = 'True' and Step">
										<xsl:value-of select="Step/StepText"/>
										<xsl:variable name="actionFieldList" select="Step//Field"/>
										<xsl:if test="$actionFieldList">
											<p><b><xsl:value-of select="$valFields"/></b></p>
											<ul>
												<xsl:for-each select="$actionFieldList">
													<li>
														<xsl:call-template name="FieldReference-ShowTableAlias">
															<xsl:with-param name="inField" select="."/>
														</xsl:call-template>
													</li>
												</xsl:for-each>
											</ul>
										</xsl:if>
										<xsl:variable name="actionScriptList" select="Step/Script"/>
										<xsl:if test="$actionScriptList">
											<p><b><xsl:value-of select="$valScripts"/></b></p>
											<ul>
												<xsl:for-each select="$actionScriptList">
													<li>
														<xsl:call-template name="ScriptReference">
															<xsl:with-param name="inScript" select="."/>
														</xsl:call-template>
													</li>
												</xsl:for-each>
											</ul>
										</xsl:if>
										<xsl:variable name="layoutRefList" select="Step/Layout"/>
										<xsl:if test="$layoutRefList">
											<p><b><xsl:value-of select="concat($valLayouts,':')"/></b></p>
											<ul>
												<xsl:for-each select="$layoutRefList">
													<li>
														<xsl:call-template name="LayoutReference">
															<xsl:with-param name="inLayout" select="."/>
														</xsl:call-template>		
													</li>
												</xsl:for-each>
											</ul>
										</xsl:if>
									</xsl:if>
								</td>
								<td>
									<xsl:if test="Shortcut">
										<xsl:call-template name="ShortcutString">
											<xsl:with-param name="inShortcut" select="Shortcut"/>
										</xsl:call-template>
									</xsl:if>
								</td>
							</tr>
						</xsl:for-each>
					</xsl:if>
				</tbody>
      </table>
    </xsl:for-each>
  </xsl:template>
  
  <!--MenuItem type-->
  <xsl:template name="MenuItemType">
    <xsl:param name="inMenuItem"/>
    <xsl:choose>
      <xsl:when test="$inMenuItem/@isSeparatorItem = 'True'">
				<xsl:value-of select="$valSeparator"/>
      </xsl:when>
      <xsl:when test="$inMenuItem/@isSubMenuItem = 'True'">
				<xsl:value-of select="concat($valSubMenu,': ')"/>
				<xsl:call-template name="CustomMenuReference">
					<xsl:with-param name="inCustomMenu" select="CustomMenu"/>
				</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$valCommand"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!--Custom menu set-->
  <xsl:template name="CustomMenuSet-Table" match="CustomMenuSetCatalog">
    
    <p>
      <span class="partheading">
				<xsl:call-template name="AnchorPoint">
					<xsl:with-param name="inAnchor" select="concat('valCustomMenuSets', $kAnchorSection)"/>
					<xsl:with-param name="inDisplayText" select="$valCustomMenuSets"/>
				</xsl:call-template>
      </span>
    </p>
    
    <table border="1" cellpadding="1" cellspacing="1" width="100%">
      <tbody>
				<tr class="chartheaders" valign="top">
					<td width="20%"><xsl:value-of select="$valMenuSets"/></td>
					<td width="20%"><xsl:value-of select="$valMenus"/></td>
					<td width="20%"><xsl:value-of select="$valInScripts"/></td>
					<td width="20%"><xsl:value-of select="$valInLayouts"/></td>
					<td width="20%"><xsl:value-of select="$valComments"/></td>
				</tr>
				<xsl:for-each select="CustomMenuSet">
					<tr class="regularcharttext" valign="top">
						<td>
							<xsl:call-template name="CustomMenuSetAnchor">
								<xsl:with-param name="inCustomMenuSet" select="."/>
							</xsl:call-template>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="@id = '1'">
									<ul>
										<li>
											<xsl:value-of select="$valAllStandardMenus"/>
										</li>
									</ul>									
								</xsl:when>
								<xsl:otherwise>
									<ul>
										<xsl:for-each select="CustomMenuList/CustomMenu">
											<li>
												<xsl:call-template name="CustomMenuReference">
													<xsl:with-param name="inCustomMenu" select="."/>
												</xsl:call-template>
											</li>
										</xsl:for-each>
									</ul>
								</xsl:otherwise>
							</xsl:choose>							
						</td>
						<xsl:variable name="currentCustomMenuSet" select="."/>
						<td>
							<xsl:variable name="scriptRefList" select="/FMPReport/File/ScriptCatalog/Script[.//CustomMenuSet[@name = $currentCustomMenuSet/@name]] | /FMPReport/File/ScriptCatalog//Group/Script[.//CustomMenuSet[@name = $currentCustomMenuSet/@name]]"/>
							<xsl:if test="$scriptRefList">
								<xsl:for-each select="$scriptRefList">
									<li>
										<xsl:call-template name="ScriptReference">
											<xsl:with-param name="inScript" select="."/>
										</xsl:call-template>
									</li>
								</xsl:for-each>
							</xsl:if>	
						</td>
						<td>
							<xsl:variable name="layouttRefList" select="/FMPReport/File/LayoutCatalog//Layout[CustomMenuSet[@name = $currentCustomMenuSet/@name]]"/>
							<xsl:if test="$layouttRefList">
								<xsl:for-each select="$layouttRefList">
									<li>
										<xsl:call-template name="LayoutReference">
											<xsl:with-param name="inLayout" select="."></xsl:with-param>
										</xsl:call-template>
									</li>
								</xsl:for-each>
							</xsl:if>	
						</td>
						<td>
							<xsl:value-of select="Comment"/>
						</td>
					</tr>
				</xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:template name="ShorcutModifier">
    <xsl:param name="inShortcut"/>
    <xsl:variable name="ctrl">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inShortcut/@modifier"/>
				<xsl:with-param name="inBit" select="'4'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="$ctrl='true'">
      <xsl:value-of select="$valCtrl"/>
    </xsl:if>
    <xsl:variable name="shift">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inShortcut/@modifier"/>
				<xsl:with-param name="inBit" select="'1'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="$shift='true'">
      <xsl:if test="$ctrl='true'">
				<xsl:value-of select="' + '"/>
      </xsl:if>
      <xsl:value-of select="$valShift"/>
    </xsl:if>
    <xsl:variable name="alt">
      <xsl:call-template name="Bit">
				<xsl:with-param name="inVal" select="$inShortcut/@modifier"/>
				<xsl:with-param name="inBit" select="'2'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="$alt='true'">
      <xsl:if test="$shift='true' or $ctrl='true'">
				<xsl:value-of select="' + '"/>
      </xsl:if>
      <xsl:value-of select="$valAlt"/>
    </xsl:if>
    <xsl:if test="$alt='true' or $shift='true' or $ctrl='true'">
      <xsl:value-of select="' + '"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="ShorcutKey">
    <xsl:param name="inShortcut"/>		
    <xsl:choose>
      <xsl:when test="$inShortcut/@key = '57344'">
				<xsl:value-of select="$valPageUp"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57345'">
				<xsl:value-of select="$valPageDown"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57346'">
				<xsl:value-of select="$valEnd"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57347'">
				<xsl:value-of select="$valHome"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57348'">
				<xsl:value-of select="$valLeftArrow"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57349'">
				<xsl:value-of select="$valUpArrow"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57350'">
				<xsl:value-of select="$valRightArrow"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57351'">
				<xsl:value-of select="$valDownArrow"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57352'">
				<xsl:value-of select="$valInsert"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57353'">
				<xsl:value-of select="$valDelete"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57354'">
				<xsl:value-of select="$valHelp"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57355'">
				<xsl:value-of select="$valF1"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57356'">
				<xsl:value-of select="$valF2"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57357'">
				<xsl:value-of select="$valF3"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57358'">
				<xsl:value-of select="$valF4"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57359'">
				<xsl:value-of select="$valF5"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57360'">
				<xsl:value-of select="$valF6"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57361'">
				<xsl:value-of select="$valF7"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57362'">
				<xsl:value-of select="$valF8"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57363'">
				<xsl:value-of select="$valF9"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57364'">
				<xsl:value-of select="$valF10"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57365'">
				<xsl:value-of select="$valF11"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57366'">
				<xsl:value-of select="$valF12"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57367'">
				<xsl:value-of select="$valF13"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57368'">
				<xsl:value-of select="$valF14"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57369'">
				<xsl:value-of select="$valF15"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57370'">
				<xsl:value-of select="$valBack"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57371'">
				<xsl:value-of select="$valClear"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57372'">
				<xsl:value-of select="$valEscape"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57373'">
				<xsl:value-of select="$valTab"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57374'">
				<xsl:value-of select="$valSpace"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57375'">
				<xsl:value-of select="$valReturn"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57376'">
				<xsl:value-of select="$valCapital"/>
      </xsl:when>
      <xsl:when test="$inShortcut/@key = '57377'">
				<xsl:value-of select="$valEnter"/>
      </xsl:when>
      <xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&amp;#</xsl:text>	
				<xsl:value-of select="$inShortcut/@key"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="ShortcutString">
    <xsl:param name="inShortcut"/>
    <xsl:call-template name="ShorcutModifier">
      <xsl:with-param name="inShortcut" select="$inShortcut"/>
    </xsl:call-template>
    <xsl:call-template name="ShorcutKey">
      <xsl:with-param name="inShortcut" select="$inShortcut"/>
    </xsl:call-template>
  </xsl:template>
  
</xsl:stylesheet>
